/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;

public class RealLUTARGBColorConverter<R extends RealType<?>>
implements RealARGBColorConverter<R> {
    protected int[] lut;
    protected double scale;
    protected double min;
    protected double max;
    protected int black;

    public RealLUTARGBColorConverter(double min, double max, int[] lut) {
        this.min = min;
        this.max = max;
        this.lut = lut;
        this.update();
    }

    public boolean supportsColor() {
        return false;
    }

    private void update() {
        this.scale = (double)(this.lut.length - 1) / (this.max - this.min);
        this.black = this.lut[0];
    }

    public void convert(R input, ARGBType output) {
        int v = (int)Math.round(this.scale * (input.getRealDouble() - this.min));
        if (v < 0) {
            output.set(this.black);
        } else if (v > this.lut.length - 1) {
            output.set(this.lut[this.lut.length - 1]);
        } else {
            int index = Math.round(v);
            output.set(this.lut[index]);
        }
    }

    public ARGBType getColor() {
        return null;
    }

    public void setColor(ARGBType arg0) {
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }
}

