/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.SingleOperandPixelBasedAbstractFunction;
import net.imglib2.type.numeric.RealType;

public final class ImgLibCeil<T extends RealType<T>>
extends SingleOperandPixelBasedAbstractFunction<T> {
    public static final String DOCUMENTATION_STRING = "<h3>Element-wise ceiling</h3> This function computes the ceiling of an ImgLib image, by returningthe integer value that is greater than or equal to each pixel valueof its operand. Calculations are done using <i>Math.ceil</i>.";

    public ImgLibCeil() {
        this.numberOfParameters = 1;
    }

    @Override
    public final <R extends RealType<R>> float evaluate(R alpha) {
        return (float)Math.ceil(alpha.getRealDouble());
    }

    @Override
    public String getDocumentationString() {
        return DOCUMENTATION_STRING;
    }

    @Override
    public String getFunctionString() {
        return "ceil";
    }

    @Override
    public String toString() {
        return "Pixel-wise ceil";
    }
}

