/*
 * Decompiled with CFR 0.152.
 */
package fiji.process;

import fiji.expressionparser.ImgLibParser;
import fiji.process.Image_Expression_Parser;
import ij.CompositeImage;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.RGBStackSplitter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class IepGui<T extends RealType<T> & NativeType<T>>
extends JFrame
implements ImageListener,
WindowListener {
    private static final String PLUGIN_VERSION = "v2.2";
    private static final String PLUGIN_NAME = "Image Expression Parser";
    public static final String QUIT_ACTION_COMMAND = "Quit";
    public static final String PARSE_ACTION_COMMAND = "Parse";
    private static final long serialVersionUID = 1L;
    private static final int BOX_SPACE = 40;
    public static final String[] MESSAGES = new String[]{"Enter an expression using canonical mathematical functions, and capital single letters as variable specifying the chosen image.\n ImgLib algorithms are also supported. <p>Examples: <br>&nbsp&nbsp \u25a0 2*A<br>&nbsp&nbsp \u25a0 A*(B+30)<br>&nbsp&nbsp \u25a0 sqrt(A^2+B^2)*cos(C)<br>&nbsp&nbsp \u25a0 A > B<br>&nbsp&nbsp \u25a0 gauss(A, 0.8)<br><p><u>Supported ImgLib algorithms:</u><br><table border=\"1\"><tr><th>Description</th><th>Syntax</th></tr><tr><td>Gaussian convolution</td> <td>gauss(img, sigma)</td> </tr><tr><td>Floyd-Steinberg dithering</td> <td>dither(img)</td> </tr><tr><td>Image normalization (sum to 1)</td> <td>normalize(img)</td> </table> <p><u>Supported functions:</u><br><table border=\"1\"><tr><th>Description</th><th>Syntax</th></tr><tr><td>Euler constant</td> <td>e</td></tr><tr><td>\u03c0</td> <td>pi</td></tr><tr><td>Standard operators</td><td>+, -, *, /, ^, %</td></tr><tr><td>Sine</td><td>sin</td></tr><tr><td>Cosine</td><td>cos</td></tr><tr><td>Tangent</td><td>tan</td></tr><tr><td>Arc Sine</td><td>asin</td></tr><tr><td>Arc Cosine</td><td>acos</td></tr><tr><td>Arc Tangent</td><td>atan</td></tr><tr><td>Arc Tangent 2 args</td><td>atan2(y,x)</td></tr><tr><td>Hyperbolic Sine</td><td>sinh</td></tr><tr><td>Hyperbolic Cosine</td><td>cosh</td></tr><tr><td>Hyperbolic Tangent</td><td>tanh</td></tr><tr><td>Natural Logarithm</td><td>log</td></tr><tr><td>Exponential</td><td>exp</td></tr><tr><td>Power</td><td>pow</td></tr><tr><td>Square Root</td><td>sqrt</td></tr><tr><td>Absolute Value</td><td>abs</td></tr><tr><td>Round</td><td>round</td></tr><tr><td>Floor</td><td>floor</td></tr><tr><td>Ceiling</td><td>ceil</td></tr><tr><td>Boolean operators</td><td>!, &&, ||, <, >, !=, ==, >=, <=</td></table> ", "No images are opened.", "Image dimensions are incompatibles."};
    private int n_image_box = 0;
    private ArrayList<ImagePlus> images;
    private String[] image_names;
    private final ArrayList<JLabel> labels = new ArrayList();
    private final ArrayList<JComboBox<String>> image_boxes = new ArrayList();
    private String[] variables;
    private final DefaultComboBoxModel<String> expression_history = new DefaultComboBoxModel();
    private Image_Expression_Parser<T> image_expression_parser;
    private ImagePlus target_imp;
    private JPanel jPanelImages;
    private JSplitPane jSplitPane1;
    private JButton jButtonMinus;
    private JButton jButtonPlus;
    private JPanel jPanelLeftButtons;
    private JScrollPane jScrollPaneImages;
    private JPanel jPanelLeft;
    private JPanel jPanelRight;
    private JEditorPane jTextAreaInfo;
    private JScrollPane jScrollPane1;
    private JButton jButtonOK;
    private JButton jButtonCancel;
    private JComboBox<String> expressionField;
    private JLabel jLabelExpression;

    public static <T extends RealType<T> & NativeType<T>> void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IepGui inst = new IepGui();
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public IepGui() {
        this.initImageList();
        this.initGUI();
        this.addWindowListener(this);
        this.addImageBox();
        this.jButtonMinus.setEnabled(false);
        this.jTextAreaInfo.setText(MESSAGES[0]);
        this.jTextAreaInfo.setCaretPosition(0);
        ImagePlus.addImageListener((ImageListener)this);
    }

    public void setIep(Image_Expression_Parser<T> iep) {
        this.image_expression_parser = iep;
    }

    public Map<String, ImagePlus> getImageMap() {
        if (this.images.size() > 0) {
            HashMap<String, ImagePlus> image_map = new HashMap<String, ImagePlus>(this.variables.length);
            for (int i = 0; i < this.n_image_box; ++i) {
                JComboBox<String> box = this.image_boxes.get(i);
                ImagePlus imp = this.images.get(box.getSelectedIndex());
                String var = this.variables[i];
                image_map.put(var, imp);
            }
            return image_map;
        }
        return null;
    }

    public String getExpression() {
        String expression = (String)this.expressionField.getSelectedItem();
        if (null == expression) {
            return null;
        }
        return expression.trim();
    }

    private ImagePlus[] getImages() {
        if (this.images.size() > 0) {
            ImagePlus[] imps = new ImagePlus[this.variables.length];
            for (int i = 0; i < this.n_image_box; ++i) {
                JComboBox<String> box = this.image_boxes.get(i);
                if (box.getSelectedIndex() < 0) continue;
                imps[i] = this.images.get(box.getSelectedIndex());
            }
            return imps;
        }
        return null;
    }

    private boolean checkValid() {
        if (!this.isShowing()) {
            return true;
        }
        if (!this.compatibleDimensions()) {
            this.jButtonOK.setEnabled(false);
            for (JComboBox<String> box : this.image_boxes) {
                box.setForeground(Color.RED);
            }
            this.jTextAreaInfo.setText(MESSAGES[2]);
            this.jTextAreaInfo.setCaretPosition(0);
            return false;
        }
        String error = this.getExpressionError();
        if (error.length() != 0) {
            this.jButtonOK.setEnabled(false);
            this.expressionField.getEditor().getEditorComponent().setForeground(Color.RED);
            this.jTextAreaInfo.setText(error);
            this.jTextAreaInfo.setCaretPosition(0);
            return false;
        }
        this.jButtonOK.setEnabled(true);
        for (JComboBox<String> box : this.image_boxes) {
            box.setForeground(Color.BLACK);
        }
        this.expressionField.getEditor().getEditorComponent().setForeground(Color.BLACK);
        this.jTextAreaInfo.setText(MESSAGES[0]);
        this.jTextAreaInfo.setCaretPosition(0);
        return true;
    }

    private void addCurrentExpressionToHistory() {
        String current_expression = (String)this.expressionField.getSelectedItem();
        for (int i = 0; i < this.expression_history.getSize(); ++i) {
            String str = this.expression_history.getElementAt(i);
            if (!str.equals(current_expression)) continue;
            return;
        }
        this.expression_history.addElement(current_expression);
    }

    private boolean compatibleDimensions() {
        ImagePlus[] selected_images = this.getImages();
        if (null == selected_images) {
            return true;
        }
        if (selected_images.length <= 1) {
            return true;
        }
        int[] old_dim = selected_images[0].getDimensions();
        for (int i = 1; i < selected_images.length; ++i) {
            int[] dim = selected_images[i].getDimensions();
            if (dim.length != old_dim.length) {
                return false;
            }
            for (int j = 0; j < old_dim.length; ++j) {
                if (dim[j] == old_dim[j]) continue;
                return false;
            }
            old_dim = dim;
        }
        return true;
    }

    private String getExpressionError() {
        String expression = this.getExpression();
        if (null == expression || expression.equals("")) {
            return "";
        }
        ImgLibParser parser = new ImgLibParser();
        parser.addStandardConstants();
        parser.addStandardFunctions();
        parser.addImgLibAlgorithms();
        for (String var : this.variables) {
            parser.addVariable(var, null);
        }
        parser.parseExpression(expression);
        if (!parser.hasError()) {
            return "";
        }
        String error = parser.getErrorInfo();
        String[] errors = error.split("\\n");
        StringBuilder formatted_error = new StringBuilder();
        formatted_error.append("Found errors in expression:\n<p>");
        for (String str : errors) {
            if (str.startsWith("Encountered")) {
                Pattern column_getter = Pattern.compile("column \\d+");
                Matcher match = column_getter.matcher(str);
                if (match.find()) {
                    formatted_error.append("&nbsp&nbsp \u25a0 Syntax error in expression at column " + match.group().substring(7) + "\n");
                }
            } else {
                if (str.startsWith("Was expecting") || str.startsWith("    ")) continue;
                formatted_error.append("&nbsp&nbsp \u25a0 " + str + "\n");
            }
            formatted_error.append("<p>\n");
        }
        return formatted_error.toString();
    }

    private void addImageBox() {
        if (this.n_image_box >= 26) {
            return;
        }
        char c = (char)(65 + this.n_image_box);
        JLabel label = new JLabel(String.valueOf(c) + ":");
        this.jPanelImages.add(label);
        JComboBox<String> combo_box = new JComboBox<String>(this.image_names);
        this.jPanelImages.add(combo_box);
        combo_box.setSelectedIndex(Math.min(this.n_image_box, this.image_names.length - 1));
        int width = this.jPanelImages.getWidth();
        label.setBounds(10, 10 + 40 * this.n_image_box, 20, 25);
        combo_box.setBounds(30, 10 + 40 * this.n_image_box, width - 50, 30);
        combo_box.setFont(new Font("Arial", 0, 10));
        combo_box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IepGui.this.checkValid();
            }
        });
        this.labels.add(label);
        this.image_boxes.add(combo_box);
        this.jPanelImages.setPreferredSize(new Dimension(width, 50 + 40 * this.n_image_box));
        ++this.n_image_box;
        this.refreshVariableList();
        this.checkValid();
        if (this.n_image_box >= 26) {
            this.jButtonPlus.setEnabled(false);
        }
        if (this.n_image_box > 1) {
            this.jButtonMinus.setEnabled(true);
        }
    }

    private void removeImageBox() {
        if (this.n_image_box <= 1) {
            return;
        }
        --this.n_image_box;
        this.jPanelImages.remove(this.image_boxes.remove(this.n_image_box));
        this.jPanelImages.remove(this.labels.remove(this.n_image_box));
        int width = this.jPanelImages.getWidth();
        this.jPanelImages.setPreferredSize(new Dimension(width, 50 + 40 * this.n_image_box));
        this.jPanelImages.revalidate();
        this.jPanelImages.repaint();
        this.refreshVariableList();
        this.checkValid();
        if (this.n_image_box <= 1) {
            this.jButtonMinus.setEnabled(false);
        }
        if (this.n_image_box < 26) {
            this.jButtonPlus.setEnabled(true);
        }
    }

    private void initImageList() {
        int[] IDs = WindowManager.getIDList();
        if (null == IDs) {
            this.image_names = new String[]{MESSAGES[1]};
            this.images = new ArrayList();
            return;
        }
        this.images = new ArrayList(IDs.length);
        for (int i = 0; i < IDs.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)IDs[i]);
            this.images.add(imp);
        }
        this.refreshImageNames();
    }

    private void refreshImageNames() {
        this.image_names = this.images.size() < 1 ? new String[]{MESSAGES[1]} : new String[this.images.size()];
        for (int i = 0; i < this.images.size(); ++i) {
            this.image_names[i] = this.images.get(i).getTitle();
        }
        int max_index = this.images.size() - 1;
        for (JComboBox<String> box : this.image_boxes) {
            int current_index = box.getSelectedIndex();
            box.setModel(new DefaultComboBoxModel<String>(this.image_names));
            box.setSelectedIndex(Math.min(current_index, max_index));
        }
        if (this.isShowing()) {
            this.checkValid();
        }
    }

    private void refreshImageBoxes() {
        int width = this.jPanelImages.getWidth();
        for (int i = 0; i < this.n_image_box; ++i) {
            this.image_boxes.get(i).setBounds(30, 10 + 40 * i, width - 50, 30);
        }
    }

    private void refreshVariableList() {
        this.variables = new String[this.n_image_box];
        for (int i = 0; i < this.n_image_box; ++i) {
            char c = (char)(65 + i);
            this.variables[i] = String.valueOf(c);
        }
    }

    private void quitGui() {
        ImagePlus.removeImageListener((ImageListener)this);
        this.removeWindowListener(this);
        this.dispose();
    }

    private void launchCalculation() {
        boolean is_valid = this.checkValid();
        if (!is_valid) {
            return;
        }
        final Map<String, ImagePlus> imp_map = this.getImageMap();
        final String expression = this.getExpression();
        new Thread(){
            {
                this.setPriority(5);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IJ.showStatus((String)"IEP parsing....");
                IepGui.this.setGUIEnabled(false);
                try {
                    if (null == IepGui.this.image_expression_parser) {
                        IepGui.this.image_expression_parser = new Image_Expression_Parser();
                    }
                    IepGui.this.image_expression_parser.setExpression(expression);
                    Img result_img = null;
                    boolean is_rgb_image = false;
                    for (String key : imp_map.keySet()) {
                        if (((ImagePlus)imp_map.get(key)).getType() != 4) continue;
                        is_rgb_image = true;
                    }
                    if (is_rgb_image) {
                        HashMap<String, ImagePlus> red_map = new HashMap<String, ImagePlus>();
                        HashMap<String, ImagePlus> green_map = new HashMap<String, ImagePlus>();
                        HashMap<String, ImagePlus> blue_map = new HashMap<String, ImagePlus>();
                        ArrayList<HashMap<String, ImagePlus>> map_array = new ArrayList<HashMap<String, ImagePlus>>(3);
                        map_array.add(red_map);
                        map_array.add(green_map);
                        map_array.add(blue_map);
                        RGBStackSplitter channel_splitter = new RGBStackSplitter();
                        ImagePlus current_imp = null;
                        for (String key : imp_map.keySet()) {
                            current_imp = (ImagePlus)imp_map.get(key);
                            channel_splitter.split(current_imp.getImageStack(), true);
                            red_map.put(key, new ImagePlus(current_imp.getShortTitle() + "-R", channel_splitter.red));
                            green_map.put(key, new ImagePlus(current_imp.getShortTitle() + "-G", channel_splitter.green));
                            blue_map.put(key, new ImagePlus(current_imp.getShortTitle() + "-B", channel_splitter.blue));
                        }
                        ImagePlus[] result_array = new ImagePlus[3];
                        int index = 0;
                        for (Map map : map_array) {
                            Map img_map = IepGui.this.image_expression_parser.convertToImglib(map);
                            IepGui.this.image_expression_parser.setImageMap(img_map);
                            IepGui.this.image_expression_parser.process();
                            Img tmp_image = IepGui.this.image_expression_parser.getResult();
                            result_array[index] = ImageJFunctions.show(tmp_image);
                            ++index;
                        }
                        RGBStackMerge rgb_merger = new RGBStackMerge();
                        ImagePlus imagePlus = rgb_merger.mergeHyperstacks(result_array, false);
                        for (int channel = imagePlus.getNChannels(); channel > 0; --channel) {
                            imagePlus.setPosition(channel, imagePlus.getSlice(), imagePlus.getFrame());
                            imagePlus.resetDisplayRange();
                        }
                        if (IepGui.this.target_imp == null) {
                            IepGui.this.target_imp = imagePlus;
                            IepGui.this.target_imp.show();
                        } else if (!IepGui.this.target_imp.isVisible()) {
                            IepGui.this.target_imp = imagePlus;
                            IepGui.this.target_imp.show();
                        } else {
                            IepGui.this.target_imp.setStack(expression, imagePlus.getStack());
                            if (IepGui.this.target_imp.isComposite()) {
                                ((CompositeImage)IepGui.this.target_imp).reset();
                            }
                        }
                    } else {
                        Map img_map = IepGui.this.image_expression_parser.convertToImglib(imp_map);
                        IepGui.this.image_expression_parser.setImageMap(img_map);
                        if (!IepGui.this.image_expression_parser.process()) {
                            IJ.error((String)IepGui.this.image_expression_parser.getErrorMessage());
                            return;
                        }
                        result_img = IepGui.this.image_expression_parser.getResult();
                        if (IepGui.this.target_imp == null) {
                            IepGui.this.target_imp = ImageJFunctions.show(result_img);
                            IepGui.this.target_imp.show();
                        } else {
                            ImagePlus new_imp = ImageJFunctions.show(result_img);
                            if (!IepGui.this.target_imp.isVisible()) {
                                IepGui.this.target_imp = new_imp;
                                IepGui.this.target_imp.show();
                            } else {
                                IepGui.this.target_imp.setStack(expression, new_imp.getStack());
                            }
                        }
                    }
                    IepGui.this.target_imp.resetDisplayRange();
                    IepGui.this.target_imp.updateAndDraw();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IJ.error((String)("An error occurred: " + e));
                }
                finally {
                    IJ.showStatus((String)"");
                    IepGui.this.setGUIEnabled(true);
                }
            }
        }.start();
    }

    protected void setGUIEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IepGui.this.jButtonOK.setEnabled(enabled);
                IepGui.this.expressionField.setEnabled(enabled);
                for (JComboBox box : IepGui.this.image_boxes) {
                    box.setEnabled(enabled);
                }
                if (enabled) {
                    IepGui.this.toFront();
                    IepGui.this.expressionField.requestFocusInWindow();
                }
            }
        });
    }

    public void imageClosed(ImagePlus imp) {
        this.images.remove(imp);
        this.refreshImageNames();
    }

    public void imageOpened(ImagePlus imp) {
        this.images.add(imp);
        this.refreshImageNames();
    }

    public void imageUpdated(ImagePlus imp) {
    }

    private void initGUI() {
        try {
            this.setTitle("Image Expression Parser - v2.2");
            this.jSplitPane1 = new JSplitPane();
            this.getContentPane().add((Component)this.jSplitPane1, "Center");
            this.jSplitPane1.setPreferredSize(new Dimension(500, 500));
            this.jSplitPane1.setDividerLocation(200);
            this.jSplitPane1.setResizeWeight(0.5);
            this.jPanelRight = new JPanel();
            GridBagLayout jPanelRightLayout = new GridBagLayout();
            jPanelRightLayout.rowWeights = new double[]{0.0, 0.0, 0.5, 0.0};
            jPanelRightLayout.rowHeights = new int[]{7, 7, 7, 7};
            jPanelRightLayout.columnWeights = new double[]{0.0, 0.5, 0.0};
            jPanelRightLayout.columnWidths = new int[]{4, 7, 7};
            this.jSplitPane1.add((Component)this.jPanelRight, "right");
            this.jPanelRight.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.jPanelRight.setLayout(jPanelRightLayout);
            this.jPanelRight.setMinimumSize(new Dimension(1, 1));
            this.jButtonCancel = new JButton();
            this.jPanelRight.add((Component)this.jButtonCancel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 10, 0), 0, 0));
            this.jButtonCancel.setText(QUIT_ACTION_COMMAND);
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IepGui.this.quitGui();
                }
            });
            this.jButtonOK = new JButton();
            this.jPanelRight.add((Component)this.jButtonOK, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 10), 0, 0));
            this.jButtonOK.setText(PARSE_ACTION_COMMAND);
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean valid = IepGui.this.checkValid();
                    if (valid) {
                        IepGui.this.addCurrentExpressionToHistory();
                        IepGui.this.launchCalculation();
                    }
                }
            });
            this.jScrollPane1 = new JScrollPane();
            this.jPanelRight.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane1.setBorder(null);
            this.jScrollPane1.getViewport().setOpaque(false);
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
            this.jTextAreaInfo = new JEditorPane();
            this.jTextAreaInfo.setBorder(null);
            this.jScrollPane1.setViewportView(this.jTextAreaInfo);
            this.jTextAreaInfo.setFont(new Font("Arial", 0, 10));
            this.jTextAreaInfo.setEditable(false);
            this.jTextAreaInfo.setOpaque(false);
            this.jTextAreaInfo.setContentType("text/html");
            this.jTextAreaInfo.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.jPanelLeft = new JPanel();
            GridBagLayout jPanelLeftLayout = new GridBagLayout();
            jPanelLeftLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0};
            jPanelLeftLayout.rowHeights = new int[]{7, 7, -33, 50};
            jPanelLeftLayout.columnWeights = new double[]{0.1};
            jPanelLeftLayout.columnWidths = new int[]{7};
            this.jPanelLeft.setLayout(jPanelLeftLayout);
            this.jSplitPane1.add((Component)this.jPanelLeft, "left");
            this.jPanelLeft.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.jPanelLeft.setPreferredSize(new Dimension(198, 470));
            this.jLabelExpression = new JLabel();
            this.jPanelLeft.add((Component)this.jLabelExpression, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 0), 0, 0));
            this.jLabelExpression.setText("Expression:");
            this.jLabelExpression.setPreferredSize(new Dimension(196, 16));
            this.expressionField = new JComboBox<String>(this.expression_history);
            this.expressionField.setEditable(true);
            this.expressionField.setBorder(new LineBorder(new Color(252, 117, 0), 1, false));
            this.expressionField.setSize(12, 18);
            this.jPanelLeft.add(this.expressionField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.expressionField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean valid;
                    if (e.getActionCommand().equalsIgnoreCase("comboBoxEdited") && (valid = IepGui.this.checkValid())) {
                        IepGui.this.addCurrentExpressionToHistory();
                        IepGui.this.launchCalculation();
                    }
                }
            });
            this.jScrollPaneImages = new JScrollPane();
            this.jPanelLeft.add((Component)this.jScrollPaneImages, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
            this.jScrollPaneImages.setPreferredSize(new Dimension(196, 267));
            this.jScrollPaneImages.setHorizontalScrollBarPolicy(31);
            this.jScrollPaneImages.getVerticalScrollBar().setUnitIncrement(20);
            this.jPanelImages = new JPanel();
            this.jScrollPaneImages.setViewportView(this.jPanelImages);
            this.jPanelImages.setLayout(null);
            this.jPanelImages.setPreferredSize(new Dimension(190, 45));
            this.jPanelLeftButtons = new JPanel();
            this.jPanelLeft.add((Component)this.jPanelLeftButtons, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
            this.jPanelLeftButtons.setLayout(null);
            this.jPanelLeftButtons.setPreferredSize(new Dimension(196, 35));
            this.jPanelLeftButtons.setSize(196, 35);
            this.jButtonPlus = new JButton();
            this.jPanelLeftButtons.add(this.jButtonPlus);
            this.jButtonPlus.setText("+");
            this.jButtonPlus.setBounds(9, -2, 35, 35);
            this.jButtonPlus.setFont(new Font("Times New Roman", 0, 18));
            this.jButtonPlus.setOpaque(true);
            this.jButtonPlus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IepGui.this.addImageBox();
                }
            });
            this.jButtonMinus = new JButton();
            this.jPanelLeftButtons.add(this.jButtonMinus);
            this.jButtonMinus.setText("\u2014");
            this.jButtonMinus.setBounds(46, -2, 35, 35);
            this.jButtonMinus.setFont(new Font("Arial", 0, 12));
            this.jButtonMinus.setOpaque(true);
            this.jButtonMinus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IepGui.this.removeImageBox();
                }
            });
            this.jPanelLeft.addComponentListener(new ComponentListener(){

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    IepGui.this.refreshImageBoxes();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            this.pack();
            this.setSize(500, 500);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.quitGui();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

