/*
 * Decompiled with CFR 0.152.
 */
package io.scif.cli;

import io.scif.SCIFIOService;
import io.scif.cli.SCIFIOToolCommand;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.PluginService;
import org.scijava.service.SciJavaService;

public final class SCIFIOTools {
    private static Context ctx;
    private static Map<String, SCIFIOToolCommand> cmdMap;

    private SCIFIOTools() {
    }

    public static void run(String ... args) {
        SCIFIOToolCommand cmd;
        SCIFIOTools.findCommands();
        if (args.length > 0 && (cmd = cmdMap.get(args[0].toLowerCase())) != null) {
            cmd.runCommand(Arrays.copyOfRange(args, 1, args.length));
            ctx.dispose();
            return;
        }
        String msg = "A valid command was not supplied. Usage:\n\n\tscifio <command> [command args]\n\nAvailable commands:";
        for (String commandName : cmdMap.keySet()) {
            msg = msg + "\n\t" + commandName.substring(commandName.lastIndexOf(46) + 1).toLowerCase();
        }
        ((LogService)ctx.getService(LogService.class)).error((Object)msg);
        ctx.dispose();
    }

    private static void findCommands() {
        if (ctx == null) {
            ctx = new Context(new Class[]{SCIFIOService.class, SciJavaService.class});
        }
        if (cmdMap == null) {
            List commands = ((PluginService)ctx.getService(PluginService.class)).createInstancesOfType(SCIFIOToolCommand.class);
            cmdMap = new HashMap<String, SCIFIOToolCommand>();
            for (SCIFIOToolCommand cmd : commands) {
                cmdMap.put(cmd.commandName(), cmd);
            }
        }
    }

    public static void main(String[] args) {
        SCIFIOTools.run(args);
    }
}

