/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.SincInterpolator;
import edu.mines.jtk.util.ArrayMath;

public abstract class WarpFunction2 {
    private int _n1;
    private int _n2;

    public static WarpFunction2 constant(double u1, double u2, int n1, int n2) {
        return new ConstantWarp2(u1, u2, n1, n2);
    }

    public static WarpFunction2 gaussian(double u1, double u2, int n1, int n2) {
        return new GaussianWarp2(u1, u2, n1, n2);
    }

    public static WarpFunction2 sinusoid(double u1, double u2, int n1, int n2) {
        return new SinusoidWarp2(u1, u2, n1, n2);
    }

    public static WarpFunction2 constantPlusSinusoid(double c1, double c2, double u1, double u2, int n1, int n2) {
        return new SinusoidWarp2(c1, c2, u1, u2, n1, n2);
    }

    public abstract double u1(double var1, double var3);

    public abstract double u2(double var1, double var3);

    public double u1x(double x1, double x2) {
        return this.u1(x1, x2);
    }

    public double u2x(double x1, double x2) {
        return this.u2(x1, x2);
    }

    public double u1m(double m1, double m2) {
        double u1p;
        double u1m = 0.0;
        double u2m = 0.0;
        do {
            u1p = u1m;
            u1m = this.u1(m1 - 0.5 * u1m, m2 - 0.5 * u2m);
            u2m = this.u2(m1 - 0.5 * u1m, m2 - 0.5 * u2m);
        } while (ArrayMath.abs(u1m - u1p) > 1.0E-4);
        return u1m;
    }

    public double u2m(double m1, double m2) {
        double u2p;
        double u1m = 0.0;
        double u2m = 0.0;
        do {
            u2p = u2m;
        } while (ArrayMath.abs((u2m = this.u2(m1 - 0.5 * (u1m = this.u1(m1 - 0.5 * u1m, m2 - 0.5 * u2m)), m2 - 0.5 * u2m)) - u2p) > 1.0E-4);
        return u2m;
    }

    public double u1y(double y1, double y2) {
        double u1p;
        double u1y = 0.0;
        double u2y = 0.0;
        do {
            u1p = u1y;
            u1y = this.u1(y1 - u1y, y2 - u2y);
            u2y = this.u2(y1 - u1y, y2 - u2y);
        } while (ArrayMath.abs(u1y - u1p) > 1.0E-4);
        return u1y;
    }

    public double u2y(double y1, double y2) {
        double u2p;
        double u1y = 0.0;
        double u2y = 0.0;
        do {
            u2p = u2y;
        } while (ArrayMath.abs((u2y = this.u2(y1 - (u1y = this.u1(y1 - u1y, y2 - u2y)), y2 - u2y)) - u2p) > 1.0E-4);
        return u2y;
    }

    public float[][] u1x() {
        float[][] u = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double x2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double x1 = i1;
                u[i2][i1] = (float)this.u1x(x1, x2);
            }
        }
        return u;
    }

    public float[][] u2x() {
        float[][] u = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double x2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double x1 = i1;
                u[i2][i1] = (float)this.u2x(x1, x2);
            }
        }
        return u;
    }

    public float[][] u1m() {
        float[][] u = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double m2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double m1 = i1;
                u[i2][i1] = (float)this.u1m(m1, m2);
            }
        }
        return u;
    }

    public float[][] u2m() {
        float[][] u = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double m2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double m1 = i1;
                u[i2][i1] = (float)this.u2m(m1, m2);
            }
        }
        return u;
    }

    public float[][] u1y() {
        float[][] u = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double y2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double y1 = i1;
                u[i2][i1] = (float)this.u1y(y1, y2);
            }
        }
        return u;
    }

    public float[][] u2y() {
        float[][] u = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double y2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double y1 = i1;
                u[i2][i1] = (float)this.u2y(y1, y2);
            }
        }
        return u;
    }

    public float[][] warp1(float[][] f) {
        SincInterpolator si = new SincInterpolator();
        float[][] g = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                g[i2][i1] = si.interpolate(this._n1, 1.0, 0.0, f[i2], (double)i1 - this.u1y(i1, i2));
            }
        }
        return g;
    }

    public float[][] warp(float[][] f) {
        SincInterpolator si = new SincInterpolator();
        float[][] g = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double y2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double y1 = i1;
                double x1 = y1 - this.u1y(y1, y2);
                double x2 = y2 - this.u2y(y1, y2);
                g[i2][i1] = si.interpolate(this._n1, 1.0, 0.0, this._n2, 1.0, 0.0, f, x1, x2);
            }
        }
        return g;
    }

    public float[][] unwarp1(float[][] g) {
        SincInterpolator si = new SincInterpolator();
        float[][] f = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                f[i2][i1] = si.interpolate(this._n1, 1.0, 0.0, g[i2], (double)i1 + this.u1x(i1, i2));
            }
        }
        return f;
    }

    public float[][] unwarp(float[][] g) {
        SincInterpolator si = new SincInterpolator();
        float[][] f = new float[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            double x2 = i2;
            for (int i1 = 0; i1 < this._n1; ++i1) {
                double x1 = i1;
                double y1 = x1 + this.u1x(x1, x2);
                double y2 = x2 + this.u2x(x1, x2);
                f[i2][i1] = si.interpolate(this._n1, 1.0, 0.0, this._n2, 1.0, 0.0, g, y1, y2);
            }
        }
        return f;
    }

    protected WarpFunction2(int n1, int n2) {
        this._n1 = n1;
        this._n2 = n2;
    }

    private static class SinusoidWarp2
    extends WarpFunction2 {
        private double _a1;
        private double _a2;
        private double _b1;
        private double _b2;
        private double _c1;
        private double _c2;

        public SinusoidWarp2(double u1max, double u2max, int n1, int n2) {
            this(0.0, 0.0, u1max, u2max, n1, n2);
        }

        public SinusoidWarp2(double u1add, double u2add, double u1max, double u2max, int n1, int n2) {
            super(n1, n2);
            double l1 = n1 - 1;
            double l2 = n2 - 1;
            this._c1 = u1add;
            this._c2 = u2add;
            this._a1 = u1max;
            this._a2 = u2max;
            this._b1 = Math.PI * 2 / l1;
            this._b2 = Math.PI * 2 / l2;
        }

        @Override
        public double u1(double x1, double x2) {
            return this._c1 + this._a1 * ArrayMath.sin(this._b1 * x1) * ArrayMath.sin(0.5 * this._b2 * x2);
        }

        @Override
        public double u2(double x1, double x2) {
            return this._c2 + this._a2 * ArrayMath.sin(this._b2 * x2) * ArrayMath.sin(0.5 * this._b1 * x1);
        }
    }

    private static class GaussianWarp2
    extends WarpFunction2 {
        private double _a1;
        private double _a2;
        private double _b1;
        private double _b2;
        private double _c1;
        private double _c2;

        public GaussianWarp2(double u1max, double u2max, int n1, int n2) {
            super(n1, n2);
            this._a1 = (double)(n1 - 1) / 2.0;
            this._a2 = (double)(n2 - 1) / 2.0;
            this._b1 = this._a1 / 3.0;
            this._b2 = this._a2 / 3.0;
            this._c1 = u1max * ArrayMath.exp(0.5) / this._b1;
            this._c2 = u2max * ArrayMath.exp(0.5) / this._b2;
        }

        @Override
        public double u1(double x1, double x2) {
            double xa1 = x1 - this._a1;
            double xa2 = x2 - this._a2;
            return -this._c1 * xa1 * ArrayMath.exp(-0.5 * (xa1 * xa1 / (this._b1 * this._b1) + xa2 * xa2 / (this._b2 * this._b2)));
        }

        @Override
        public double u2(double x1, double x2) {
            double xa1 = x1 - this._a1;
            double xa2 = x2 - this._a2;
            return -this._c2 * xa2 * ArrayMath.exp(-0.5 * (xa1 * xa1 / (this._b1 * this._b1) + xa2 * xa2 / (this._b2 * this._b2)));
        }
    }

    private static class ConstantWarp2
    extends WarpFunction2 {
        private double _u1;
        private double _u2;

        public ConstantWarp2(double u1, double u2, int n1, int n2) {
            super(n1, n2);
            this._u1 = u1;
            this._u2 = u2;
        }

        @Override
        public double u1(double x1, double x2) {
            return this._u1;
        }

        @Override
        public double u2(double x1, double x2) {
            return this._u2;
        }
    }
}

