/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.CullContext;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Vector3;

public class TransformGroup
extends Group {
    private Matrix44 _transform;

    public TransformGroup(Matrix44 transform) {
        this._transform = new Matrix44(transform);
    }

    public Matrix44 getTransform() {
        return new Matrix44(this._transform);
    }

    public void setTransform(Matrix44 transform) {
        this._transform = new Matrix44(transform);
        this.dirtyBoundingSphere();
    }

    @Override
    protected void cullBegin(CullContext cc) {
        super.cullBegin(cc);
        cc.pushLocalToWorld(this._transform);
    }

    @Override
    protected void cullEnd(CullContext cc) {
        cc.popLocalToWorld();
        super.cullEnd(cc);
    }

    @Override
    protected void drawBegin(DrawContext dc) {
        super.drawBegin(dc);
        dc.pushLocalToWorld(this._transform);
        Gl.glPushMatrix();
        Gl.glMultMatrixd(this._transform.m, 0);
    }

    @Override
    protected void drawEnd(DrawContext dc) {
        dc.popLocalToWorld();
        Gl.glPopMatrix();
        super.drawEnd(dc);
    }

    @Override
    protected void pickBegin(PickContext pc) {
        super.pickBegin(pc);
        pc.pushLocalToWorld(this._transform);
    }

    @Override
    protected void pickEnd(PickContext pc) {
        pc.popLocalToWorld();
        super.pickEnd(pc);
    }

    @Override
    protected BoundingSphere computeBoundingSphere(boolean finite) {
        BoundingSphere bs = super.computeBoundingSphere(finite);
        if (!bs.isEmpty() && !bs.isInfinite()) {
            double r = bs.getRadius();
            Point3 c = bs.getCenter();
            Point3 x = new Point3(c.x + r, c.y, c.z);
            Point3 y = new Point3(c.x, c.y + r, c.z);
            Point3 z = new Point3(c.x, c.y, c.z + r);
            c = this._transform.times(c);
            x = this._transform.times(x);
            y = this._transform.times(y);
            z = this._transform.times(z);
            Vector3 cx = c.minus(x);
            Vector3 cy = c.minus(y);
            Vector3 cz = c.minus(z);
            double lx = cx.length();
            double ly = cy.length();
            double lz = cz.length();
            r = lx;
            if (r < ly) {
                r = ly;
            }
            if (r < lz) {
                r = lz;
            }
            bs = new BoundingSphere(c, r);
        }
        return bs;
    }
}

