/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class RTree
extends AbstractSet<Object> {
    private Node _root;
    private int _ndim;
    private int _nmin;
    private int _nmax;
    private int _size;
    private Boxer _boxer;
    private int _modIndex;
    private float[] _amin;
    private float[] _amax;
    private float[] _bmin;
    private float[] _bmax;
    private float[] _smin;
    private float[] _smax;
    private float[] _tmin;
    private float[] _tmax;

    public RTree(int ndim, int nmin, int nmax) {
        this(ndim, nmin, nmax, new DefaultBoxer());
    }

    public RTree(int ndim, int nmin, int nmax, Boxer boxer) {
        Check.argument(nmin > 0, "nmin>0");
        Check.argument(nmin <= nmax / 2, "nmin<=nmax/2");
        Check.argument(nmax >= 4, "nmax>=4");
        this._ndim = ndim;
        this._nmin = nmin;
        this._nmax = nmax;
        this._boxer = boxer;
        this._root = new Node(1);
        this._smin = new float[this._ndim];
        this._smax = new float[this._ndim];
        this._tmin = new float[this._ndim];
        this._tmax = new float[this._ndim];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void clear() {
        this._root = new Node(1);
        this._size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean add(Object object) {
        Check.argument(object != null, "object is not null");
        Node leaf = this._root.chooseNodeFor(object);
        if (leaf.indexOf(object) >= 0) {
            return false;
        }
        leaf.add(object);
        ++this._size;
        ++this._modIndex;
        return true;
    }

    public int addPacked(Object[] objects) {
        int size = this._size;
        int n = objects.length;
        int[] index = new int[n];
        float[][] x = new float[this._ndim][n];
        float[] xmin = new float[3];
        float[] xmax = new float[3];
        for (int i = 0; i < n; ++i) {
            index[i] = i;
            this._boxer.getBounds(objects[i], xmin, xmax);
            for (int idim = 0; idim < this._ndim; ++idim) {
                x[idim][i] = 0.5f * (xmin[idim] + xmax[idim]);
            }
        }
        this.addPacked(0, x, 0, n, index, objects);
        return this._size - size;
    }

    @Override
    public boolean remove(Object object) {
        Check.argument(object != null, "object is not null");
        Node leaf = this._root.findLeafWith(object);
        if (leaf == null) {
            return false;
        }
        leaf.remove(object, null);
        --this._size;
        ++this._modIndex;
        return true;
    }

    @Override
    public boolean contains(Object object) {
        Node leaf = this._root.findLeafWith(object);
        return leaf != null;
    }

    @Override
    public Iterator<Object> iterator() {
        return new RTreeIterator();
    }

    public int getLevels() {
        return this._root.level();
    }

    public Object[] findOverlapping(float[] min, float[] max) {
        Check.argument(min.length == this._ndim, "min.length equals tree ndim");
        Check.argument(max.length == this._ndim, "max.length equals tree ndim");
        ArrayList<Object> list = new ArrayList<Object>();
        this._root.findOverlapping(min, max, list);
        return list.toArray();
    }

    public Object[] findOverlapping(Box box) {
        Check.argument(box != null, "box is not null");
        Check.argument(box._ndim == this._ndim, "box ndim = tree ndim");
        return this.findOverlapping(box._min, box._max);
    }

    public Object[] findInSphere(float[] center, float radius) {
        Check.argument(center.length == this._ndim, "center.length equals tree ndim");
        ArrayList<Object> list = new ArrayList<Object>();
        this._root.findInSphere(center, radius, list);
        return list.toArray();
    }

    public Object findNearest(float[] point) {
        if (this.isEmpty()) {
            return null;
        }
        return this.findNearest(1, point)[0];
    }

    public Object[] findNearest(int k, float[] point) {
        Check.argument(point.length == this._ndim, "point.length equals tree ndim");
        Nearest nearest = new Nearest(k, point);
        this._root.findNearest(nearest);
        return nearest.toArray();
    }

    public float getLeafArea() {
        return this._root.areaLeaf();
    }

    public float getLeafVolume() {
        return this._root.volumeLeaf();
    }

    public void dump() {
        this._root.dump(this._root);
    }

    public void validate() {
        this._root.validate();
    }

    private void loadA(Object box) {
        if (box instanceof Node) {
            Node node = (Node)box;
            this._amin = node._min;
            this._amax = node._max;
        } else {
            this._boxer.getBounds(box, this._smin, this._smax);
            this._amin = this._smin;
            this._amax = this._smax;
        }
    }

    private void loadB(Object box) {
        if (box instanceof Node) {
            Node node = (Node)box;
            this._bmin = node._min;
            this._bmax = node._max;
        } else {
            this._boxer.getBounds(box, this._tmin, this._tmax);
            this._bmin = this._tmin;
            this._bmax = this._tmax;
        }
    }

    private void addPacked(int idim, float[][] x, int p, int q, int[] index, Object[] objects) {
        block10: {
            int kdim = this._ndim - idim;
            if (p >= q) break block10;
            if (kdim == 0) {
                for (int i = p; i < q; ++i) {
                    this.add(objects[index[i]]);
                }
            } else {
                int n = index.length;
                int nsort = q - p;
                int[] isort = index;
                float[] xsort = x[idim];
                if (nsort < n) {
                    isort = new int[nsort];
                    xsort = new float[nsort];
                    float[] xidim = x[idim];
                    for (int jsort = 0; jsort < nsort; ++jsort) {
                        isort[jsort] = jsort;
                        xsort[jsort] = xidim[index[p + jsort]];
                    }
                }
                ArrayMath.quickIndexSort(xsort, isort);
                if (nsort < n) {
                    int jsort;
                    for (jsort = 0; jsort < nsort; ++jsort) {
                        isort[jsort] = index[p + isort[jsort]];
                    }
                    for (jsort = 0; jsort < nsort; ++jsort) {
                        index[p + jsort] = isort[jsort];
                    }
                }
                int nleaf = 1 + nsort / this._nmax;
                int nslab = (int)Math.ceil(Math.pow(nleaf, 1.0 / (double)kdim));
                int mslab = (int)Math.ceil((double)nsort / (double)nslab);
                for (int pslab = p; pslab < q; pslab += mslab) {
                    int qslab = pslab + mslab;
                    if (qslab > q) {
                        qslab = q;
                    }
                    if (qslab <= pslab) continue;
                    this.addPacked(idim + 1, x, pslab, qslab, index, objects);
                }
            }
        }
    }

    private class RTreeIterator
    implements Iterator<Object> {
        private Node _leaf;
        private int _ibox;
        private Object _next;
        private int _modIndexExpected;

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public Object next() {
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            if (this._modIndexExpected != RTree.this._modIndex) {
                throw new ConcurrentModificationException();
            }
            Object object = this._next;
            this.loadNext();
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        RTreeIterator() {
            this._leaf = RTree.this._root;
            while (!this._leaf.isLeaf()) {
                this._leaf = (Node)this._leaf._boxs[0];
            }
            this._ibox = 0;
            this._next = this._ibox < this._leaf._nbox ? this._leaf._boxs[0] : null;
            this._modIndexExpected = RTree.this._modIndex;
        }

        private void loadNext() {
            ++this._ibox;
            if (this._ibox == this._leaf._nbox) {
                Node node;
                Node parent = node = this._leaf;
                while (node == parent && parent != RTree.this._root) {
                    parent = node._parent;
                    int ibox = 1 + parent.indexOf(node);
                    if (ibox < parent._nbox) {
                        node = (Node)parent._boxs[ibox];
                        while (!node.isLeaf()) {
                            node = (Node)node._boxs[0];
                        }
                        this._leaf = node;
                        this._ibox = 0;
                        continue;
                    }
                    node = parent;
                }
            }
            this._next = this._ibox < this._leaf._nbox ? this._leaf._boxs[this._ibox] : null;
        }
    }

    private static class BoxDistance
    implements Comparable<BoxDistance> {
        Object box;
        float distance;

        BoxDistance(Object box, float distance) {
            this.box = box;
            this.distance = distance;
        }

        @Override
        public int compareTo(BoxDistance bd) {
            int oh;
            if (this.distance < bd.distance) {
                return -1;
            }
            if (this.distance > bd.distance) {
                return 1;
            }
            int th = System.identityHashCode(this.box);
            if (th < (oh = System.identityHashCode(bd.box))) {
                return -1;
            }
            if (th > oh) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            BoxDistance bd = (BoxDistance)o;
            return this.box == bd.box && this.distance == bd.distance;
        }
    }

    private class Nearest {
        private int _k;
        private float[] _point;
        private TreeSet<BoxDistance> _set;
        private boolean _full;
        private float _cutoff;

        Nearest(int k, float[] point) {
            this._k = k;
            this._point = point;
            this._set = new TreeSet();
            this._full = false;
            this._cutoff = Float.MAX_VALUE;
        }

        void update(Object box) {
            float d = RTree.this._boxer.getDistanceSquared(box, this._point);
            if (d < this._cutoff) {
                BoxDistance bd = new BoxDistance(box, d);
                if (this._full) {
                    this._set.remove(this._set.last());
                }
                this._set.add(bd);
                boolean bl = this._full = this._full || this._k == this._set.size();
                if (this._full) {
                    this._cutoff = this._set.last().distance;
                }
            }
        }

        float[] point() {
            return this._point;
        }

        float cutoff() {
            return this._cutoff;
        }

        Object[] toArray() {
            Object[] boxs = new Object[this._set.size()];
            Iterator<BoxDistance> i = this._set.iterator();
            int ibox = 0;
            while (i.hasNext()) {
                boxs[ibox] = i.next().box;
                ++ibox;
            }
            return boxs;
        }
    }

    private class Node {
        private static final float INFINITY = Float.MAX_VALUE;
        private float[] _min;
        private float[] _max;
        private Node _parent;
        private int _level;
        private int _nbox;
        private Object[] _boxs;

        Node(int level) {
            this._min = new float[RTree.this._ndim];
            this._max = new float[RTree.this._ndim];
            this._boxs = new Object[RTree.this._nmax];
            this._level = level;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                this._min[idim] = Float.MAX_VALUE;
                this._max[idim] = -3.4028235E38f;
            }
        }

        int level() {
            return this._level;
        }

        boolean isLeaf() {
            return this._level == 1;
        }

        int size() {
            return this._nbox;
        }

        void add(Object box) {
            if (this._nbox < RTree.this._nmax) {
                this.append(box);
                this.expandUp(box);
            } else {
                Node nodeNew = this.split(box);
                this.updateUp();
                if (this._parent == null) {
                    this._parent = new Node(this._level + 1);
                    RTree.this._root = this._parent;
                    this._parent.add(this);
                }
                this._parent.add(nodeNew);
            }
        }

        void remove(Object box, ArrayList<Object> orphans) {
            int jbox;
            int ibox = this.indexOf(box);
            assert (ibox >= 0) : "box is a child of this node";
            for (jbox = ibox + 1; jbox < this._nbox; ++jbox) {
                this._boxs[jbox - 1] = this._boxs[jbox];
            }
            --this._nbox;
            if (this._nbox >= RTree.this._nmin || this._parent == null) {
                this.updateUp();
            } else {
                if (orphans == null) {
                    orphans = new ArrayList();
                }
                for (jbox = 0; jbox < this._nbox; ++jbox) {
                    orphans.add(this._boxs[jbox]);
                }
                this._nbox = 0;
                this._parent.remove(this, orphans);
                int norphan = orphans.size();
                for (int iorphan = 0; iorphan < norphan; ++iorphan) {
                    Object orphan = orphans.get(iorphan);
                    Node parent = RTree.this._root.chooseNodeFor(orphan);
                    parent.add(orphan);
                }
                orphans.clear();
            }
            if (((RTree)RTree.this)._root._nbox == 1 && ((RTree)RTree.this)._root._level > 1) {
                RTree.this._root = (Node)((RTree)RTree.this)._root._boxs[0];
                ((RTree)RTree.this)._root._parent = null;
            }
        }

        void findOverlapping(float[] min, float[] max, ArrayList<Object> list) {
            for (int ibox = 0; ibox < this._nbox; ++ibox) {
                Object boxi = this._boxs[ibox];
                if (!this.overlaps(boxi, min, max)) continue;
                if (this.isLeaf()) {
                    list.add(boxi);
                    continue;
                }
                ((Node)boxi).findOverlapping(min, max, list);
            }
        }

        void findInSphere(float[] center, float radius, ArrayList<Object> list) {
            float ss = radius * radius;
            for (int ibox = 0; ibox < this._nbox; ++ibox) {
                Object boxi = this._boxs[ibox];
                float ds = this.distanceSquared(boxi, center);
                if (!(ds <= ss)) continue;
                if (this.isLeaf()) {
                    list.add(boxi);
                    continue;
                }
                ((Node)boxi).findInSphere(center, radius, list);
            }
        }

        Node chooseNodeFor(Object box) {
            int level = 1 + this.level(box);
            assert (this._level >= level) : "level of this node exceeds level of box";
            if (this._level == level) {
                return this;
            }
            Node node = null;
            float dmin = Float.MAX_VALUE;
            float vmin = Float.MAX_VALUE;
            for (int ibox = 0; ibox < this._nbox; ++ibox) {
                Node nodei = (Node)this._boxs[ibox];
                float d = nodei.volumeDelta(box);
                if (!(d <= dmin)) continue;
                float v = nodei.volume();
                if (!(d < dmin) && !(v < vmin)) continue;
                node = nodei;
                dmin = d;
                vmin = v;
            }
            return node.chooseNodeFor(box);
        }

        Node findLeafWith(Object box) {
            if (this.isLeaf()) {
                for (int ibox = 0; ibox < this._nbox; ++ibox) {
                    if (!this._boxs[ibox].equals(box)) continue;
                    return this;
                }
            } else {
                for (int ibox = 0; ibox < this._nbox; ++ibox) {
                    Node node;
                    Node nodei = (Node)this._boxs[ibox];
                    if (!nodei.overlaps(box) || (node = nodei.findLeafWith(box)) == null) continue;
                    return node;
                }
            }
            return null;
        }

        void findNearest(Nearest nearest) {
            if (this.isLeaf()) {
                for (int ibox = 0; ibox < this._nbox; ++ibox) {
                    nearest.update(this._boxs[ibox]);
                }
            } else {
                int ibox;
                ArrayList<BoxDistance> list = new ArrayList<BoxDistance>(this._nbox);
                for (ibox = 0; ibox < this._nbox; ++ibox) {
                    Object box = this._boxs[ibox];
                    float distance = this.distanceSquared(box, nearest.point());
                    list.add(new BoxDistance(box, distance));
                }
                Collections.sort(list);
                for (ibox = 0; ibox < this._nbox; ++ibox) {
                    BoxDistance bd = (BoxDistance)list.get(ibox);
                    if (!(bd.distance < nearest.cutoff())) continue;
                    ((Node)bd.box).findNearest(nearest);
                }
            }
        }

        float distanceSquared(float[] point) {
            float sum = 0.0f;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                float p = point[idim];
                float s = this._min[idim];
                float t = this._max[idim];
                float d = p < s ? p - s : (p > t ? p - t : 0.0f);
                sum += d * d;
            }
            return sum;
        }

        float distanceSquared(Object box, float[] point) {
            if (box instanceof Node) {
                return ((Node)box).distanceSquared(point);
            }
            return RTree.this._boxer.getDistanceSquared(box, point);
        }

        int indexOf(Object box) {
            if (box instanceof Node) {
                for (int ibox = 0; ibox < this._nbox; ++ibox) {
                    if (box != this._boxs[ibox]) continue;
                    return ibox;
                }
            } else {
                for (int ibox = 0; ibox < this._nbox; ++ibox) {
                    if (!box.equals(this._boxs[ibox])) continue;
                    return ibox;
                }
            }
            return -1;
        }

        int level(Object box) {
            return box instanceof Node ? ((Node)box)._level : 0;
        }

        float volumeLeaf() {
            float volume = 0.0f;
            for (int ibox = 0; ibox < this._nbox; ++ibox) {
                Object box = this._boxs[ibox];
                if (!(box instanceof Node)) continue;
                Node node = (Node)box;
                if (node.isLeaf()) {
                    volume += this.volume(box);
                    continue;
                }
                volume += node.volumeLeaf();
            }
            return volume;
        }

        float areaLeaf() {
            float area = 0.0f;
            for (int ibox = 0; ibox < this._nbox; ++ibox) {
                Object box = this._boxs[ibox];
                if (!(box instanceof Node)) continue;
                Node node = (Node)box;
                if (node.isLeaf()) {
                    area += this.area(box);
                    continue;
                }
                area += node.areaLeaf();
            }
            return area;
        }

        void dump(Object box) {
            int indent = 2 * (this.level(RTree.this._root) - this.level(box));
            StringBuffer sb = new StringBuffer(indent);
            for (int i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            System.out.println(sb.toString() + box);
            if (box instanceof Node) {
                Node node = (Node)box;
                int nbox = node._nbox;
                Object[] boxs = node._boxs;
                for (int ibox = 0; ibox < nbox; ++ibox) {
                    this.dump(boxs[ibox]);
                }
            }
        }

        void validate() {
            assert (this._parent != null || RTree.this._root == this) : "node without parent is root";
            if (RTree.this._root != this) {
                assert (this._nbox >= RTree.this._nmin) : "_nbox>=_nmin";
                assert (this._nbox <= RTree.this._nmax) : "_nbox<=_nmin";
            } else if (this.isLeaf()) {
                assert (this._nbox >= 0) : "_nbox>=0";
            } else assert (this._nbox >= 2) : "_nbox>=2";
            assert (this._nbox <= RTree.this._nmax) : "_nbox<=_nmin";
            Node tmp = new Node(0);
            for (int ibox = 0; ibox < this._nbox; ++ibox) {
                if (!this.isLeaf()) {
                    Node node = (Node)this._boxs[ibox];
                    assert (node._parent == this) : "node._parent==this";
                    assert (node._level == this._level - 1) : "node._level==_level-1";
                    node.validate();
                }
                tmp.expand(this._boxs[ibox]);
            }
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                assert (this._min[idim] == tmp._min[idim]) : "minimum bounds are correct";
                assert (this._max[idim] == tmp._max[idim]) : "maximum bounds are correct";
            }
        }

        private boolean overlaps(Object box) {
            RTree.this.loadB(box);
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                if (!(this._min[idim] > RTree.this._bmax[idim]) && !(this._max[idim] < RTree.this._bmin[idim])) continue;
                return false;
            }
            return true;
        }

        private boolean overlaps(Object box, float[] min, float[] max) {
            RTree.this.loadB(box);
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                if (!(RTree.this._bmin[idim] > max[idim]) && !(RTree.this._bmax[idim] < min[idim])) continue;
                return false;
            }
            return true;
        }

        private float volume() {
            float v = 1.0f;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                v *= this._max[idim] - this._min[idim];
            }
            return v;
        }

        private float volume(Object box) {
            RTree.this.loadB(box);
            float v = 1.0f;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                v *= RTree.this._bmax[idim] - RTree.this._bmin[idim];
            }
            return v;
        }

        private float area(Object box) {
            float v = this.volume(box);
            RTree.this.loadB(box);
            float area = 0.0f;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                float d = RTree.this._bmax[idim] - RTree.this._bmin[idim];
                area += 2.0f * v / d;
            }
            return area;
        }

        private float volumeDelta(Object box) {
            RTree.this.loadB(box);
            float vnew = 1.0f;
            float vold = 1.0f;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                float amin = this._min[idim];
                float amax = this._max[idim];
                vold *= amax - amin;
                float bmin = RTree.this._bmin[idim];
                float bmax = RTree.this._bmax[idim];
                if (bmin < amin) {
                    amin = bmin;
                }
                if (bmax > amax) {
                    amax = bmax;
                }
                vnew *= amax - amin;
            }
            return vnew - vold;
        }

        private float volumeDelta(Object abox, Object bbox) {
            RTree.this.loadA(abox);
            RTree.this.loadB(bbox);
            float vnew = 1.0f;
            float vold = 1.0f;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                float amin = RTree.this._amin[idim];
                float amax = RTree.this._amax[idim];
                vold *= amax - amin;
                float bmin = RTree.this._bmin[idim];
                float bmax = RTree.this._bmax[idim];
                if (bmin < amin) {
                    amin = bmin;
                }
                if (bmax > amax) {
                    amax = bmax;
                }
                vnew *= amax - amin;
            }
            return vnew - vold;
        }

        private void append(Object box) {
            this._boxs[this._nbox++] = box;
            if (box instanceof Node) {
                ((Node)box)._parent = this;
            }
        }

        private boolean expand(Object box) {
            RTree.this.loadB(box);
            boolean changed = false;
            for (int idim = 0; idim < RTree.this._ndim; ++idim) {
                if (RTree.this._bmin[idim] < this._min[idim]) {
                    this._min[idim] = RTree.this._bmin[idim];
                    changed = true;
                }
                if (!(RTree.this._bmax[idim] > this._max[idim])) continue;
                this._max[idim] = RTree.this._bmax[idim];
                changed = true;
            }
            return changed;
        }

        private boolean update() {
            int idim;
            for (idim = 0; idim < RTree.this._ndim; ++idim) {
                ((RTree)RTree.this)._smin[idim] = this._min[idim];
                ((RTree)RTree.this)._smax[idim] = this._max[idim];
                this._min[idim] = Float.MAX_VALUE;
                this._max[idim] = -3.4028235E38f;
            }
            for (int ibox = 0; ibox < this._nbox; ++ibox) {
                this.expand(this._boxs[ibox]);
            }
            for (idim = 0; idim < RTree.this._ndim; ++idim) {
                if (this._min[idim] == RTree.this._smin[idim] && this._max[idim] == RTree.this._smax[idim]) continue;
                return true;
            }
            return false;
        }

        private void expandUp(Object box) {
            if (this.expand(box) && this._parent != null) {
                this._parent.expandUp(this);
            }
        }

        private void updateUp() {
            if (this.update() && this._parent != null) {
                this._parent.updateUp();
            }
        }

        private Node split(Object box) {
            int ibox;
            int nbox = this._nbox + 1;
            Object[] boxs = new Object[nbox];
            for (int ibox2 = 0; ibox2 < this._nbox; ++ibox2) {
                boxs[ibox2] = this._boxs[ibox2];
            }
            boxs[this._nbox] = box;
            this._nbox = 0;
            Node node1 = this;
            Node node2 = new Node(this._level);
            float dmax = -3.4028235E38f;
            int imax = -1;
            int jmax = -1;
            for (ibox = 0; ibox < nbox; ++ibox) {
                Object bbox = boxs[ibox];
                float bvol = this.volume(bbox);
                for (int jbox = ibox + 1; jbox < nbox; ++jbox) {
                    Object abox = boxs[jbox];
                    float dbox = this.volumeDelta(abox, bbox) - bvol;
                    if (!(dbox > dmax)) continue;
                    dmax = dbox;
                    imax = ibox;
                    jmax = jbox;
                }
            }
            node1.append(boxs[imax]);
            node2.append(boxs[jmax]);
            boxs[imax] = null;
            boxs[jmax] = null;
            for (ibox = 2; ibox < nbox; ++ibox) {
                int kbox = -1;
                Node nodek = null;
                int nsmall = RTree.this._nmin - (nbox - ibox);
                if (nsmall == node1.size()) {
                    nodek = node1;
                } else if (nsmall == node2.size()) {
                    nodek = node2;
                }
                if (nodek != null) {
                    for (int jbox = 0; jbox < nbox && kbox < 0; ++jbox) {
                        if (boxs[jbox] == null) continue;
                        kbox = jbox;
                    }
                } else {
                    int size2;
                    int size1;
                    float volume2;
                    float volume1;
                    float delta2;
                    dmax = -3.4028235E38f;
                    for (int jbox = 0; jbox < nbox; ++jbox) {
                        float d2;
                        float dbox;
                        Object boxj = boxs[jbox];
                        if (boxj == null) continue;
                        float d1 = node1.volumeDelta(boxj);
                        float f = dbox = d1 >= (d2 = node2.volumeDelta(boxj)) ? d1 - d2 : d2 - d1;
                        if (!(dbox > dmax)) continue;
                        dmax = dbox;
                        kbox = jbox;
                    }
                    float delta1 = node1.volumeDelta(boxs[kbox]);
                    nodek = delta1 == (delta2 = node2.volumeDelta(boxs[kbox])) ? ((volume1 = node1.volume()) == (volume2 = node2.volume()) ? ((size1 = node1.size()) < (size2 = node1.size()) ? node1 : node2) : (volume1 < volume2 ? node1 : node2)) : (delta1 < delta2 ? node1 : node2);
                }
                nodek.append(boxs[kbox]);
                boxs[kbox] = null;
            }
            node2.update();
            return node2;
        }
    }

    private static class DefaultBoxer
    implements Boxer {
        private DefaultBoxer() {
        }

        @Override
        public final void getBounds(Object object, float[] min, float[] max) {
            ((Boxed)object).getBounds(min, max);
        }

        @Override
        public final float getDistanceSquared(Object object, float[] point) {
            return ((Boxed)object).getDistanceSquared(point);
        }
    }

    public static class Box
    implements Boxed {
        private int _ndim;
        private float[] _min;
        private float[] _max;

        public Box(float xmin, float ymin, float xmax, float ymax) {
            this._ndim = 2;
            this._min = new float[]{xmin, ymin};
            this._max = new float[]{xmax, ymax};
        }

        public Box(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax) {
            this._ndim = 3;
            this._min = new float[]{xmin, ymin, zmin};
            this._max = new float[]{xmax, ymax, zmax};
        }

        public Box(float[] min, float[] max) {
            Check.argument(min.length == max.length, "min/max lengths are equal");
            this._ndim = min.length;
            this._min = new float[this._ndim];
            this._max = new float[this._ndim];
            for (int idim = 0; idim < this._ndim; ++idim) {
                this._min[idim] = min[idim];
                this._max[idim] = max[idim];
            }
        }

        public Box(int ndim, Boxed boxed) {
            this._ndim = ndim;
            this._min = new float[this._ndim];
            this._max = new float[this._ndim];
            boxed.getBounds(this._min, this._max);
        }

        @Override
        public void getBounds(float[] min, float[] max) {
            for (int idim = 0; idim < this._ndim; ++idim) {
                min[idim] = this._min[idim];
                max[idim] = this._max[idim];
            }
        }

        @Override
        public float getDistanceSquared(float[] point) {
            float sum = 0.0f;
            for (int idim = 0; idim < this._ndim; ++idim) {
                float p = point[idim];
                float s = this._min[idim];
                float t = this._max[idim];
                float d = p < s ? p - s : (p > t ? p - t : 0.0f);
                sum += d * d;
            }
            return sum;
        }

        public boolean overlaps(Box box) {
            float[] bmin = box._min;
            float[] bmax = box._max;
            for (int idim = 0; idim < this._ndim; ++idim) {
                if (!(this._min[idim] > bmax[idim]) && !(this._max[idim] < bmin[idim])) continue;
                return false;
            }
            return true;
        }
    }

    public static interface Boxer {
        public void getBounds(Object var1, float[] var2, float[] var3);

        public float getDistanceSquared(Object var1, float[] var2);
    }

    public static interface Boxed {
        public void getBounds(float[] var1, float[] var2);

        public float getDistanceSquared(float[] var1);
    }
}

