/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.type.numeric.real.DoubleType;

public abstract class AbstractLUTRealTransformField
implements InvertibleRealTransform {
    protected final int numSourceDimensions;
    protected final int numTargetDimensions;
    protected final int lutMaxIndex;
    protected final RandomAccessibleInterval<DoubleType> luts;
    protected final int transformDimension;
    protected final RandomAccess<DoubleType> access;

    public AbstractLUTRealTransformField(double[] lut, int numSourceDimensions, int numTargetDimensions, long ... dimensions) {
        assert ((long)lut.length == dimensions[2]);
        this.transformDimension = 2;
        this.luts = ArrayImgs.doubles((long[])dimensions);
        ArrayCursor cursor = ((ArrayImg)this.luts).cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((DoubleType)cursor.get()).set(lut[cursor.getIntPosition(this.transformDimension)]);
        }
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = numTargetDimensions;
        this.access = this.luts.randomAccess();
        this.lutMaxIndex = lut.length - 1;
    }

    public AbstractLUTRealTransformField(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> luts) {
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = numTargetDimensions;
        this.luts = luts;
        this.access = luts.randomAccess();
        this.transformDimension = 2;
        this.lutMaxIndex = (int)this.luts.dimension(this.transformDimension) - 1;
    }

    protected double apply(double z, int x, int y) {
        this.access.setPosition(x, 0);
        this.access.setPosition(y, 1);
        int zFloor = (int)z;
        this.access.setPosition(zFloor, 2);
        double floorVal = ((DoubleType)this.access.get()).get();
        this.access.setPosition(zFloor + 1, 2);
        double dz = z - (double)zFloor;
        return (((DoubleType)this.access.get()).get() - floorVal) * dz + floorVal;
    }

    protected double applyChecked(double z, int x, int y) {
        if (z < 0.0) {
            return -1.7976931348623157E308;
        }
        if (z >= (double)this.lutMaxIndex) {
            return Double.MAX_VALUE;
        }
        return this.apply(z, x, y);
    }

    protected int findFloorIndex(double zPrime, int x, int y) {
        this.access.setPosition(x, 0);
        this.access.setPosition(y, 1);
        int min = 0;
        int max = this.lutMaxIndex;
        int i = max >> 1;
        do {
            this.access.setPosition(i, 2);
            if (((DoubleType)this.access.get()).get() > zPrime) {
                max = i;
                continue;
            }
            min = i;
        } while ((i = (max - min >> 1) + min) != min);
        return i;
    }

    protected double applyInverse(double zPrime, int x, int y) {
        int i = this.findFloorIndex(zPrime, x, y);
        this.access.setPosition(x, 0);
        this.access.setPosition(y, 1);
        this.access.setPosition(i, 2);
        double z1 = ((DoubleType)this.access.get()).get();
        this.access.setPosition(i + 1, 2);
        double z2 = ((DoubleType)this.access.get()).get();
        return (zPrime - z1) / (z2 - z1) + (double)i;
    }

    protected double applyInverseChecked(double zPrime, int x, int y) {
        this.access.setPosition(x, 0);
        this.access.setPosition(y, 1);
        this.access.setPosition(0, 2);
        double lowVal = ((DoubleType)this.access.get()).get();
        this.access.setPosition(this.lutMaxIndex, 2);
        double highVal = ((DoubleType)this.access.get()).get();
        if (zPrime < lowVal) {
            return -1.7976931348623157E308;
        }
        if (zPrime > highVal) {
            return Double.MAX_VALUE;
        }
        return this.applyInverse(zPrime, x, y);
    }

    public double minTransformedCoordinate(int x, int y) {
        this.access.setPosition(x, 0);
        this.access.setPosition(y, 1);
        this.access.setPosition(0, 2);
        return ((DoubleType)this.access.get()).get();
    }

    public double maxTransformedCoordinate(int x, int y) {
        this.access.setPosition(x, 0);
        this.access.setPosition(y, 1);
        this.access.setPosition(this.lutMaxIndex, 2);
        return ((DoubleType)this.access.get()).get();
    }

    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }
}

