/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;

public class Erode_
implements PlugInFilter {
    private static final int DEFAULT_ISO_VALUE = 255;
    private static final String ISO_VALUE_KEY = "VIB.Erode.isoValue";
    private int w;
    private int h;
    private int d;
    private ImagePlus image;
    private byte[][] pixels_in;
    private byte[][] pixels_out;

    public void run(ImageProcessor ip) {
        String iso = Prefs.get((String)ISO_VALUE_KEY, (String)String.valueOf(255));
        int isoValue = Integer.parseInt(iso);
        GenericDialog gd = new GenericDialog("Erode");
        gd.addNumericField("Iso value", (double)isoValue, 0);
        gd.addHelp("http://imagej.net/3D_Binary_Filters");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        isoValue = (int)gd.getNextNumber();
        Prefs.set((String)ISO_VALUE_KEY, (int)isoValue);
        this.erode(this.image, isoValue, false).show();
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 131;
    }

    public ImagePlus erode(ImagePlus image, int threshold, boolean newWin) {
        int z;
        this.w = image.getWidth();
        this.h = image.getHeight();
        this.d = image.getStackSize();
        this.pixels_in = new byte[this.d][];
        this.pixels_out = new byte[this.d][];
        for (z = 0; z < this.d; ++z) {
            this.pixels_in[z] = (byte[])image.getStack().getPixels(z + 1);
            this.pixels_out[z] = new byte[this.w * this.h];
        }
        for (z = 0; z < this.d; ++z) {
            IJ.showProgress((int)z, (int)(this.d - 1));
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    if (this.get(x, y, z) != threshold) {
                        this.set(x, y, z, this.get(x, y, z));
                        continue;
                    }
                    if (this.get(x - 1, y, z) == threshold && this.get(x + 1, y, z) == threshold && this.get(x, y - 1, z) == threshold && this.get(x, y + 1, z) == threshold && this.get(x, y, z - 1) == threshold && this.get(x, y, z + 1) == threshold) {
                        this.set(x, y, z, threshold);
                        continue;
                    }
                    this.set(x, y, z, 0);
                }
            }
        }
        ColorModel cm = image.getStack().getColorModel();
        ImageStack stack = new ImageStack(this.w, this.h);
        for (int z2 = 0; z2 < this.d; ++z2) {
            stack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, this.pixels_out[z2], cm));
        }
        if (!newWin) {
            image.setStack(null, stack);
            return image;
        }
        ImagePlus result = new ImagePlus(image.getTitle() + "_eroded", stack);
        result.setCalibration(image.getCalibration());
        return result;
    }

    public int get(int x, int y, int z) {
        x = x < 0 ? 0 : x;
        x = x >= this.w ? this.w - 1 : x;
        y = y < 0 ? 0 : y;
        y = y >= this.h ? this.h - 1 : y;
        z = z < 0 ? 0 : z;
        z = z >= this.d ? this.d - 1 : z;
        return this.pixels_in[z][y * this.w + x] & 0xFF;
    }

    public void set(int x, int y, int z, int v) {
        this.pixels_out[z][y * this.w + x] = (byte)v;
    }
}

