/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Deformable_Registration
implements PlugIn {
    private ImagePlus model;
    private ImagePlus template;
    private byte[][] modelP;
    private byte[][] templateP;
    private int w;
    private int h;
    private int d;
    private GradientField gf;
    private DisplacementField df;
    private static final float LAMBDA = 100.0f;
    private static final int ITERATIONS = 100;
    private static final int STARTLEVEL = 1;
    private static final int STOPLEVEL = 1;
    private int level = 1;

    public void run(String arg) {
        int[] ids = WindowManager.getIDList();
        String[] images = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            images[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        GenericDialog gd = new GenericDialog("Deformable Registration");
        gd.addChoice("Model: ", images, images[0]);
        gd.addChoice("Template: ", images, images[0]);
        gd.addCheckbox("Load displacement", false);
        gd.addCheckbox("Register", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.model = WindowManager.getImage((String)gd.getNextChoice());
        this.template = WindowManager.getImage((String)gd.getNextChoice());
        this.init();
        if (gd.getNextBoolean()) {
            this.df.load(0);
            this.df.load(1);
            this.df.load(2);
        }
        if (gd.getNextBoolean()) {
            this.register();
        }
        this.apply();
    }

    private float A(int x, int y, int z) {
        return this.templateP[z][y * this.w + x] & 0xFF;
    }

    private float interpolate(float x, float y, float z, float v0, float v1, float v2, float v3, float v4, float v5, float v6, float v7, int grid) {
        float dx = x - (float)((int)x / grid);
        float dy = y - (float)((int)y / grid);
        float dz = z - (float)((int)z / grid);
        float i1 = v0 * ((float)grid - dz) + v4 * dz;
        float i2 = v2 * ((float)grid - dz) + v6 * dz;
        float j1 = v1 * ((float)grid - dz) + v5 * dz;
        float j2 = v3 * ((float)grid - dz) + v7 * dz;
        float w1 = i1 * ((float)grid - dy) + i2 * dy;
        float w2 = j1 * ((float)grid - dy) + j2 * dy;
        return w1 * ((float)grid - dx) + w2 * dx;
    }

    private float interpolate(float x, float y, float z, float v0, float v1, float v2, float v3, float v4, float v5, float v6, float v7) {
        return this.interpolate(x, y, z, v0, v1, v2, v3, v4, v5, v6, v7, 1);
    }

    private float B(int xp, int yp, int zp) {
        float z = (float)zp + this.df.u(xp, yp, zp, 0);
        float y = (float)yp + this.df.u(xp, yp, zp, 1);
        float x = (float)xp + this.df.u(xp, yp, zp, 2);
        int xl = (int)x;
        int yl = (int)y;
        int zl = (int)z;
        return this.interpolate(x, y, z, this.getB(xl, yl, zl), this.getB(xl + this.level, yl, zl), this.getB(xl, yl + this.level, zl), this.getB(xl + this.level, yl + this.level, zl), this.getB(xl, yl, zl + this.level), this.getB(xl + this.level, yl, zl + this.level), this.getB(xl, yl + this.level, zl + this.level), this.getB(xl + this.level, yl + this.level, zl + this.level), this.level);
    }

    private float getB(int x, int y, int z) {
        if (z < 0) {
            z = 0;
        }
        if (z >= this.d) {
            z = this.d - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (x >= this.w) {
            x = this.w - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.h) {
            y = this.h - 1;
        }
        return this.modelP[z][y * this.w + x] & 0xFF;
    }

    private final void update(int x, int y, int z, int n) {
        float g = this.gf.g(x, y, z, n);
        float L = 100.0f * this.df.del2u(x, y, z, n) - (this.B(x, y, z) - this.A(x, y, z)) * g;
        this.df.add(x, y, z, n, L / (100.0f + g * g));
        for (int iz = 0; iz < this.level; ++iz) {
            for (int iy = 0; iy < this.level; ++iy) {
                for (int ix = 0; ix < this.level; ++ix) {
                    this.df.set(x + ix, y + iy, z + iz, n, this.df.u(x, y, z, n));
                }
            }
        }
    }

    private void register() {
        int iterations = 100;
        while (this.level >= 1) {
            IJ.showStatus((String)("Level " + this.level));
            this.registerLevel(iterations);
            iterations *= 2;
            this.level /= 2;
        }
        this.level = 1;
    }

    private void registerLevel(int iterations) {
        for (int k = 0; k < iterations; ++k) {
            for (int z = 0; z <= this.d - this.level; z += this.level) {
                for (int y = 0; y <= this.h - this.level; y += this.level) {
                    for (int x = 0; x <= this.w - this.level; x += this.level) {
                        for (int n = 0; n < 3; ++n) {
                            this.update(x, y, z, n);
                        }
                    }
                }
            }
            IJ.showProgress((int)k, (int)iterations);
        }
    }

    private void apply() {
        ImageStack stack = new ImageStack(this.w, this.h);
        byte[][] b = new byte[this.d][this.w * this.h];
        for (int z = 0; z < this.d; ++z) {
            for (int y = 0; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    b[z][y * this.w + x] = (byte)this.B(x, y, z);
                }
            }
            stack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, b[z], null));
        }
        new ImagePlus("result", stack).show();
        this.df.show(0);
        this.df.show(1);
        this.df.show(2);
    }

    private void init() {
        this.w = this.template.getWidth();
        this.h = this.template.getHeight();
        this.d = this.template.getStackSize();
        this.templateP = new byte[this.d][];
        this.modelP = new byte[this.d][];
        for (int z = 0; z < this.d; ++z) {
            this.templateP[z] = (byte[])this.template.getStack().getProcessor(z + 1).getPixels();
            this.modelP[z] = (byte[])this.model.getStack().getProcessor(z + 1).getPixels();
        }
        this.gf = new GradientField();
        this.df = new DisplacementField();
    }

    private class GradientField {
        private float[][][] g;

        private GradientField() {
            this.g = new float[3][Deformable_Registration.this.d][Deformable_Registration.this.w * Deformable_Registration.this.h];
            this.gradX();
            this.gradY();
            this.gradZ();
        }

        private float g(int xp, int yp, int zp, int n) {
            float z = (float)zp + Deformable_Registration.this.df.u(xp, yp, zp, 0);
            float y = (float)yp + Deformable_Registration.this.df.u(xp, yp, zp, 1);
            float x = (float)xp + Deformable_Registration.this.df.u(xp, yp, zp, 2);
            int xl = (int)x;
            int yl = (int)y;
            int zl = (int)z;
            return Deformable_Registration.this.interpolate(x, y, z, this.getG(xl, yl, zl, n), this.getG(xl + Deformable_Registration.this.level, yl, zl, n), this.getG(xl, yl + Deformable_Registration.this.level, zl, n), this.getG(xl + Deformable_Registration.this.level, yl + Deformable_Registration.this.level, zl, n), this.getG(xl, yl, zl + Deformable_Registration.this.level, n), this.getG(xl + Deformable_Registration.this.level, yl, zl + Deformable_Registration.this.level, n), this.getG(xl, yl + Deformable_Registration.this.level, zl + Deformable_Registration.this.level, n), this.getG(xl + Deformable_Registration.this.level, yl + Deformable_Registration.this.level, zl + Deformable_Registration.this.level, n), Deformable_Registration.this.level);
        }

        private float getG(int x, int y, int z, int n) {
            if (z < 0) {
                z = 0;
            }
            if (z >= Deformable_Registration.this.d) {
                z = Deformable_Registration.this.d - 1;
            }
            if (x < 0) {
                x = 0;
            }
            if (x >= Deformable_Registration.this.w) {
                x = Deformable_Registration.this.w - 1;
            }
            if (y < 0) {
                y = 0;
            }
            if (y >= Deformable_Registration.this.h) {
                y = Deformable_Registration.this.h - 1;
            }
            return this.g[n][z][y * Deformable_Registration.this.w + x];
        }

        private void gradX() {
            for (int z = 0; z < Deformable_Registration.this.d; ++z) {
                byte[] p = (byte[])Deformable_Registration.this.model.getStack().getProcessor(z + 1).getPixels();
                for (int y = 0; y < Deformable_Registration.this.h; ++y) {
                    this.g[2][z][y * ((Deformable_Registration)Deformable_Registration.this).w] = (p[y * Deformable_Registration.this.w + 1] & 0xFF) - (p[y * Deformable_Registration.this.w] & 0xFF);
                    for (int x = 1; x < Deformable_Registration.this.w - 1; ++x) {
                        this.g[2][z][y * ((Deformable_Registration)Deformable_Registration.this).w + x] = (float)((p[y * Deformable_Registration.this.w + x + 1] & 0xFF) - (p[y * Deformable_Registration.this.w + x - 1] & 0xFF)) / 2.0f;
                    }
                    this.g[2][z][y * ((Deformable_Registration)Deformable_Registration.this).w + ((Deformable_Registration)Deformable_Registration.this).w - 1] = (p[y * Deformable_Registration.this.w + Deformable_Registration.this.w - 1] & 0xFF) - (p[y * Deformable_Registration.this.w + Deformable_Registration.this.w - 2] & 0xFF);
                }
            }
        }

        private void gradY() {
            for (int z = 0; z < Deformable_Registration.this.d; ++z) {
                int x;
                byte[] p = (byte[])Deformable_Registration.this.model.getStack().getProcessor(z + 1).getPixels();
                for (x = 0; x < Deformable_Registration.this.w; ++x) {
                    this.g[1][z][x] = (p[Deformable_Registration.this.w + x] & 0xFF) - (p[x] & 0xFF);
                }
                for (int y = 1; y < Deformable_Registration.this.h - 1; ++y) {
                    for (int x2 = 0; x2 < Deformable_Registration.this.w; ++x2) {
                        this.g[1][z][y * ((Deformable_Registration)Deformable_Registration.this).w + x2] = (float)((p[(y + 1) * Deformable_Registration.this.w + x2] & 0xFF) - (p[(y - 1) * Deformable_Registration.this.w + x2] & 0xFF)) / 2.0f;
                    }
                }
                for (x = 0; x < Deformable_Registration.this.w; ++x) {
                    this.g[1][z][(((Deformable_Registration)Deformable_Registration.this).h - 1) * ((Deformable_Registration)Deformable_Registration.this).w + x] = (p[(Deformable_Registration.this.h - 1) * Deformable_Registration.this.w + x] & 0xFF) - (p[(Deformable_Registration.this.h - 2) * Deformable_Registration.this.w + x] & 0xFF);
                }
            }
        }

        private void gradZ() {
            ImageStack s = Deformable_Registration.this.model.getStack();
            byte[] p = (byte[])s.getProcessor(1).getPixels();
            byte[] pp1 = (byte[])s.getProcessor(2).getPixels();
            for (int i = 0; i < Deformable_Registration.this.w * Deformable_Registration.this.h; ++i) {
                this.g[0][0][i] = (pp1[i] & 0xFF) - (p[i] & 0xFF);
            }
            for (int z = 1; z < Deformable_Registration.this.d - 1; ++z) {
                byte[] pm1 = (byte[])s.getProcessor(z).getPixels();
                p = (byte[])s.getProcessor(z + 1).getPixels();
                pp1 = (byte[])s.getProcessor(z + 2).getPixels();
                for (int i = 0; i < Deformable_Registration.this.w * Deformable_Registration.this.h; ++i) {
                    this.g[0][z][i] = (float)((pp1[i] & 0xFF) - (pm1[i] & 0xFF)) / 2.0f;
                }
            }
            byte[] pm1 = (byte[])s.getProcessor(Deformable_Registration.this.d - 1).getPixels();
            p = (byte[])s.getProcessor(Deformable_Registration.this.d).getPixels();
            for (int i = 0; i < Deformable_Registration.this.w * Deformable_Registration.this.h; ++i) {
                this.g[0][((Deformable_Registration)Deformable_Registration.this).d - 1][i] = (p[i] & 0xFF) - (pm1[i] & 0xFF);
            }
        }
    }

    private class DisplacementField {
        private float[][][] u;

        private DisplacementField() {
            this.u = new float[3][Deformable_Registration.this.d][Deformable_Registration.this.w * Deformable_Registration.this.h];
        }

        private float u(int x, int y, int z, int n) {
            return this.u[n][z][y * Deformable_Registration.this.w + x];
        }

        private void add(int x, int y, int z, int n, float v) {
            float[] fArray = this.u[n][z];
            int n2 = y * Deformable_Registration.this.w + x;
            fArray[n2] = fArray[n2] + v;
        }

        private void set(int x, int y, int z, int n, float v) {
            this.u[n][z][y * ((Deformable_Registration)Deformable_Registration.this).w + x] = v;
        }

        private void show(int n) {
            ImageStack stack = new ImageStack(Deformable_Registration.this.w, Deformable_Registration.this.h);
            for (int z = 0; z < Deformable_Registration.this.d; ++z) {
                stack.addSlice("", (ImageProcessor)new FloatProcessor(Deformable_Registration.this.w, Deformable_Registration.this.h, this.u[n][z], null));
            }
            new ImagePlus("Displacement_dim" + n, stack).show();
        }

        private void load(int n) {
            ImagePlus image = WindowManager.getImage((String)("Displacement_dim" + n));
            if (image == null) {
                return;
            }
            for (int z = 0; z < Deformable_Registration.this.d; ++z) {
                this.u[n][z] = (float[])image.getStack().getProcessor(z + 1).getPixels();
            }
        }

        private float del2u(int x, int y, int z, int n) {
            int zm1 = z >= Deformable_Registration.this.level ? z - Deformable_Registration.this.level : z + Deformable_Registration.this.level;
            int xm1 = x >= Deformable_Registration.this.level ? x - Deformable_Registration.this.level : x + Deformable_Registration.this.level;
            int ym1 = y >= Deformable_Registration.this.level ? y - Deformable_Registration.this.level : y + Deformable_Registration.this.level;
            int zp1 = z < Deformable_Registration.this.d - Deformable_Registration.this.level ? z + Deformable_Registration.this.level : z - Deformable_Registration.this.level;
            int xp1 = x < Deformable_Registration.this.w - Deformable_Registration.this.level ? x + Deformable_Registration.this.level : x - Deformable_Registration.this.level;
            int yp1 = y < Deformable_Registration.this.h - Deformable_Registration.this.level ? y + Deformable_Registration.this.level : y - Deformable_Registration.this.level;
            return (this.u[n][z][y * Deformable_Registration.this.w + xp1] + this.u[n][z][y * Deformable_Registration.this.w + xm1] + this.u[n][z][yp1 * Deformable_Registration.this.w + x] + this.u[n][z][ym1 * Deformable_Registration.this.w + x] + this.u[n][zp1][y * Deformable_Registration.this.w + x] + this.u[n][zm1][y * Deformable_Registration.this.w + x]) / 6.0f - this.u[n][z][y * Deformable_Registration.this.w + x];
        }

        private final void interpolateU() {
            for (int z = 0; z <= Deformable_Registration.this.d - 2 * Deformable_Registration.this.level; z += Deformable_Registration.this.level) {
                for (int y = 0; y <= Deformable_Registration.this.h - 2 * Deformable_Registration.this.level; y += Deformable_Registration.this.level) {
                    for (int x = 0; x <= Deformable_Registration.this.w - 2 * Deformable_Registration.this.level; x += Deformable_Registration.this.level) {
                        for (int n = 0; n < 3; ++n) {
                            this.interpolateU(x, y, z, n);
                        }
                    }
                }
            }
        }

        private final void interpolateU(int x, int y, int z, int n) {
            for (int iz = 0; iz < Deformable_Registration.this.level; ++iz) {
                for (int iy = 0; iy < Deformable_Registration.this.level; ++iy) {
                    for (int ix = 0; ix < Deformable_Registration.this.level; ++ix) {
                        this.u[n][z + iz][(y + iy) * ((Deformable_Registration)Deformable_Registration.this).w + x + ix] = Deformable_Registration.this.interpolate(x + ix, y + iy, z + iz, this.u[n][z][y * Deformable_Registration.this.w + x], this.u[n][z][y * Deformable_Registration.this.w + x + Deformable_Registration.this.level], this.u[n][z][(y + Deformable_Registration.this.level) * Deformable_Registration.this.w + x], this.u[n][z][(y + Deformable_Registration.this.level) * Deformable_Registration.this.w + x + Deformable_Registration.this.level], this.u[n][z + Deformable_Registration.this.level][y * Deformable_Registration.this.w + x], this.u[n][z + Deformable_Registration.this.level][y + Deformable_Registration.this.level + x + Deformable_Registration.this.level], this.u[n][z + Deformable_Registration.this.level][(y + Deformable_Registration.this.level) * Deformable_Registration.this.w + x], this.u[n][z + Deformable_Registration.this.level][(y + Deformable_Registration.this.level) * Deformable_Registration.this.w + x + Deformable_Registration.this.level]);
                    }
                }
            }
        }
    }
}

