/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import adt.ByteProbability;
import ij.IJ;
import java.io.IOException;
import oldsegmenters.AutoLabeller;
import oldsegmenters.SegmentatorModel;

public class AutoLabellerNaive
extends AutoLabeller {
    public AutoLabellerNaive(String summeryLocation) throws IOException {
        super(summeryLocation);
    }

    @Override
    public void segment(SegmentatorModel model) {
        System.out.println("starting naive segmentation");
        int width = model.data.getWidth();
        int height = model.data.getHeight();
        int volume = model.data.getStackSize() * model.data.getWidth() * model.data.getHeight();
        byte[] pLabels = new byte[this.labelCount];
        for (int i = 0; i < this.labelCount; ++i) {
            AutoLabeller.LabelStats stat = (AutoLabeller.LabelStats)this.stats.get(this.labelIds[i]);
            pLabels[i] = ByteProbability.toByte(stat.volumeMean / (double)volume);
            System.out.println("p(label= " + (this.labelIds[i] & 0xFF) + ") = " + pLabels[i]);
        }
        for (int z = this.zMin; z <= this.zMax; ++z) {
            IJ.showProgress((int)z, (int)this.zMax);
            System.out.println("z = " + z);
            byte[] pixels = (byte[])model.data.getStack().getProcessor(z).getPixels();
            byte[] labelPixels = (byte[])model.getLabelImagePlus().getStack().getProcessor(z).getPixels();
            for (int x = this.xMin; x < this.xMax; ++x) {
                for (int y = this.yMin; y < this.yMax; ++y) {
                    int i = y * width + x;
                    byte[] intensityProbs = this.getIntensityProbs(pixels[i]);
                    byte[] spatialProbs = this.getSpatialProbs(x, y, z);
                    int ML = 0;
                    byte MLid = 0;
                    for (int materialIndex = 0; materialIndex < this.labelCount; ++materialIndex) {
                        byte materialId = this.labelIds[materialIndex];
                        AutoLabeller.LabelStats stat = (AutoLabeller.LabelStats)this.stats.get(materialId);
                        byte spatialProb = spatialProbs[materialIndex];
                        byte intensityProb = intensityProbs[materialIndex];
                        byte p = ByteProbability.multiply(spatialProb, intensityProb);
                        if ((p & 0xFF) <= (ML & 0xFF)) continue;
                        ML = p;
                        MLid = materialId;
                    }
                    labelPixels[i] = MLid;
                }
            }
            model.updateSlice(z);
        }
    }
}

