/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraParameters;
import ij.ImagePlus;
import vib.SegmentationViewerCanvas;

public class SegmentatorModel {
    final ImagePlus data;
    public static final String LABEL_IMAGE_PLUS = "SegmentatorModel.labels";
    public static final String LABEL_CANVAS = "SegmentatorModel.labels.canvas";
    public static final String CURRENT_MATERIAL = "SegmentatorModel.currentMaterial";

    public SegmentatorModel(ImagePlus data) {
        this.data = data;
    }

    public ImagePlus getLabelImagePlus() {
        return (ImagePlus)this.data.getProperty(LABEL_IMAGE_PLUS);
    }

    public void setLabelImagePlus(ImagePlus ip) {
        this.data.setProperty(LABEL_IMAGE_PLUS, (Object)ip);
    }

    public ImagePlus getOriginalImage() {
        return this.data;
    }

    public SegmentationViewerCanvas getLabelCanvas() {
        return (SegmentationViewerCanvas)((Object)this.data.getProperty(LABEL_CANVAS));
    }

    public void setLabelCanvas(SegmentationViewerCanvas canvas) {
        this.data.setProperty(LABEL_CANVAS, (Object)canvas);
    }

    public AmiraParameters getMaterialParams() {
        if (this.getLabelImagePlus() == null) {
            return null;
        }
        return new AmiraParameters(this.getLabelImagePlus());
    }

    public void setCurrentMaterial(AmiraParameters.Material currentMaterial) {
        this.data.setProperty(CURRENT_MATERIAL, (Object)currentMaterial);
    }

    public AmiraParameters.Material getCurrentMaterial() {
        return (AmiraParameters.Material)this.data.getProperty(CURRENT_MATERIAL);
    }

    public void updateSlice(int z) {
        this.getLabelCanvas().updateSlice(z);
        this.data.updateAndDraw();
    }

    public void updateSliceNoRedraw(int z) {
        this.getLabelCanvas().updateSlice(z);
    }
}

