/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import view5d.AnElement;

public class ShortElement
extends AnElement {
    public short[] myData = new short[this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
    int NumBytes = 2;
    int SizeXY = this.Sizes[0] * this.Sizes[1];

    ShortElement(int SX, int SY, int SZ) {
        super(SX, SY, SZ, 256.0);
        this.DataType = ShortType;
        this.NumBytes = 2;
    }

    @Override
    void Clear() {
        for (int i = 0; i < this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0;
        }
    }

    @Override
    void DeleteData() {
        this.myData = null;
    }

    @Override
    int GetStdByteNum() {
        return 1;
    }

    @Override
    void SetValueAt(int x, int y, int z, double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        if (val > this.MaxValue - 1.0) {
            val = this.MaxValue - 1.0;
        }
        this.myData[x + this.Sizes[0] * y + this.SizeXY * z] = (short)val;
    }

    @Override
    int GetIntValueAt(int x, int y, int z) {
        short val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z];
        return (int)(((double)val - this.shift) * this.scaleI);
    }

    @Override
    int GetByteValueAt(int x, int y, int z) {
        int val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z] & 0xFF;
        return (int)(((double)val - this.shift) * this.scaleB);
    }

    @Override
    double GetRawValueAt(int x, int y, int z) {
        double val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z];
        return val;
    }

    @Override
    double GetValueAt(int x, int y, int z) {
        short val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z];
        return (double)val * this.ScaleV + this.OffsetV;
    }

    @Override
    void ConvertSliceFromSimilar(int myslice, int bufslice, Object Ibuffer, int mstep, int moff) {
        short[] mbuffer = (short[])Ibuffer;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = mbuffer[bufslice * this.SizeXY + i + moff];
        }
    }

    @Override
    void ConvertSliceFromByte(int myslice, int bufslice, byte[] Ibuffer, int mstep, int moff) {
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = Ibuffer[bufslice * this.SizeXY + i + moff];
        }
    }

    @Override
    void ConvertSliceFromRGB(int myslice, int bufslice, int[] Ibuffer, int mstep, int moff, int suboff) {
        int bitshift = suboff * 8;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = (short)(Ibuffer[bufslice * this.SizeXY + i + moff] >> bitshift & 0xFF);
        }
    }

    @Override
    void CopySliceToSimilar(int myslice, Object buffer) {
        short[] mbuffer = (short[])buffer;
        for (int i = 0; i < this.SizeXY; ++i) {
            mbuffer[i] = this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice];
        }
    }
}

