/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.subset.views;

import java.util.ArrayList;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.space.CalibratedSpace;
import net.imagej.space.DefaultCalibratedSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.subset.views.IterableSubsetView;
import net.imglib2.type.Type;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.Views;

@Deprecated
public class SubsetViews {
    public static final <T extends Type<T>> IterableRandomAccessibleInterval<T> iterableSubsetView(RandomAccessibleInterval<T> src, Interval interval) {
        return new IterableSubsetView<T>(src, interval);
    }

    public static final <T extends Type<T>> RandomAccessibleInterval<T> subsetView(RandomAccessibleInterval<T> src, Interval interval) {
        boolean oneSizedDims = false;
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.dimension(d) != 1L) continue;
            oneSizedDims = true;
            break;
        }
        if (SubsetViews.intervalEquals(src, interval) && !oneSizedDims) {
            return src;
        }
        if (!Intervals.contains(src, (Interval)interval)) {
            throw new IllegalArgumentException("Interval must fit into src in SubsetViews.subsetView(...)");
        }
        IntervalView res = Views.offsetInterval(src, (Interval)interval);
        for (int d = interval.numDimensions() - 1; d >= 0; --d) {
            if (interval.dimension(d) != 1L || res.numDimensions() <= 1) continue;
            res = Views.hyperSlice((RandomAccessibleInterval)res, (int)d, (long)0L);
        }
        return res;
    }

    public static <T> RandomAccessibleInterval<T> synchronizeDimensionality(RandomAccessibleInterval<T> src, CalibratedSpace<CalibratedAxis> srcSpace, Interval target, CalibratedSpace<CalibratedAxis> targetSpace) {
        assert (srcSpace.numDimensions() == src.numDimensions() && target.numDimensions() == targetSpace.numDimensions());
        if (SubsetViews.intervalEquals(src, target) && SubsetViews.spaceEquals(srcSpace, targetSpace)) {
            return src;
        }
        IntervalView res = src;
        DefaultCalibratedSpace resSpace = new DefaultCalibratedSpace(target.numDimensions());
        AxisType[] dispensable = SubsetViews.getDeltaAxes(targetSpace, srcSpace);
        for (int d = dispensable.length - 1; d >= 0; --d) {
            int idx = srcSpace.dimensionIndex(dispensable[d]);
            res = Views.hyperSlice(res, (int)idx, (long)0L);
        }
        int i = 0;
        block1: for (int d = 0; d < srcSpace.numDimensions(); ++d) {
            for (AxisType type : dispensable) {
                if (d == srcSpace.dimensionIndex(type)) continue block1;
            }
            resSpace.setAxis(srcSpace.axis(d), i++);
        }
        AxisType[] missing = SubsetViews.getDeltaAxes(srcSpace, targetSpace);
        i = srcSpace.numDimensions() - dispensable.length;
        for (AxisType type : missing) {
            int idx = targetSpace.dimensionIndex(type);
            res = Views.addDimension((RandomAccessibleInterval)res, (long)target.min(idx), (long)target.max(idx));
            resSpace.setAxis((Axis)new DefaultLinearAxis(type), i++);
        }
        assert (res.numDimensions() == targetSpace.numDimensions());
        IntervalView resRndAccessible = res;
        for (int d = 0; d < res.numDimensions(); ++d) {
            int srcIdx = resSpace.dimensionIndex(((CalibratedAxis)targetSpace.axis(d)).type());
            if (srcIdx == d) continue;
            resRndAccessible = Views.permute((RandomAccessible)resRndAccessible, (int)srcIdx, (int)d);
            CalibratedAxis tmp = (CalibratedAxis)resSpace.axis(d);
            resSpace.setAxis(targetSpace.axis(d), d);
            resSpace.setAxis((Axis)tmp, srcIdx);
        }
        return Views.interval((RandomAccessible)Views.extendBorder((RandomAccessibleInterval)Views.interval((RandomAccessible)resRndAccessible, (Interval)target)), (Interval)target);
    }

    public static <T> RandomAccessibleInterval<T> synchronizeDimensionality(RandomAccessibleInterval<T> src, Interval target) {
        int d;
        IntervalView res = src;
        if (SubsetViews.intervalEquals(src, target)) {
            return res;
        }
        if (res.numDimensions() < target.numDimensions()) {
            for (d = res.numDimensions(); d < target.numDimensions(); ++d) {
                res = Views.addDimension((RandomAccessibleInterval)res, (long)target.min(d), (long)target.max(d));
            }
        } else {
            for (d = res.numDimensions() - 1; d >= target.numDimensions(); --d) {
                res = Views.hyperSlice(res, (int)d, (long)0L);
            }
        }
        long[] resDims = new long[res.numDimensions()];
        res.dimensions(resDims);
        return Views.interval((RandomAccessible)Views.extendBorder((RandomAccessibleInterval)res), (Interval)target);
    }

    private static boolean spaceEquals(CalibratedSpace<CalibratedAxis> srcSpace, CalibratedSpace<CalibratedAxis> targetSpace) {
        if (srcSpace.numDimensions() != targetSpace.numDimensions()) {
            return false;
        }
        for (int d = 0; d < srcSpace.numDimensions(); ++d) {
            if (((CalibratedAxis)srcSpace.axis(d)).equals(targetSpace.axis(d))) continue;
            return false;
        }
        return true;
    }

    private static synchronized AxisType[] getDeltaAxes(CalibratedSpace<CalibratedAxis> sourceSpace, CalibratedSpace<CalibratedAxis> targetSpace) {
        ArrayList<AxisType> delta = new ArrayList<AxisType>();
        for (int d = 0; d < targetSpace.numDimensions(); ++d) {
            CalibratedAxis axis = (CalibratedAxis)targetSpace.axis(d);
            if (sourceSpace.dimensionIndex(axis.type()) != -1) continue;
            delta.add(axis.type());
        }
        return delta.toArray(new AxisType[delta.size()]);
    }

    public static synchronized boolean intervalEquals(Interval a, Interval b) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            if (a.min(d) == b.min(d) && a.max(d) == b.max(d)) continue;
            return false;
        }
        return true;
    }
}

