/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics.device;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.renjin.graphics.Color;
import org.renjin.graphics.GraphicParameters;
import org.renjin.graphics.GraphicsDeviceDriver;
import org.renjin.graphics.geom.Dimension;

public class AwtGraphicsDevice
implements GraphicsDeviceDriver {
    private final Graphics2D g2d;
    private Dimension size;

    public AwtGraphicsDevice(Graphics2D g2d, Dimension sizeInches) {
        this.g2d = g2d;
        this.size = sizeInches;
    }

    public AwtGraphicsDevice(Graphics2D g2d) {
        this.g2d = g2d;
        Rectangle bounds = g2d.getDeviceConfiguration().getBounds();
        this.size = new Dimension(bounds.getWidth() / 72.0, bounds.getHeight() / 72.0);
    }

    @Override
    public void drawRectangle(org.renjin.graphics.geom.Rectangle rect2, Color fillColor, Color borderColor, GraphicParameters parameters) {
        Rectangle2D.Double shape = new Rectangle2D.Double(rect2.getX1(), rect2.getY1(), rect2.getWidth(), rect2.getHeight());
        if (!fillColor.isTransparent()) {
            this.g2d.setPaint(this.toAwtColor(fillColor));
            this.g2d.fill(shape);
        }
        if (!borderColor.isTransparent()) {
            this.g2d.setColor(this.toAwtColor(borderColor));
            this.g2d.setStroke(this.currentStroke(parameters));
            this.g2d.draw(shape);
        }
    }

    private Stroke currentStroke(GraphicParameters parameters) {
        double lwd = parameters.getLineWidth();
        return new BasicStroke((float)lwd);
    }

    private java.awt.Color toAwtColor(Color color) {
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @Override
    public Dimension getInchesPerPixel() {
        org.renjin.graphics.geom.Rectangle bounds = this.getDeviceRegion();
        return new Dimension(this.size.getWidth() / bounds.getWidth(), this.size.getHeight() / bounds.getHeight());
    }

    @Override
    public Dimension getCharacterSize() {
        return new Dimension(10.8, 14.4);
    }

    @Override
    public org.renjin.graphics.geom.Rectangle getDeviceRegion() {
        Rectangle bounds = this.g2d.getDeviceConfiguration().getBounds();
        return new org.renjin.graphics.geom.Rectangle(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }
}

