/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Image3DUniverse;
import ij3d.Volume;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import marchingcubes.MCCube;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class MC_Test
implements PlugIn {
    private ImagePlus image;
    private byte[][] data;
    private static final Color3f GREY = new Color3f(0.753f, 0.753f, 0.753f);
    private static final Color3f RED = new Color3f(1.0f, 0.0f, 0.0f);

    public void run(String args) {
        int defaultNo = 1;
        final Image3DUniverse univ = new Image3DUniverse(512, 512);
        this.displayCube(univ);
        Transform3D initialRot = new Transform3D();
        Transform3D tmp = new Transform3D();
        initialRot.rotY(0.7853981633974483);
        tmp.rotX(-0.7853981633974483);
        initialRot.mul(tmp);
        univ.show();
        this.displayCase(univ, defaultNo);
        GenericDialog gd = new GenericDialog("ImageJ 3D Viewer");
        gd.addSlider("case: ", 0.0, 255.0, (double)defaultNo);
        final Scrollbar slider = (Scrollbar)gd.getSliders().get(0);
        slider.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                MC_Test.this.displayCase(univ, slider.getValue());
            }
        });
        gd.setModal(false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
    }

    public void displayCase(Image3DUniverse univ, int caseNo) {
        System.out.println("Case no " + caseNo);
        int threshold = 120;
        BranchGroup scene = univ.getScene();
        for (int i = scene.numChildren() - 1; i >= 1; --i) {
            if (!(scene.getChild(i) instanceof BranchGroup) || !scene.getChild(i).getCapability(17)) continue;
            scene.removeChild(i);
        }
        System.out.println("Nr. of contents:" + univ.getContents().size());
        univ.removeAllContents();
        this.createCase(caseNo);
        Volume volume = new Volume(this.image);
        List l = MCCube.getTriangles((Volume)volume, (int)threshold);
        univ.addTriangleMesh(l, RED, "case" + caseNo);
        for (int z = 0; z < this.data.length; ++z) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    if ((this.data[z][y * 2 + x] & 0xFF) >= threshold) {
                        this.addVertex(univ, RED, x, y, z);
                        continue;
                    }
                    this.addVertex(univ, GREY, x, y, z);
                }
            }
        }
    }

    public void addVertex(Image3DUniverse univ, Color3f color, float x, float y, float z) {
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        TransformGroup tg = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(new Vector3f(x, y, z));
        tg.setTransform(t3d);
        bg.addChild((Node)tg);
        Appearance app = new Appearance();
        ColoringAttributes cattr = new ColoringAttributes();
        cattr.setColor(color);
        app.setColoringAttributes(cattr);
        tg.addChild((Node)new Sphere(0.1f, app));
        univ.getScene().addChild((Node)bg);
    }

    public void createCase(int confID) {
        int value = -1;
        ImageStack stack = new ImageStack(2, 2);
        stack.addSlice("", (ImageProcessor)new ByteProcessor(2, 2));
        stack.addSlice("", (ImageProcessor)new ByteProcessor(2, 2));
        this.data = new byte[2][];
        this.data[0] = (byte[])stack.getProcessor(1).getPixels();
        this.data[1] = (byte[])stack.getProcessor(2).getPixels();
        if (confID >= 128) {
            this.data[1][0] = value;
            confID -= 128;
        }
        if (confID >= 64) {
            this.data[1][1] = value;
            confID -= 64;
        }
        if (confID >= 32) {
            this.data[1][3] = value;
            confID -= 32;
        }
        if (confID >= 16) {
            this.data[1][2] = value;
            confID -= 16;
        }
        if (confID >= 8) {
            this.data[0][0] = value;
            confID -= 8;
        }
        if (confID >= 4) {
            this.data[0][1] = value;
            confID -= 4;
        }
        if (confID >= 2) {
            this.data[0][3] = value;
            confID -= 2;
        }
        if (confID >= 1) {
            this.data[0][2] = value;
            --confID;
        }
        this.image = new ImagePlus("", stack);
    }

    public void displayCube(Image3DUniverse univ) {
        QuadArray qa = new QuadArray(24, 1);
        Point3f[] p = new Point3f[]{new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(0.0f, 0.0f, 1.0f)};
        Point3f[] coords = new Point3f[]{p[0], p[0], p[0], p[0], p[1], p[5], p[6], p[2], p[5], p[4], p[7], p[6], p[4], p[0], p[3], p[7], p[4], p[5], p[1], p[0], p[3], p[2], p[6], p[7]};
        qa.setCoordinates(0, coords);
        Appearance app = new Appearance();
        ColoringAttributes cattr = new ColoringAttributes();
        cattr.setColor(RED);
        app.setColoringAttributes(cattr);
        PolygonAttributes pattr = new PolygonAttributes();
        pattr.setPolygonMode(1);
        pattr.setCullFace(0);
        pattr.setBackFaceNormalFlip(true);
        app.setPolygonAttributes(pattr);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.addChild((Node)new Shape3D((Geometry)qa, app));
        univ.getScene().addChild((Node)bg);
    }
}

