/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import sc.fiji.kappa.gui.CurvesExporter;
import sc.fiji.kappa.gui.KappaFrame;
import sc.fiji.kappa.gui.ZoomInListener;
import sc.fiji.kappa.gui.ZoomOutListener;

public class ToolPanel
extends JPanel {
    public static final int NO_TOOLS = 3;
    public static final int NO_OTHER_BUTTONS = 2;
    static final String[] TOOL_TOOLTIPS = new String[]{"Selection Tool (V)", "Hand Tool (H)", "Control Point Tool (B)"};
    static final String[] TOOL_MENU_NAMES = new String[]{"Selection Tool", "Hand Tool", "Control Point Tool"};
    static final String[] TOOL_FILENAMES = new String[]{"direct-selection", "hand", "points"};
    static final int[] TOOL_MNEMONICS = new int[]{86, 72, 66};
    static final Cursor[] TOOL_CURSORS = new Cursor[]{Cursor.getDefaultCursor(), Cursor.getPredefinedCursor(12), Cursor.getPredefinedCursor(1)};
    private JToggleButton[] toolButtons = new JToggleButton[3];
    private ButtonGroup toolGroup;
    private ImageIcon[] toolIcons = new ImageIcon[3];
    static final String[] OTHER_TOOLTIPS = new String[]{"Zoom In", "Zoom Out"};
    static final String[] OTHER_FILENAMES = new String[]{"zoom-in", "zoom-out"};
    private JButton[] otherButtons = new JButton[2];
    private ImageIcon[] otherIcons = new ImageIcon[2];
    protected JButton export = new JButton(new ImageIcon(ToolPanel.class.getResource("/icons/export.png")));
    protected JButton exportAverage = new JButton(new ImageIcon(ToolPanel.class.getResource("/icons/export.png")));
    protected JToggleButton inspector = new JToggleButton(new ImageIcon(ToolPanel.class.getResource("/icons/inspector.png")));
    private static final long serialVersionUID = 1L;
    private KappaFrame frame;

    public ToolPanel(final KappaFrame frame) {
        int i;
        this.frame = frame;
        this.setBackground(KappaFrame.PANEL_COLOR);
        this.setPreferredSize(new Dimension(0, 35));
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.toolGroup = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 2));
        for (i = 0; i < 3; ++i) {
            this.toolIcons[i] = new ImageIcon(ToolPanel.class.getResource("/icons/" + TOOL_FILENAMES[i] + ".png"));
            this.toolButtons[i] = new JToggleButton(this.toolIcons[i]);
            this.toolButtons[i].setToolTipText(TOOL_TOOLTIPS[i]);
            this.toolButtons[i].setEnabled(false);
            final int j = i;
            this.toolButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    frame.getScrollPane().setCursor(TOOL_CURSORS[j]);
                }
            });
            this.add(this.toolButtons[i]);
            this.toolGroup.add(this.toolButtons[i]);
        }
        for (i = 0; i < 2; ++i) {
            this.otherIcons[i] = new ImageIcon(ToolPanel.class.getResource("/icons/" + OTHER_FILENAMES[i] + ".png"));
            this.otherButtons[i] = new JButton(this.otherIcons[i]);
            this.otherButtons[i].setToolTipText(OTHER_TOOLTIPS[i]);
            this.otherButtons[i].setEnabled(false);
            if (i == 0 || i == 3) {
                this.addSpacer(4);
            }
            this.add(this.otherButtons[i]);
        }
        this.add(Box.createHorizontalGlue());
        this.export.setToolTipText("Export All Points");
        this.export.addActionListener(new ExportListener());
        this.exportAverage.setToolTipText("Export Averages Points");
        this.exportAverage.addActionListener(new ExportAverageListener());
        this.add(this.export);
        this.add(this.exportAverage);
        this.inspector.setToolTipText("Inspector");
        this.inspector.setSelected(true);
        this.inspector.addActionListener(new InspectorListener());
        this.add(this.inspector);
        this.otherButtons[0].addActionListener(new ZoomInListener(frame.getControlPanel()));
        this.otherButtons[1].addActionListener(new ZoomOutListener(frame.getControlPanel()));
    }

    private void addSpacer(int spaceSize) {
        this.add(Box.createRigidArea(new Dimension(spaceSize, 0)));
        JSeparator spacer = new JSeparator(1);
        spacer.setMaximumSize(new Dimension(10, 35));
        this.add(spacer);
        this.add(Box.createRigidArea(new Dimension(spaceSize, 0)));
    }

    public void enableAllButtons() {
        for (JToggleButton jToggleButton : this.toolButtons) {
            jToggleButton.setEnabled(true);
        }
        for (AbstractButton abstractButton : this.otherButtons) {
            abstractButton.setEnabled(true);
        }
        this.toolButtons[0].setSelected(true);
        this.toolButtons[0].setCursor(TOOL_CURSORS[0]);
    }

    public boolean isSelected(int i) {
        return this.toolButtons[i].isSelected();
    }

    public boolean isEnabled(int i) {
        return this.toolButtons[i].isEnabled();
    }

    public void setSelected(int i, boolean selected) {
        this.toolButtons[i].setSelected(selected);
    }

    public void setEnabled(int i, boolean enabled) {
        this.toolButtons[i].setEnabled(enabled);
    }

    private class InspectorListener
    implements ActionListener {
        private InspectorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolPanel.this.inspector.isSelected()) {
                ToolPanel.this.frame.add((Component)ToolPanel.this.frame.getInfoPanel(), "East");
            }
            ToolPanel.this.frame.getInfoPanel().setVisible(ToolPanel.this.inspector.isSelected());
        }
    }

    private class ExportAverageListener
    implements ActionListener {
        private ExportAverageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CurvesExporter exporter = new CurvesExporter(ToolPanel.this.frame);
            try {
                exporter.export(true);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class ExportListener
    implements ActionListener {
        private ExportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CurvesExporter exporter = new CurvesExporter(ToolPanel.this.frame);
            try {
                exporter.export(false);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

