/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.Installer;
import net.imagej.updater.Uploader;
import net.imagej.updater.UploaderService;
import net.imagej.updater.util.Progress;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultUploaderService
extends AbstractService
implements UploaderService {
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;
    private HashMap<String, Uploader> uploaderMap;

    @Override
    public boolean hasUploader(String protocol) {
        return this.uploaderMap().containsKey(protocol);
    }

    @Override
    public Uploader getUploader(String protocol) throws IllegalArgumentException {
        Uploader uploader = this.uploaderMap().get(protocol);
        if (uploader == null) {
            throw new IllegalArgumentException("No uploader found for protocol " + protocol);
        }
        return uploader;
    }

    @Override
    public Uploader installUploader(String protocol, FilesCollection files, Progress progress) {
        if (this.hasUploader(protocol)) {
            return this.getUploader(protocol);
        }
        FileObject uploader = files.get("jars/imagej-plugins-uploader-" + protocol + ".jar");
        if (uploader == null && "sftp".equals(protocol)) {
            uploader = files.get("jars/imagej-plugins-uploader-ssh.jar");
        }
        if (uploader == null) {
            throw new IllegalArgumentException("No uploader found for protocol " + protocol);
        }
        switch (uploader.getStatus()) {
            case NEW: 
            case NOT_INSTALLED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The uploader found for protocol " + protocol + " could not be instantiated; the status of " + uploader + " is " + (Object)((Object)uploader.getStatus()));
            }
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        FilesCollection toInstall = files.clone(uploader.getFileDependencies(files, true));
        block14: for (FileObject file : toInstall) {
            switch (file.getStatus()) {
                case NEW: 
                case NOT_INSTALLED: 
                case UPDATEABLE: {
                    toInstall.add(file);
                    file.setAction(toInstall, FileObject.Action.INSTALL);
                    try {
                        urls.add(toInstall.prefixUpdate(file.filename).toURI().toURL());
                        continue block14;
                    }
                    catch (MalformedURLException e) {
                        this.log.error((Throwable)e);
                        return null;
                    }
                }
                case MODIFIED: {
                    toInstall.ignoredConflicts.add(file);
                    this.log.warn((Object)("Dependency " + file + " modified; the uploader might not be compatible"));
                }
                case INSTALLED: {
                    try {
                        urls.add(toInstall.prefix(file.filename).toURI().toURL());
                        continue block14;
                    }
                    catch (MalformedURLException e) {
                        this.log.error((Throwable)e);
                        return null;
                    }
                }
            }
            this.log.debug((Object)("Failure: dependency not installed: " + file + " (" + (Object)((Object)file.getStatus()) + ")"));
            return null;
        }
        progress.setTitle("Installing uploader for '" + protocol + "'");
        Installer installer = new Installer(toInstall, progress);
        try {
            installer.start();
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
            Thread.currentThread().setContextClassLoader(loader);
            this.pluginService.reloadPlugins();
            this.uploaderMap = null;
            return this.hasUploader(protocol) ? this.getUploader(protocol) : null;
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
            return null;
        }
    }

    private HashMap<String, Uploader> uploaderMap() {
        if (this.uploaderMap == null) {
            this.uploaderMap = new HashMap();
            List uploaders = this.pluginService.createInstancesOfType(Uploader.class);
            for (Uploader uploader : uploaders) {
                this.uploaderMap.put(uploader.getProtocol(), uploader);
            }
            this.log.debug((Object)("Found " + this.uploaderMap.size() + " upload mechanisms."));
        }
        return this.uploaderMap;
    }
}

