/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.TransformerConfigurationException;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.URLChange;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.HTTPSUtil;
import net.imagej.updater.util.UpdaterUtil;
import net.imagej.util.MediaWikiClient;
import org.scijava.log.LogService;
import org.scijava.log.Logger;
import org.xml.sax.SAXException;

public final class AvailableSites {
    private static final String SITE_LIST_PAGE_TITLE = "List of update sites";

    private AvailableSites() {
    }

    public static Map<String, UpdateSite> getAvailableSites() throws IOException {
        return AvailableSites.getAvailableSites(null);
    }

    public static Map<String, UpdateSite> getAvailableSites(Logger log) throws IOException {
        String text = AvailableSites.downloadWikiPage(log);
        Map<String, UpdateSite> result = AvailableSites.parseWikiPage(text);
        AvailableSites.runSanityChecks(result);
        return result;
    }

    private static String downloadWikiPage(Logger log) throws IOException {
        String wikiURL = HTTPSUtil.getProtocol() + "imagej.net/";
        if (log != null) {
            log.info((Object)("Reading available sites from " + wikiURL));
        } else {
            System.out.println("[INFO] Reading available sites from " + wikiURL);
        }
        MediaWikiClient wiki = new MediaWikiClient(wikiURL);
        return wiki.getPageSource(SITE_LIST_PAGE_TITLE);
    }

    private static Map<String, UpdateSite> parseWikiPage(String text) throws IOException {
        int start = text.indexOf("\n{| class=\"wikitable\"\n");
        int end = text.indexOf("\n|}\n", start);
        if (end < 0) {
            end = text.length();
        }
        if (start < 0) {
            throw new IOException("Could not find table");
        }
        String[] table = text.substring(start + 1, end).split("\n\\|-");
        LinkedHashMap<String, UpdateSite> result = new LinkedHashMap<String, UpdateSite>();
        int nameColumn = -1;
        int urlColumn = -1;
        int descriptionColumn = -1;
        int maintainerColumn = -1;
        for (String row : table) {
            if (row.matches("(?s)(\\{\\||[\\|!](style=\"vertical-align|colspan=\"4\")).*")) continue;
            String[] columns = row.split("\n[\\|!]");
            if (columns.length > 1 && columns[1].endsWith("|'''Name'''")) {
                maintainerColumn = -1;
                descriptionColumn = -1;
                urlColumn = -1;
                nameColumn = -1;
                int i = 0;
                for (String column : columns) {
                    if (column.endsWith("|'''Name'''")) {
                        nameColumn = i;
                    } else if (column.endsWith("|'''Site'''")) {
                        urlColumn = i;
                    } else if (column.endsWith("|'''URL'''")) {
                        urlColumn = i;
                    } else if (column.endsWith("|'''Description'''")) {
                        descriptionColumn = i;
                    } else if (column.endsWith("|'''Maintainer'''")) {
                        maintainerColumn = i;
                    }
                    ++i;
                }
                continue;
            }
            if (nameColumn < 0 || urlColumn < 0 || columns.length <= nameColumn || columns.length <= urlColumn) continue;
            String name = AvailableSites.stripWikiMarkup(columns, nameColumn);
            String url = AvailableSites.stripWikiMarkup(columns, urlColumn);
            String description = AvailableSites.stripWikiMarkup(columns, descriptionColumn);
            String maintainer = AvailableSites.stripWikiMarkup(columns, maintainerColumn);
            UpdateSite info = new UpdateSite(name, url, null, null, description, maintainer, 0L);
            info.setOfficial(true);
            result.put(info.getURL(), info);
        }
        return result;
    }

    private static void runSanityChecks(Map<String, UpdateSite> result) throws IOException {
        Iterator<UpdateSite> iter = result.values().iterator();
        if (!iter.hasNext()) {
            throw new IOException("Invalid page: List of update sites");
        }
    }

    public static List<URLChange> initializeAndAddSites(FilesCollection files, Logger log) {
        return AvailableSites.initializeAndAddSites(files, AvailableSites.tryGetAvailableSites(log));
    }

    public static void initializeAndAddSites(FilesCollection files, LogService log) {
        AvailableSites.initializeAndAddSites(files, AvailableSites.tryGetAvailableSites((Logger)log));
    }

    static List<URLChange> initializeAndAddSites(FilesCollection files, Collection<UpdateSite> availableSites) {
        List<UpdateSite> sites = AvailableSites.prepareAvailableUpdateSites(availableSites);
        ArrayList<URLChange> urlChanges = AvailableSites.mergeLocalAndAvailableUpdateSites(files, sites);
        AvailableSites.makeSureNamesAreUnique(sites);
        files.replaceUpdateSites(sites);
        return urlChanges;
    }

    private static List<UpdateSite> prepareAvailableUpdateSites(Collection<UpdateSite> availableSites) {
        for (UpdateSite site : availableSites) {
            site.setURL(HTTPSUtil.fixImageJUserSiteProtocol(site.getURL()));
        }
        ArrayList<UpdateSite> sites = new ArrayList<UpdateSite>();
        sites.add(AvailableSites.initializeMainUpdateSite());
        AvailableSites.addAvailableUpdateSites(sites, availableSites);
        return sites;
    }

    private static Collection<UpdateSite> tryGetAvailableSites(Logger log) {
        try {
            return AvailableSites.getAvailableSites(log).values();
        }
        catch (Exception e) {
            if (log != null) {
                log.error((Object)"Error processing available update sites from ImageJ wiki", (Throwable)e);
            } else {
                e.printStackTrace();
            }
            return Collections.emptyList();
        }
    }

    private static UpdateSite initializeMainUpdateSite() {
        UpdateSite mainSite = new UpdateSite("ImageJ", UpdaterUtil.MAIN_URL, "", "", null, null, 0L);
        mainSite.setOfficial(true);
        return mainSite;
    }

    private static void addAvailableUpdateSites(List<UpdateSite> sites, Collection<UpdateSite> availableSites) {
        for (UpdateSite site : availableSites) {
            Integer index = AvailableSites.findIndexByName(sites, site);
            if (index == null) {
                sites.add(site);
                continue;
            }
            sites.set(index, site);
        }
    }

    private static ArrayList<URLChange> mergeLocalAndAvailableUpdateSites(FilesCollection files, List<UpdateSite> sites) {
        ArrayList<URLChange> urlChanges = new ArrayList<URLChange>();
        for (UpdateSite local : files.getUpdateSites(true)) {
            Integer index = AvailableSites.findIndexByName(sites, local);
            if (index == null) {
                sites.add(local);
                Optional<URLChange> change = URLChange.create(local, HTTPSUtil.fixImageJUserSiteProtocol(local.getURL()));
                change.ifPresent(urlChanges::add);
                continue;
            }
            UpdateSite available = sites.get(index);
            local.setOfficial(available.isOfficial());
            local.setDescription(available.getDescription());
            local.setMaintainer(available.getMaintainer());
            Optional<URLChange> change = URLChange.create(local, available.getURL());
            change.ifPresent(urlChanges::add);
            sites.set(index, local);
        }
        return urlChanges;
    }

    private static Integer findIndexByName(List<UpdateSite> sites, UpdateSite site) {
        for (int i = 0; i < sites.size(); ++i) {
            if (!sites.get(i).getName().equals(site.getName())) continue;
            return i;
        }
        return null;
    }

    private static void makeSureNamesAreUnique(List<UpdateSite> sites) {
        HashSet<String> names = new HashSet<String>();
        for (UpdateSite site : sites) {
            if (site.isActive()) continue;
            if (names.contains(site.getName())) {
                int i = 2;
                while (names.contains(site.getName() + "-" + i)) {
                    ++i;
                }
                site.setName(site.getName() + "-" + i);
            }
            names.add(site.getName());
        }
    }

    public static void initializeAndAddSites(FilesCollection files) {
        AvailableSites.initializeAndAddSites(files, (Logger)null);
    }

    private static String stripWikiMarkup(String[] columns, int index) {
        if (index < 0 || index >= columns.length) {
            return null;
        }
        String string = columns[index];
        return string.replaceAll("'''", "").replaceAll("\\[\\[([^\\|\\]]*\\|)?([^\\]]*)\\]\\]", "$2").replaceAll("\\[[^\\[][^ ]*([^\\]]*)\\]", "$1");
    }

    public static boolean hasUpdateSiteURLUpdates(FilesCollection plugins) throws IOException {
        return AvailableSites.hasUpdateSiteURLUpdates(plugins, AvailableSites.getAvailableSites());
    }

    public static boolean hasUpdateSiteURLUpdates(FilesCollection plugins, Map<String, UpdateSite> availableSites) {
        for (UpdateSite site : availableSites.values()) {
            UpdateSite local = plugins.getUpdateSite(site.getName(), false);
            if (local == null || local.shouldKeepURL() || local.getURL().equals(site.getURL())) continue;
            return true;
        }
        return HTTPSUtil.hasImageJUserSiteProtocolUpdates(plugins);
    }

    public static void applySitesURLUpdates(FilesCollection plugins, List<URLChange> urlChanges) {
        for (URLChange site : urlChanges) {
            site.applyIfApproved();
        }
        try {
            plugins.write();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }
}

