/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.minimaven;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Stack;
import java.util.TreeSet;
import org.scijava.minimaven.BuildEnvironment;
import org.scijava.minimaven.Coordinate;
import org.scijava.minimaven.MavenProject;

public class MiniMaven {
    private static final void usage() {
        System.err.println("Usage: MiniMaven [options...] [command]\n\nSupported commands:\ncompile\n\tcompile the project\njar\n\tcompile the project into a .jar file\ninstall\n\tcompile & install the project and its dependencies\nrun\n\trun the project\ncompile-and-run\n\tcompile and run the project\nclean\n\tclean the project\nget-dependencies\n\tdownload the dependencies of the project\nlist\n\tshow list of projects\ndependency-tree\n\tshow the tree of depending projects\n\nOptions:\n-D<key>=<value>\n\tset a system property");
        System.exit(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        int offset;
        for (offset = 0; offset < args.length && args[offset].charAt(0) == '-'; ++offset) {
            String option = args[offset];
            if (option.startsWith("-D")) {
                int equals = option.indexOf(61, 2);
                String value = equals < 0 ? "true" : option.substring(equals + 1);
                System.setProperty(option.substring(2, equals < 0 ? option.length() : equals), value);
                continue;
            }
            if (option.equals("-U")) {
                System.setProperty("minimaven.updateinterval", "0");
                continue;
            }
            System.err.println("Unknown command: " + option);
            MiniMaven.usage();
        }
        String command = "compile-and-run";
        if (args.length == offset + 1) {
            command = args[offset];
        } else if (args.length > offset + 1) {
            MiniMaven.usage();
        }
        PrintStream err = System.err;
        BuildEnvironment env = new BuildEnvironment(err, "true".equals(MiniMaven.getSystemProperty("minimaven.download.automatically", "true")), "true".equals(MiniMaven.getSystemProperty("minimaven.verbose", "false")), "true".equals(MiniMaven.getSystemProperty("minimaven.debug", "false")));
        MavenProject root = env.parse(new File("pom.xml"), null);
        String artifactId = MiniMaven.getSystemProperty("artifactId", root.getArtifactId().equals("pom-ij-base") || root.getArtifactId().equals("pom-imagej") ? "ij-app" : root.getArtifactId());
        MavenProject pom = MiniMaven.findPOM(root, artifactId);
        if (pom == null) {
            String specifiedArtifactId = System.getProperty("artifactId");
            if (specifiedArtifactId != null) {
                System.err.println("Could not find project for artifactId '" + artifactId + "'!");
                System.exit(1);
            }
            pom = root;
        }
        if (command.equals("compile") || command.equals("build") || command.equals("compile-and-run")) {
            pom.build();
            if (!command.equals("compile-and-run")) return;
            command = "run";
        } else {
            if (command.equals("jar") || command.equals("jars")) {
                if (!pom.getBuildFromSource()) {
                    System.err.println("Cannot build " + pom + " from source");
                    System.exit(1);
                }
                pom.buildJar();
                if (!command.equals("jars")) return;
                pom.copyDependencies(pom.getTarget(), true);
                return;
            }
            if (command.equals("install")) {
                try {
                    pom.buildAndInstall();
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(1);
                }
            }
        }
        if (command.equals("clean")) {
            pom.clean();
            return;
        } else if (command.equals("get") || command.equals("get-dependencies")) {
            pom.downloadDependencies();
            return;
        } else if (command.equals("run")) {
            String mainClass = MiniMaven.getSystemProperty("mainClass", pom.getMainClass());
            if (mainClass == null) {
                err.println("No main class specified in pom " + pom.getCoordinate());
                System.exit(1);
            }
            String[] paths = pom.getClassPath(false).split(File.pathSeparator);
            URL[] urls = new URL[paths.length];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new URL("file:" + paths[i] + (paths[i].endsWith(".jar") ? "" : "/"));
            }
            URLClassLoader classLoader = new URLClassLoader(urls);
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> clazz = classLoader.loadClass(mainClass);
            Method main = clazz.getMethod("main", String[].class);
            main.invoke(null, new Object[]{new String[0]});
            return;
        } else if (command.equals("classpath")) {
            err.println(pom.getClassPath(false));
            return;
        } else if (command.equals("list")) {
            TreeSet<MavenProject> result = new TreeSet<MavenProject>();
            Stack<MavenProject> stack = new Stack<MavenProject>();
            stack.push(pom.getRoot());
            while (!stack.empty()) {
                pom = (MavenProject)stack.pop();
                if (result.contains(pom) || !pom.getBuildFromSource()) continue;
                result.add(pom);
                for (MavenProject child : pom.getChildren()) {
                    stack.push(child);
                }
            }
            for (MavenProject pom2 : result) {
                System.err.println(pom2);
            }
            return;
        } else if (command.equals("dependency-tree")) {
            MavenProject parent = pom.getParent();
            if (parent != null) {
                err.println("(parent: " + parent.getGAV() + ")");
            }
            MiniMaven.showDependencyTree(err, pom, "");
            return;
        } else {
            err.println("Unhandled command: " + command);
            MiniMaven.usage();
        }
    }

    protected static void showDependencyTree(PrintStream err, MavenProject pom, String prefix) {
        err.println(prefix + pom.getGAV());
        if ("pom".equals(pom.getPackaging())) {
            for (MavenProject child : pom.getChildren()) {
                MiniMaven.showDependencyTree(err, child, prefix + "\t");
            }
        } else {
            for (Coordinate coordinate : pom.getDirectDependencies()) {
                try {
                    MavenProject dependency = pom.findPOM(coordinate, true, false);
                    if (dependency == null) {
                        err.println(prefix + coordinate.getGAV() + " (not found)");
                        continue;
                    }
                    MiniMaven.showDependencyTree(err, dependency, prefix + "\t");
                }
                catch (Throwable t) {
                    err.println(prefix + coordinate.getGAV() + ": " + t);
                }
            }
        }
    }

    protected static void showTree(PrintStream err, MavenProject pom, String prefix) {
        err.println(prefix + pom.getGAV());
        MavenProject[] children = pom.getChildren();
        for (int i = 0; i < children.length; ++i) {
            MiniMaven.showTree(err, children[i], prefix + "\t");
        }
    }

    protected static MavenProject findPOM(MavenProject root, String artifactId) {
        if (artifactId == null || artifactId.equals(root.getArtifactId())) {
            return root;
        }
        for (MavenProject child : root.getChildren()) {
            MavenProject pom = MiniMaven.findPOM(child, artifactId);
            if (pom == null) continue;
            return pom;
        }
        return null;
    }

    protected static String getSystemProperty(String key, String defaultValue) {
        String result = System.getProperty(key);
        return result == null ? defaultValue : result;
    }
}

