/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.base;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.SpimDataInstantiationException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.base.Entity;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoEntity<T extends Entity> {
    private final String tag;
    private final Constructor<T> ctor;
    protected final HashSet<String> handledTags;
    private final HashMap<Integer, ArrayList<Element>> unhandledContent;
    private final Class<T> klass;

    public XmlIoEntity(String tag, Class<T> klass) {
        this.tag = tag;
        this.klass = klass;
        try {
            this.ctor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(klass.getSimpleName() + " must have a no-argument constructor.", e);
        }
        this.ctor.setAccessible(true);
        this.handledTags = new HashSet();
        this.handledTags.add("id");
        this.unhandledContent = new HashMap();
    }

    public String getTag() {
        return this.tag;
    }

    public Element toXml(T object) {
        Element elem = new Element(this.tag);
        elem.addContent((Content)XmlHelpers.intElement("id", ((Entity)object).getId()));
        ArrayList<Element> unhandled = this.unhandledContent.get(((Entity)object).getId());
        if (unhandled != null) {
            for (Element c : unhandled) {
                elem.addContent((Content)c.clone());
            }
        }
        return elem;
    }

    public T fromXml(Element elem) throws SpimDataException {
        Entity entity;
        try {
            entity = (Entity)this.ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SpimDataInstantiationException("Cannot instantiate Entity " + this.getEntityClass().getName(), e);
        }
        entity.setId(XmlHelpers.getInt(elem, "id"));
        ArrayList<Element> unhandled = new ArrayList<Element>();
        for (Element c : elem.getChildren()) {
            if (this.handledTags.contains(c.getName())) continue;
            unhandled.add(c.clone());
        }
        if (!unhandled.isEmpty()) {
            this.unhandledContent.put(entity.getId(), unhandled);
        }
        return (T)entity;
    }

    public Class<T> getEntityClass() {
        return this.klass;
    }
}

