/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XML {
    private final Document doc;
    private final XPath xpath;

    XML(File file) throws IOException {
        this(XML.loadXML(file));
    }

    XML(URL url) throws IOException {
        this(XML.loadXML(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XML(Document doc) {
        this.doc = doc;
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        try {
            XPath xp;
            ClassLoader loader = contextClassLoader;
            while (true) {
                try {
                    xp = XPathFactory.newInstance().newXPath();
                    try {
                        xp.evaluate("//dummy", doc);
                    }
                    catch (Throwable t) {
                        throw new Error(t);
                    }
                }
                catch (Error e) {
                    loader = loader.getParent();
                    if (loader == null) {
                        throw e;
                    }
                    thread.setContextClassLoader(loader);
                    continue;
                }
                break;
            }
            this.xpath = xp;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    String cdata(String expression) {
        NodeList nodes = this.xpath(expression);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return XML.cdata(nodes.item(0));
    }

    NodeList xpath(String expression) {
        Object result;
        try {
            result = this.xpath.evaluate(expression, this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return null;
        }
        return (NodeList)result;
    }

    private static String cdata(Node item) {
        NodeList children = item.getChildNodes();
        if (children.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    private static Document loadXML(URL url) throws IOException {
        InputStream in = url.openStream();
        Document document = XML.loadXML(in);
        in.close();
        return document;
    }

    private static Document loadXML(InputStream in) throws IOException {
        try {
            return XML.createBuilder().parse(in);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    private static Document loadXML(File file) throws IOException {
        try {
            return XML.createBuilder().parse(file.getAbsolutePath());
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    private static DocumentBuilder createBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }
}

