/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import ij.IJ;
import java.util.Date;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.fusion.IsolatedPixelWeightener;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.segmentation.DOM;
import mpicbg.spim.segmentation.IntegralImage3d;

public class AverageContent
extends IsolatedPixelWeightener<AverageContent> {
    Image<FloatType> gaussContent;

    protected AverageContent(ViewDataBeads view, ContainerFactory entropyContainer) {
        super(view);
        try {
            SPIMConfiguration conf = view.getViewStructure().getSPIMConfiguration();
            int rxy1 = Math.round(conf.fusionSigma1);
            int rxy2 = Math.round(conf.fusionSigma2);
            int rz1 = (int)Math.round((double)conf.fusionSigma1 / view.getZStretching());
            int rz2 = (int)Math.round((double)conf.fusionSigma2 / view.getZStretching());
            Image<FloatType> img = view.getImage(false);
            if (view.getViewStructure().getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing Integral Image");
            }
            Image<LongType> integralImg = IntegralImage3d.compute(img);
            Image imgConv = img.createNewImage();
            DOM.meanMirror(integralImg, (Image<FloatType>)imgConv, rxy1 * 2 + 1, rxy1 * 2 + 1, rz1 * 2 + 1);
            Cursor cursorImg = view.getImage().createCursor();
            Cursor cursorConv = imgConv.createCursor();
            while (cursorImg.hasNext()) {
                cursorImg.fwd();
                cursorConv.fwd();
                float diff = ((FloatType)cursorImg.getType()).get() - ((FloatType)cursorConv.getType()).get();
                ((FloatType)cursorConv.getType()).set(diff * diff);
            }
            IntegralImage3d.computeIntegralImage(integralImg, (Image<FloatType>)imgConv);
            DOM.meanMirror(integralImg, (Image<FloatType>)imgConv, rxy2 * 2 + 1, rxy2 * 2 + 1, rz2 * 2 + 1);
            integralImg.close();
            this.gaussContent = imgConv;
            ViewDataBeads.normalizeImage(this.gaussContent);
        }
        catch (OutOfMemoryError e) {
            IJ.log((String)("OutOfMemory: Cannot compute Gauss approximated Entropy for " + view.getName() + ": " + e));
            e.printStackTrace();
            this.gaussContent = null;
        }
    }

    @Override
    public LocalizableByDimCursor<FloatType> getResultIterator() {
        return this.gaussContent.createLocalizableByDimCursor();
    }

    @Override
    public LocalizableByDimCursor<FloatType> getResultIterator(OutOfBoundsStrategyFactory<FloatType> factory) {
        return this.gaussContent.createLocalizableByDimCursor(factory);
    }

    @Override
    public void close() {
        this.gaussContent.close();
    }

    @Override
    public Image<FloatType> getResultImage() {
        return this.gaussContent;
    }
}

