/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.io;

import java.util.ArrayList;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;

public class ProgramConfiguration {
    public String baseFolder;
    public String binariesFolder;
    public String librariesFolder;
    public String jobFolder;
    public String configFolder;
    public String configFileTemplate;
    public String javaExecutable;
    public String javaArguments;
    public String timepointPattern;
    public int[] timepoints;
    public String pluginsDir;

    public void parseTimePoints() throws ConfigurationParserException {
        ArrayList<Integer> tmp = SPIMConfiguration.parseIntegerString(this.timepointPattern);
        this.timepoints = new int[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            this.timepoints[i] = tmp.get(i);
        }
    }

    public void printParameters() {
        IOFunctions.println("baseFolder: " + this.baseFolder);
        IOFunctions.println("binariesFolder: " + this.binariesFolder);
        IOFunctions.println("librariesFolder: " + this.librariesFolder);
        IOFunctions.println("jobFolder: " + this.jobFolder);
        IOFunctions.println("configFolder: " + this.configFolder);
        IOFunctions.println("configFileTemplate: " + this.configFileTemplate);
        IOFunctions.println("javaExecutable: " + this.javaExecutable);
        IOFunctions.println("javaArguments: " + this.javaArguments);
        IOFunctions.println("timepointPattern: " + this.timepointPattern);
        if (this.timepoints != null) {
            System.out.print("Time Points: ");
            for (int tp : this.timepoints) {
                System.out.print(tp + " ");
            }
            IOFunctions.println();
        }
        IOFunctions.println("pluginsDir: " + this.pluginsDir);
    }
}

