/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocHXY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.ICM1.class, label="Haralick: Information Measure of Correlation 1")
public class DefaultICM1<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.ICM1 {
    private UnaryFunctionOp<double[][], double[]> coocHXYFunc;
    private UnaryFunctionOp<IterableInterval<T>, DoubleType> entropy;

    @Override
    public void initialize() {
        super.initialize();
        this.coocHXYFunc = Functions.unary(this.ops(), CoocHXY.class, double[].class, double[][].class, new Object[0]);
        this.entropy = Functions.unary(this.ops(), Ops.Haralick.Entropy.class, DoubleType.class, this.in(), this.numGreyLevels, this.distance, this.orientation);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double[] coochxy = this.coocHXYFunc.calculate(matrix);
        double res = (this.entropy.calculate(input).get() - coochxy[2]) / (coochxy[0] > coochxy[1] ? coochxy[0] : coochxy[1]);
        output.set(res);
    }
}

