/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.IFDM.class, label="Haralick: Inverse Difference Moment")
public class DefaultIFDM<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.IFDM {
    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double res = 0.0;
        int nrGrayLevels = matrix.length;
        for (int i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                res += matrix[i][j] / (double)(1 + (i - j) * (i - j));
            }
        }
        output.set(res);
    }
}

