/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d.mesh;

import net.imagej.ops.geom.geom3d.mesh.TriangularFacet;
import net.imagej.ops.geom.geom3d.mesh.UpdateablePointSet;
import net.imagej.ops.geom.geom3d.mesh.Vertex;

public class Horizon
extends UpdateablePointSet<TriangularFacet> {
    public Horizon(TriangularFacet f) {
        this.vertices = f.getVertices();
        this.neighbors = f.getNeighbors();
    }

    public void simpleMerge(TriangularFacet f) {
        int neighborIndex = this.neighbors.indexOf(f);
        int newVertex = -1;
        for (int i = 0; i < f.getVertices().size(); ++i) {
            if (this.vertices.indexOf((Object)f.getVertex(i)) != -1) continue;
            newVertex = i;
            break;
        }
        this.vertices.add(neighborIndex, f.getVertex(newVertex));
        this.neighbors.remove(neighborIndex);
        this.neighbors.add(neighborIndex, f.getNeighbor(newVertex));
        neighborIndex = (neighborIndex + 1) % (this.neighbors.size() + 1);
        newVertex = (newVertex + 1) % 3;
        this.neighbors.add(neighborIndex, f.getNeighbor(newVertex));
    }

    public void complexMerge(TriangularFacet f) {
        Vertex v0 = f.getVertex(0);
        Vertex v1 = f.getVertex(1);
        Vertex v2 = f.getVertex(2);
        if (this.hasEdge(v0, v2)) {
            if (this.hasEdge(v1, v0)) {
                this.mergeTwoAdjacentEdges(f, v0, 2);
            } else if (this.hasEdge(v2, v1)) {
                this.mergeTwoAdjacentEdges(f, v2, 1);
            }
        } else if (this.hasEdge(v2, v1)) {
            if (this.hasEdge(v0, v2)) {
                this.mergeTwoAdjacentEdges(f, v2, 1);
            } else if (this.hasEdge(v1, v0)) {
                this.mergeTwoAdjacentEdges(f, v1, 0);
            }
        } else if (this.hasEdge(v1, v0)) {
            if (this.hasEdge(v2, v1)) {
                this.mergeTwoAdjacentEdges(f, v1, 0);
            } else if (this.hasEdge(v0, v2)) {
                this.mergeTwoAdjacentEdges(f, v0, 2);
            }
        }
    }

    private void mergeTwoAdjacentEdges(TriangularFacet f, Vertex v0, int neighborIndex) {
        int i = this.vertices.indexOf((Object)v0);
        this.vertices.remove(i);
        this.neighbors.remove(i);
        this.neighbors.remove(i %= this.neighbors.size());
        this.neighbors.add(i, f.getNeighbor(neighborIndex));
    }
}

