/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.util.BdvHandle;
import bdv.viewer.ViewerPanel;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import fiji.plugin.trackmate.util.TMUtils;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.brush.BdvMouseBehaviourUtils;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.LabelingModel;

public class TMFloodFillController {
    private static final String PREF_KEY_FLOOD_FILL_MODE = "tm.labkit.floodFill.mode";
    private static final String PREF_KEY_FLOOD_ERASE_MODE = "tm.labkit.floodErase.mode";
    private final ViewerPanel viewer;
    private final LabelingModel model;
    private final BdvHandle bdv;
    private FloodFillMode modeFill;
    private FloodEraseMode modeErase;
    private boolean planarMode = false;
    private final FloodFillClick floodFillBehaviour = new FloodFillClick(() -> {
        Label selected = this.selectedLabel();
        switch (this.modeFill.ordinal()) {
            case 0: {
                return l -> l.add(selected);
            }
            case 1: {
                Collection<Label> visible = this.visibleLabels();
                return l -> {
                    l.removeAll(visible);
                    l.add(selected);
                };
            }
        }
        throw new IllegalArgumentException("Unknown flood fill mode: " + String.valueOf((Object)this.modeFill));
    });
    private final FloodFillClick floodEraseBehaviour = new FloodFillClick(() -> {
        switch (this.modeErase.ordinal()) {
            case 0: {
                Label selected = this.selectedLabel();
                return l -> l.remove(selected);
            }
            case 1: {
                Collection<Label> visible = this.visibleLabels();
                return l -> l.removeAll(visible);
            }
        }
        throw new IllegalArgumentException("Unknown flood fill mode: " + String.valueOf((Object)this.modeFill));
    });
    private static final String FLOOD_FILL = "flood fill";
    private static final String FLOOD_CLEAR = "flood clear";
    private static final String[] FLOOD_FILL_KEYS = new String[]{"L button1"};
    private static final String[] FLOOD_CLEAR_KEYS = new String[]{"R button1", "L button2", "L button3"};

    private Collection<Label> visibleLabels() {
        return ((Labeling)this.model.labeling().get()).getLabels().stream().filter(Label::isVisible).collect(Collectors.toList());
    }

    public TMFloodFillController(BdvHandle bdv, LabelingModel model) {
        this.bdv = bdv;
        this.viewer = bdv.getViewerPanel();
        this.model = model;
        RunnableAction nop = new RunnableAction("nop", () -> {});
        nop.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("F"));
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        this.modeFill = FloodFillMode.valueOf(prefs.get(TMFloodFillController.class, PREF_KEY_FLOOD_FILL_MODE, FloodFillMode.REPLACE.name()));
        this.modeErase = FloodEraseMode.valueOf(prefs.get(TMFloodFillController.class, PREF_KEY_FLOOD_ERASE_MODE, FloodEraseMode.REMOVE_ALL.name()));
    }

    private Label selectedLabel() {
        return (Label)this.model.selectedLabel().get();
    }

    private RealPoint displayToImageCoordinates(int x, int y) {
        RealPoint labelLocation = new RealPoint(3);
        labelLocation.setPosition(x, 0);
        labelLocation.setPosition(y, 1);
        labelLocation.setPosition(0, 2);
        this.viewer.displayToGlobalCoordinates((RealLocalizable)labelLocation);
        this.model.labelTransformation().applyInverse((RealPositionable)labelLocation, (RealLocalizable)labelLocation);
        return labelLocation;
    }

    public void setFloodFillMode(FloodFillMode mode) {
        this.modeFill = mode;
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        prefs.put(TMFloodFillController.class, PREF_KEY_FLOOD_FILL_MODE, mode.name());
    }

    public void setFloodEraseMode(FloodEraseMode mode) {
        this.modeErase = mode;
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        prefs.put(TMFloodFillController.class, PREF_KEY_FLOOD_ERASE_MODE, mode.name());
    }

    public FloodFillMode getFloodFillMode() {
        return this.modeFill;
    }

    public FloodEraseMode getFloodEraseMode() {
        return this.modeErase;
    }

    public void setFloodFillActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive((BdvHandle)this.bdv, (Behaviour)this.floodFillBehaviour, (boolean)active);
    }

    public void setRemoveBlobActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive((BdvHandle)this.bdv, (Behaviour)this.floodEraseBehaviour, (boolean)active);
    }

    public void setPlanarMode(boolean planarMode) {
        this.planarMode = planarMode;
    }

    private RandomAccessibleInterval<LabelingType<Label>> labeling() {
        RandomAccessibleInterval label = (RandomAccessibleInterval)this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)label, (int)(label.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return label;
    }

    public void install(Behaviours behaviors) {
        behaviors.behaviour((Behaviour)this.floodFillBehaviour, FLOOD_FILL, FLOOD_FILL_KEYS);
        behaviors.behaviour((Behaviour)this.floodEraseBehaviour, FLOOD_CLEAR, FLOOD_CLEAR_KEYS);
    }

    private class FloodFillClick
    implements ClickBehaviour {
        private final Supplier<Consumer<Set<Label>>> operationFactory;

        FloodFillClick(Supplier<Consumer<Set<Label>>> operationFactory) {
            this.operationFactory = operationFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void floodFill(RealLocalizable imageCoordinates) {
            ViewerPanel viewerPanel = TMFloodFillController.this.viewer;
            synchronized (viewerPanel) {
                Consumer<Set<Label>> operation;
                Point seed;
                IntervalView frame = TMFloodFillController.this.labeling();
                if (frame.numDimensions() == 3 && TMFloodFillController.this.planarMode) {
                    long z = Math.round(imageCoordinates.getDoublePosition(2));
                    frame = Views.hyperSlice(frame, (int)2, (long)z);
                }
                if (this.askUser((RandomAccessibleInterval<LabelingType<Label>>)frame, seed = this.roundAndReduceDimension(imageCoordinates, frame.numDimensions()), operation = this.operationFactory.get())) {
                    FloodFill.doFloodFillOnActiveLabels((RandomAccessibleInterval<LabelingType<Label>>)frame, seed, operation);
                }
            }
        }

        private boolean askUser(RandomAccessibleInterval<LabelingType<Label>> frame, Point seed, Consumer<Set<Label>> operation) {
            if (seed.numDimensions() == 3 && FloodFill.isBackgroundFloodFill(frame, seed, operation)) {
                String message = "Are you sure to flood fill the background of this 3d image?\n(This may take a while to compute.)";
                int result = JOptionPane.showConfirmDialog((Component)TMFloodFillController.this.viewer, "Are you sure to flood fill the background of this 3d image?\n(This may take a while to compute.)", "Flood Fill 3D Image", 2, 3);
                return result == 0;
            }
            return true;
        }

        private Point roundAndReduceDimension(RealLocalizable realLocalizable, int numDimesions) {
            Point point = new Point(numDimesions);
            for (int i = 0; i < point.numDimensions(); ++i) {
                point.setPosition(Math.round(realLocalizable.getDoublePosition(i)), i);
            }
            return point;
        }

        public void click(int x, int y) {
            this.floodFill((RealLocalizable)TMFloodFillController.this.displayToImageCoordinates(x, y));
            TMFloodFillController.this.model.dataChangedNotifier().notifyListeners(null);
        }
    }

    public static enum FloodFillMode {
        ADD("Add", "Add the selected label to the existing labels."),
        REPLACE("Replace", "Replace the existing labels with the selected label.");

        private final String name;
        private final String tooltip;

        private FloodFillMode(String name, String tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        public String toString() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    public static enum FloodEraseMode {
        REMOVE_SELECTED("Selected label", "Remove the selected label from the existing labels in the segment."),
        REMOVE_ALL("Remove All", "Remove all labels from the existing labels.");

        private final String name;
        private final String tooltip;

        private FloodEraseMode(String name, String tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        public String toString() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(TMLabKitFrame.KEY_CONFIG_SCOPE, new String[]{"trackmate-labkit"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(TMFloodFillController.FLOOD_FILL, FLOOD_FILL_KEYS, "Flood fill the  selected label at the mouse position.");
            descriptions.add(TMFloodFillController.FLOOD_CLEAR, FLOOD_CLEAR_KEYS, "Clear the selected label in the whole region at the mouse position.");
        }
    }

    private static class FloodFill {
        private FloodFill() {
        }

        public static void doFloodFillOnActiveLabels(RandomAccessibleInterval<LabelingType<Label>> labeling, Point seed, Consumer<? super LabelingType<Label>> operation) {
            LabelingType seedValue = FloodFill.getPixel(labeling, (Localizable)seed).copy();
            Predicate<LabelingType> visit = arg_0 -> FloodFill.lambda$doFloodFillOnActiveLabels$0((Set)seedValue, arg_0);
            FloodFill.cachedFloodFill(labeling, (Localizable)seed, visit, operation);
        }

        static <T> void cachedFloodFill(RandomAccessibleInterval<LabelingType<T>> image, Localizable seed, Predicate<? super LabelingType<T>> visit, Consumer<? super LabelingType<T>> operation) {
            CacheForPredicateLabelingType cachedVisit = new CacheForPredicateLabelingType(visit);
            CacheForOperationLabelingType cachedOperation = new CacheForOperationLabelingType(operation);
            FloodFill.doFloodFill(image, seed, cachedVisit, cachedOperation);
        }

        private static <T extends Type<T>> void doFloodFill(RandomAccessibleInterval<T> image, Localizable seed, Predicate<T> visit, Consumer<T> operation) {
            RandomAccess ra = image.randomAccess();
            ra.setPosition(seed);
            Type seedValue = ((Type)ra.get()).copy();
            Type seedValueChanged = seedValue.copy();
            operation.accept(seedValueChanged);
            if (visit.test(seedValueChanged)) {
                return;
            }
            BiPredicate<Type, Type> filter = (f, s) -> visit.test((Type)f);
            ExtendedRandomAccessibleInterval target = Views.extendValue(image, (Type)seedValueChanged);
            DiamondShape shape = new DiamondShape(1L);
            net.imglib2.algorithm.fill.FloodFill.fill((RandomAccessible)target, (RandomAccessible)target, (Localizable)seed, (Shape)shape, filter, operation);
        }

        private static boolean activeLabelsAreEquals(LabelingType<Label> a, Set<Label> b) {
            boolean bIsSubSetOfA = b.stream().filter(Label::isVisible).allMatch(arg_0 -> a.contains(arg_0));
            boolean aIsSubSetOfB = a.stream().filter(Label::isVisible).allMatch(b::contains);
            return aIsSubSetOfB && bIsSubSetOfA;
        }

        private static <T> T getPixel(RandomAccessible<T> image, Localizable position) {
            RandomAccess ra = image.randomAccess();
            ra.setPosition(position);
            return (T)ra.get();
        }

        public static boolean isBackgroundFloodFill(RandomAccessibleInterval<LabelingType<Label>> frame, Point seed, Consumer<Set<Label>> operation) {
            LabelingType seedValue = (LabelingType)frame.randomAccess().setPositionAndGet((Localizable)seed);
            LabelingType changedSeedValue = seedValue.copy();
            operation.accept((Set<Label>)changedSeedValue);
            long numberOfActiveLabelsBefore = seedValue.stream().filter(Label::isVisible).count();
            long numberOfActiveLabelsAfter = changedSeedValue.stream().filter(Label::isVisible).count();
            boolean isBackgroundFill = numberOfActiveLabelsBefore == 0L;
            boolean operationHasEffect = numberOfActiveLabelsAfter > 0L;
            return isBackgroundFill && operationHasEffect;
        }

        private static /* synthetic */ boolean lambda$doFloodFillOnActiveLabels$0(Set seedValue, LabelingType value) {
            return FloodFill.activeLabelsAreEquals((LabelingType<Label>)value, seedValue);
        }

        private static class CacheForPredicateLabelingType<T>
        implements Predicate<LabelingType<T>> {
            private final Predicate<? super LabelingType<T>> predicate;
            private final TIntIntMap cache = new TIntIntHashMap();
            private final int noEntryValue = this.cache.getNoEntryValue();

            CacheForPredicateLabelingType(Predicate<? super LabelingType<T>> predicate) {
                this.predicate = predicate;
            }

            @Override
            public boolean test(LabelingType<T> ts) {
                int input = ts.getIndex().getInteger();
                int cached = this.cache.get(input);
                if (cached == this.noEntryValue) {
                    boolean value = this.predicate.test(ts);
                    this.cache.put(input, value ? 1 : 0);
                    return value;
                }
                return cached == 1;
            }
        }

        private static class CacheForOperationLabelingType<T>
        implements Consumer<LabelingType<T>> {
            private final Consumer<? super LabelingType<T>> operation;
            private final TIntIntMap cache = new TIntIntHashMap();
            private final int noEntryValue = this.cache.getNoEntryValue();

            private CacheForOperationLabelingType(Consumer<? super LabelingType<T>> operation) {
                this.operation = operation;
            }

            @Override
            public void accept(LabelingType<T> value) {
                IntegerType valueIndex = value.getIndex();
                int input = valueIndex.getInteger();
                int cached = this.cache.get(input);
                if (cached == this.noEntryValue) {
                    this.operation.accept(value);
                    this.cache.put(input, valueIndex.getInteger());
                } else {
                    valueIndex.setInteger(cached);
                }
            }
        }
    }
}

