/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.gui.components.LogPanel;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import java.util.IntSummaryStatistics;
import org.scijava.Cancelable;

public class ExecuteTrackingDescriptor
extends WizardPanelDescriptor {
    public static final String KEY = "ExecuteTracking";
    private final TrackMate trackmate;

    public ExecuteTrackingDescriptor(TrackMate trackmate, LogPanel logPanel) {
        super(KEY);
        this.trackmate = trackmate;
        this.targetPanel = logPanel;
    }

    @Override
    public Runnable getForwardRunnable() {
        return () -> {
            long start = System.currentTimeMillis();
            boolean ok = this.trackmate.execTracking();
            if (!ok) {
                this.trackmate.getModel().getLogger().error(this.trackmate.getErrorMessage() + "\n");
            }
            long end = System.currentTimeMillis();
            Logger logger = this.trackmate.getModel().getLogger();
            logger.log(String.format("Tracking done in %.1f s.\n", Float.valueOf((float)(end - start) / 1000.0f)));
            TrackModel trackModel = this.trackmate.getModel().getTrackModel();
            int nTracks = trackModel.nTracks(false);
            IntSummaryStatistics stats = trackModel.unsortedTrackIDs(false).stream().mapToInt(id -> trackModel.trackSpots((Integer)id).size()).summaryStatistics();
            logger.log("Found " + nTracks + " tracks.\n");
            logger.log(String.format("  - avg size: %.1f spots.\n", stats.getAverage()));
            logger.log(String.format("  - min size: %d spots.\n", stats.getMin()));
            logger.log(String.format("  - max size: %d spots.\n", stats.getMax()));
        };
    }

    @Override
    public Cancelable getCancelable() {
        return this.trackmate;
    }
}

