/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import org.jhotdraw.gui.datatransfer.AWTClipboard;
import org.jhotdraw.gui.datatransfer.JNLPClipboard;
import org.jhotdraw.gui.datatransfer.OSXClipboard;

public class ClipboardUtil {
    private static Clipboard instance;

    public static Clipboard getClipboard() {
        if (instance != null) {
            return instance;
        }
        try {
            instance = new OSXClipboard(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
        catch (SecurityException e1) {
            try {
                Class<?> serviceManager = Class.forName("javax.jnlp.ServiceManager");
                instance = new JNLPClipboard(serviceManager.getMethod("lookup", String.class).invoke(null, "javax.jnlp.ClipboardService"));
            }
            catch (Exception e2) {
                instance = new AWTClipboard(new Clipboard("JVM Local Clipboard"));
            }
        }
        return instance;
    }

    public static void setClipboard(Clipboard instance) {
        ClipboardUtil.instance = instance;
    }
}

