/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.DrawingTool;
import net.imagej.FloodFiller;
import net.imagej.display.ImageDisplay;
import net.imagej.event.DatasetUpdatedEvent;
import net.imagej.options.OptionsChannels;
import net.imagej.plugins.tools.FloodFillToolConfig;
import net.imagej.plugins.tools.PixelRecorder;
import net.imagej.render.RenderingService;
import org.scijava.command.CommandService;
import org.scijava.display.event.input.MsClickedEvent;
import org.scijava.display.event.input.MsEvent;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.Tool;

@Plugin(type=Tool.class, name="FloodFill", label="Flood Fill", description="Flood Fill Tool", iconPath="/icons/tools/flood-fill.png", priority=-304.0)
public class FloodFillTool
extends AbstractTool {
    public static final double PRIORITY = -304.0;
    @Parameter
    private CommandService commandService;
    @Parameter
    private RenderingService renderingService;
    @Parameter
    private OptionsService optionsService;
    @Parameter(required=false)
    private EventService eventService;
    private Connectivity connectivity = Connectivity.EIGHT;

    public void setConnectivity(Connectivity c) {
        this.connectivity = c;
    }

    public Connectivity getConnectivity() {
        return this.connectivity;
    }

    public void configure() {
        this.commandService.run(FloodFillToolConfig.class, true, new Object[]{"tool", this});
    }

    public void onMouseClick(MsClickedEvent evt) {
        if (evt.getButton() == 0) {
            ImageDisplay imageDisplay = (ImageDisplay)evt.getDisplay();
            if (imageDisplay != null) {
                PixelRecorder recorder = new PixelRecorder(this.getContext(), false);
                if (recorder.record((MsEvent)evt)) {
                    DrawingTool drawingTool = this.initDrawingTool(recorder.wasAltKeyDown(), recorder.getDataset());
                    long[] currPos = this.getCurrPosition(imageDisplay);
                    this.floodFill(recorder.getCX(), recorder.getCY(), currPos, this.connectivity, drawingTool);
                    Dataset dataset = drawingTool.getDataset();
                    if (this.eventService != null) {
                        this.eventService.publish((SciJavaEvent)new DatasetUpdatedEvent(dataset, false));
                    }
                }
                recorder.releaseDataset();
            }
            evt.consume();
        }
    }

    private DrawingTool initDrawingTool(boolean altKeyDown, Dataset ds) {
        OptionsChannels opts = this.getChannelOptions();
        ChannelCollection fillValues = altKeyDown ? opts.getBgValues() : opts.getFgValues();
        DrawingTool tool = new DrawingTool(ds, this.renderingService);
        tool.setChannels(fillValues);
        tool.setUAxis(0);
        tool.setVAxis(1);
        tool.setLineWidth(1L);
        return tool;
    }

    private long[] getCurrPosition(ImageDisplay imageDisplay) {
        long[] currPos = new long[imageDisplay.numDimensions()];
        for (int i = 0; i < currPos.length; ++i) {
            currPos[i] = imageDisplay.getLongPosition(i);
        }
        return currPos;
    }

    private OptionsChannels getChannelOptions() {
        return (OptionsChannels)this.optionsService.getOptions(OptionsChannels.class);
    }

    private void floodFill(long u, long v, long[] position, Connectivity c, DrawingTool dTool) {
        dTool.setPosition(position);
        FloodFiller filler = new FloodFiller(dTool);
        if (c == Connectivity.FOUR) {
            filler.fill4(u, v, position);
        } else {
            filler.fill8(u, v, position);
        }
    }

    static enum Connectivity {
        EIGHT,
        FOUR;

    }
}

