/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.gadgets;

import java.util.List;

public class Statistics {
    static final double invSqrtTwo = 1.0 / Math.sqrt(2.0);

    public static double erf(double z) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
        double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        if (z >= 0.0) {
            return ans;
        }
        return -ans;
    }

    public static double phi(double z) {
        return 0.5 * (1.0 + Statistics.erf(z * invSqrtTwo));
    }

    public static double phi(double z, double mean, double sd) {
        return Statistics.phi((z - mean) / sd);
    }

    public static double stdDeviation(List<Double> values) {
        int count = values.size();
        double sum = 0.0;
        for (Double val : values) {
            sum += val.doubleValue();
        }
        double mean = sum / (double)count;
        sum = 0.0;
        for (Double val : values) {
            double diff = val - mean;
            double sqDiff = diff * diff;
            sum += sqDiff;
        }
        double stdDeviation = Math.sqrt(sum / (double)(count - 1));
        return stdDeviation;
    }
}

