/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyDialogs;
import QuickPALM.ParticleSaver;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.GaussianBlur;
import ij.process.ImageProcessor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class MyFunctions {
    GaussianBlur gblur = new GaussianBlur();
    ResultsTable ptable = Analyzer.getResultsTable();
    ResultsTable dtable = new ResultsTable();
    ResultsTable caltable = new ResultsTable();
    ParticleSaver psave;
    double[] cal3d_z;
    double[] cal3d_wmh;
    int cal3d_center;
    Lock ptable_lock = new ReentrantLock();
    boolean debug = false;

    MyFunctions() {
    }

    void MyFunctions() {
        this.ptable.setPrecision(3);
        this.dtable.setPrecision(3);
        this.caltable.setPrecision(3);
    }

    void log(String txt) {
        if (this.debug) {
            IJ.log((String)txt);
        }
    }

    void initialize3d() {
        this.cal3d_z = this.caltable.getColumnAsDoubles(0);
        this.cal3d_wmh = this.caltable.getColumnAsDoubles(1);
        this.cal3d_center = Math.round(this.cal3d_z.length / 2);
    }

    double getZ(double wmh) {
        int n = this.getClosest(wmh, this.cal3d_wmh, this.cal3d_center);
        if (n == 0 || n == this.cal3d_z.length - 1) {
            return 9999.0;
        }
        double x1 = (this.cal3d_wmh[n - 1] + this.cal3d_wmh[n]) / 2.0;
        double x2 = (this.cal3d_wmh[n + 1] + this.cal3d_wmh[n]) / 2.0;
        double y1 = (this.cal3d_z[n - 1] + this.cal3d_z[n]) / 2.0;
        double y2 = (this.cal3d_z[n + 1] + this.cal3d_z[n]) / 2.0;
        return y1 + (y2 - y1) / (x2 - x1) * (wmh - x1);
    }

    ImagePlus getNextImage(MyDialogs dg, int frame) {
        String imname = "" + frame;
        while (imname.length() < dg.nimchars) {
            imname = "0" + imname;
        }
        imname = dg.imagedir + dg.prefix + imname + dg.sufix;
        long start = System.currentTimeMillis();
        ImagePlus imp = IJ.openImage((String)imname);
        while (imp == null && System.currentTimeMillis() - start < (long)dg.waittime) {
            imp = IJ.openImage((String)imname);
            try {
                Thread.currentThread();
                Thread.sleep(1L);
            }
            catch (Exception e) {
                IJ.error((String)("" + e));
            }
        }
        if (imp != null && imp.getType() != 0 && imp.getType() != 1) {
            IJ.error((String)"8 or 16 bit greyscale image required");
        }
        return imp;
    }

    void detectParticles(ImageProcessor ip, MyDialogs dg, int nframe) {
        int[] maxs;
        int yend;
        int ystart;
        int xend;
        int j;
        int i;
        int width = ip.getWidth();
        int height = ip.getHeight();
        int s = 0;
        boolean[][] mask = new boolean[width][height];
        int xmin = 0;
        int ymin = 0;
        int smin = 99999;
        double saturation = ip.getMax();
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                s = ip.get(i, j);
                if (s < smin) {
                    smin = s;
                    xmin = i;
                    ymin = j;
                }
                if ((double)s != saturation) {
                    mask[i][j] = false;
                    continue;
                }
                mask[i][j] = true;
                ip.set(i, j, 0);
            }
        }
        ImageProcessor spip = ip.duplicate();
        ImageProcessor lpip = ip.duplicate();
        this.gblur.blur(spip, 0.5);
        this.gblur.blur(lpip, dg.fwhm * 2.0);
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                s = spip.get(i, j) - lpip.get(i, j);
                ip.set(i, j, s > 0 ? s : 0);
            }
        }
        int xstart = xmin - 6;
        if (xstart < 0) {
            xstart = 0;
        }
        if ((xend = xmin + 7) > width) {
            xend = width;
        }
        if ((ystart = ymin - 6) < 0) {
            ystart = 0;
        }
        if ((yend = ymin + 7) > height) {
            yend = height;
        }
        double noise = 0.0;
        int npixels = 0;
        for (i = xstart; i < xend; ++i) {
            for (j = ystart; j < yend; ++j) {
                s = ip.get(i, j);
                if (s <= 0) continue;
                noise += (double)ip.get(i, j);
                ++npixels;
            }
        }
        double snrthresh = (noise /= (double)npixels) * (double)dg.snr;
        int ok_nparticles = 0;
        int notok_nparticles = 0;
        int last_ok_nparticles = 0;
        int smartcounter = 0;
        for (int n = 0; n <= dg.maxpart && !((double)ip.get((maxs = this.getMaxPositions(ip))[1], maxs[2]) < snrthresh); ++n) {
            if (this.getParticle(ip, mask, maxs, dg, this.ptable, nframe)) {
                ++ok_nparticles;
            } else {
                ++notok_nparticles;
            }
            if (!dg.smartsnr) continue;
            if (last_ok_nparticles != ok_nparticles) {
                last_ok_nparticles = ok_nparticles;
                smartcounter = 0;
                continue;
            }
            if (ok_nparticles > 1 && (double)smartcounter > (double)dg.maxpart * 0.1) break;
            ++smartcounter;
        }
        IJ.log((String)("'OK'/'Not OK' Particles= " + ok_nparticles + "/" + notok_nparticles));
    }

    boolean getParticle(ImageProcessor ip, boolean[][] mask, int[] maxs, MyDialogs dg, ResultsTable ptable, int nframe) {
        double ysym;
        double sym;
        int j;
        int i;
        int roirad = (int)Math.round(dg.fwhm);
        int xmax = maxs[1];
        int ymax = maxs[2];
        int smax = ip.get(xmax, ymax);
        int xstart = xmax - roirad;
        int xend = xmax + 1 + roirad;
        int ystart = ymax - roirad;
        int yend = ymax + 1 + roirad;
        int width = ip.getWidth();
        int height = ip.getHeight();
        double thrsh = (double)smax * dg.pthrsh;
        if (xstart < 0 || xend >= width || ystart < 0 || yend >= height) {
            this.log("fail on perifery");
            xstart = xmax - roirad / 2;
            ystart = ymax - roirad / 2;
            xend = xmax + 1 + roirad / 2;
            yend = ymax + 1 + roirad / 2;
            xstart = xstart < 0 ? 0 : xstart;
            ystart = ystart < 0 ? 0 : ystart;
            xend = xend >= width ? width - 1 : xend;
            yend = yend >= height ? height - 1 : yend;
            this.clearRegion(thrsh, ip, mask, xstart, xend, ystart, yend);
            return false;
        }
        for (i = xstart; i <= xend; ++i) {
            for (j = ystart; j <= yend; ++j) {
                if (!mask[i][j]) continue;
                this.log("fail on already analysed");
                xstart = xmax - roirad / 2;
                ystart = ymax - roirad / 2;
                xend = xmax + 1 + roirad / 2;
                yend = ymax + 1 + roirad / 2;
                this.clearRegion(thrsh, ip, mask, xstart, xend, ystart, yend);
                return false;
            }
        }
        int npixels = 0;
        int s = 0;
        int sSum = 0;
        double xm = 0.0;
        double ym = 0.0;
        double xstd = 0.0;
        double ystd = 0.0;
        double xlstd = 0.0;
        double xrstd = 0.0;
        double ylstd = 0.0;
        double yrstd = 0.0;
        int xlsum = 0;
        int xrsum = 0;
        int ylsum = 0;
        int yrsum = 0;
        for (i = xstart; i <= xend; ++i) {
            for (j = ystart; j <= yend; ++j) {
                s = ip.get(i, j);
                if (!((double)s > thrsh)) continue;
                xm += (double)(i * s);
                ym += (double)(j * s);
                sSum += s;
                ++npixels;
            }
        }
        xm /= (double)sSum;
        ym /= (double)sSum;
        double sxdev = 0.0;
        double sydev = 0.0;
        for (i = xstart; i <= xend; ++i) {
            for (j = ystart; j <= yend; ++j) {
                s = ip.get(i, j);
                if (!((double)s > thrsh)) continue;
                sxdev = ((double)i - xm) * (double)s;
                sydev = ((double)j - ym) * (double)s;
                if (sxdev < 0.0) {
                    xlstd += -sxdev;
                    xlsum += s;
                } else {
                    xrstd += sxdev;
                    xrsum += s;
                }
                if (sydev < 0.0) {
                    ylstd += -sydev;
                    ylsum += s;
                } else {
                    yrstd += sydev;
                    yrsum += s;
                }
                xstd += Math.abs(sxdev);
                ystd += Math.abs(sydev);
            }
        }
        xstd /= (double)sSum;
        ystd /= (double)sSum;
        int xstart_ = (int)Math.round(xm - (xlstd /= (double)xlsum) * 1.177) - 1;
        int xend_ = (int)Math.round(xm + (xrstd /= (double)xrsum) * 1.177) + 1;
        int ystart_ = (int)Math.round(ym - (ylstd /= (double)ylsum) * 1.177) - 1;
        int yend_ = (int)Math.round(ym + (yrstd /= (double)yrsum) * 1.177) + 1;
        if (xstart_ > xstart) {
            xstart = xstart_;
        }
        if (ystart_ > ystart) {
            ystart = ystart_;
        }
        if (xend_ < xend) {
            xend = xend_;
        }
        if (yend_ < yend) {
            yend = yend_;
        }
        double wmh = (xlstd + xrstd - (ylstd + yrstd)) * 1.177;
        double z = 0.0;
        if (npixels < 5 || (xlstd + xrstd) * 1.177 > dg.fwhm || (ylstd + yrstd) * 1.177 > dg.fwhm) {
            this.log("fail on size");
            this.clearRegion(thrsh, ip, mask, xstart, xend, ystart, yend);
            return false;
        }
        double xsym = 1.0 - Math.abs((xlstd - xrstd) / (xlstd + xrstd));
        double d = sym = xsym < (ysym = 1.0 - Math.abs((ylstd - yrstd) / (ylstd + yrstd))) ? xsym : ysym;
        if (!dg.is3d) {
            if (sym < dg.symmetry) {
                this.log("fail on 2D symmetry");
                this.clearRegion(thrsh, ip, mask, xstart, xend, ystart, yend);
                return false;
            }
        } else {
            if (xsym < dg.symmetry || ysym < dg.symmetry) {
                this.log("fail on 3D symmetry");
                this.clearRegion(thrsh, ip, mask, xstart, xend, ystart, yend);
                return false;
            }
            z = this.getZ(wmh);
            if (z == 9999.0) {
                this.clearRegion(thrsh, ip, mask, xstart, xend, ystart, yend);
                return false;
            }
        }
        double s_ = sSum / npixels;
        double xm_ = xm * dg.pixelsize;
        double ym_ = ym * dg.pixelsize;
        double xlstd_ = xlstd * 1.177;
        double xrstd_ = xrstd * 1.177;
        double ylstd_ = ylstd * 1.177;
        double yrstd_ = yrstd * 1.177;
        double frame_ = nframe + 1;
        this.ptable_lock.lock();
        ptable.incrementCounter();
        ptable.addValue("Intensity", s_);
        ptable.addValue("X (px)", xm);
        ptable.addValue("Y (px)", ym);
        ptable.addValue("X (nm)", xm_);
        ptable.addValue("Y (nm)", ym_);
        ptable.addValue("Z (nm)", z);
        ptable.addValue("Left-Width (px)", xlstd_);
        ptable.addValue("Right-Width (px)", xrstd_);
        ptable.addValue("Up-Height (px)", ylstd_);
        ptable.addValue("Down-Height (px)", yrstd_);
        ptable.addValue("X Symmetry (%)", xsym);
        ptable.addValue("Y Symmetry (%)", ysym);
        ptable.addValue("Width minus Height (px)", wmh);
        ptable.addValue("Frame Number", frame_);
        this.ptable_lock.unlock();
        if (this.psave != null) {
            this.psave.saveParticle(s_, xm, ym, xm_, ym_, z, xlstd_, xrstd_, ylstd_, yrstd_, xsym, ysym, wmh, frame_);
        }
        this.clearRegion(thrsh, ip, mask, xstart, xend, ystart, yend);
        return true;
    }

    double[] getParticleForCalibration(ImageProcessor ip, MyDialogs dg, int xstart, int xend, int ystart, int yend) {
        double ysym;
        int j;
        int i;
        int npixels = 0;
        int s = 0;
        int sSum = 0;
        double xm = 0.0;
        double ym = 0.0;
        double xstd = 0.0;
        double ystd = 0.0;
        double xlstd = 0.0;
        double xrstd = 0.0;
        double ylstd = 0.0;
        double yrstd = 0.0;
        int xlsum = 0;
        int xrsum = 0;
        int ylsum = 0;
        int yrsum = 0;
        int smax = 0;
        for (i = xstart; i <= xend; ++i) {
            for (j = ystart; j <= yend; ++j) {
                s = ip.get(i, j);
                smax = s > smax ? s : smax;
            }
        }
        double thrsh = (double)smax * dg.pthrsh;
        for (i = xstart; i <= xend; ++i) {
            for (j = ystart; j <= yend; ++j) {
                s = ip.get(i, j);
                if (!((double)s > thrsh)) continue;
                xm += (double)(i * s);
                ym += (double)(j * s);
                sSum += s;
                ++npixels;
            }
        }
        xm /= (double)sSum;
        ym /= (double)sSum;
        double sxdev = 0.0;
        double sydev = 0.0;
        for (i = xstart; i <= xend; ++i) {
            for (j = ystart; j <= yend; ++j) {
                s = ip.get(i, j);
                if (!((double)s > thrsh)) continue;
                sxdev = ((double)i - xm) * (double)s;
                sydev = ((double)j - ym) * (double)s;
                if (sxdev < 0.0) {
                    xlstd += -sxdev;
                    xlsum += s;
                } else {
                    xrstd += sxdev;
                    xrsum += s;
                }
                if ((double)j - ym < 0.0) {
                    ylstd += -sydev;
                    ylsum += s;
                } else {
                    yrstd += sydev;
                    yrsum += s;
                }
                xstd += Math.abs(sxdev);
                ystd += Math.abs(sydev);
            }
        }
        xstd /= (double)sSum;
        ystd /= (double)sSum;
        double wmh = ((xlstd /= (double)xlsum) + (xrstd /= (double)xrsum) - ((ylstd /= (double)ylsum) + (yrstd /= (double)yrsum))) * 1.177;
        double xsym = 1.0 - Math.abs((xlstd - xrstd) / (xlstd + xrstd));
        double sym = xsym < (ysym = 1.0 - Math.abs((ylstd - xrstd) / (ylstd + xrstd))) ? xsym : ysym;
        double[] results = new double[]{sSum / npixels, xm, ym, xlstd, xrstd, ylstd, yrstd, wmh, sym};
        return results;
    }

    void clearRegion(double thrsh, ImageProcessor ip, boolean[][] mask, int xstart, int xend, int ystart, int yend) {
        for (int i = xstart; i <= xend; ++i) {
            for (int j = ystart; j <= yend; ++j) {
                int s = ip.get(i, j);
                if (!((double)s > thrsh)) continue;
                ip.set(i, j, 0);
                mask[i][j] = true;
            }
        }
    }

    int[] getMaxPositions(ImageProcessor ip) {
        int[] results = new int[]{0, 0, 0};
        int s = 0;
        for (int i = 0; i < ip.getWidth(); ++i) {
            for (int j = 0; j < ip.getHeight(); ++j) {
                s = ip.get(i, j);
                if (s <= results[0]) continue;
                results[0] = s;
                results[1] = i;
                results[2] = j;
            }
        }
        return results;
    }

    double mean(double[] array, int start, int stop) {
        double mean = 0.0;
        int l = array.length;
        if (start < 0) {
            start = 0;
        }
        if (stop > l) {
            stop = l;
        }
        for (int n = start; n <= stop; ++n) {
            mean += array[n];
        }
        if (mean != 0.0) {
            mean /= (double)(stop - start);
        }
        return mean;
    }

    int getClosest(double value, double[] arr, int center) {
        int closest = center;
        int nvalues = arr.length;
        double err = 0.0;
        double olderr = 9999999.0;
        int maxd = nvalues - center >= nvalues ? nvalues - center : center;
        for (int n = 0; n < maxd; ++n) {
            int p = center + n;
            if (p < nvalues && (err = Math.abs(value - arr[p])) < olderr) {
                closest = p;
                olderr = err;
            }
            if ((p = center - n) <= 0 || !((err = Math.abs(value - arr[p])) < olderr)) continue;
            closest = p;
            olderr = err;
        }
        return closest;
    }

    double[] movingMean(double[] arr, int window) {
        int nvalues = arr.length;
        double[] amean = new double[nvalues];
        int n = 0;
        while (n < nvalues) {
            int ws = 0;
            amean[n] = 0.0;
            for (int w = 0; w < 2 * window + 1; ++w) {
                if (n - window + w < 0 || n - window + w >= nvalues) continue;
                int n2 = n;
                amean[n2] = amean[n2] + arr[n - window + w];
                ++ws;
            }
            int n3 = n++;
            amean[n3] = amean[n3] / (double)ws;
        }
        return amean;
    }

    int argmax(double[] arr) {
        double v = arr[0];
        int p = 0;
        int nvalues = arr.length;
        for (int i = 0; i < nvalues; ++i) {
            if (!(arr[i] > v)) continue;
            v = arr[i];
            p = i;
        }
        return p;
    }

    int argmin(double[] arr) {
        double v = arr[0];
        int p = 0;
        int nvalues = arr.length;
        for (int i = 0; i < nvalues; ++i) {
            if (!(arr[i] < v)) continue;
            v = arr[i];
            p = i;
        }
        return p;
    }

    void showTable() {
        if (this.ptable.getCounter() < 5000000) {
            IJ.showStatus((String)"Creating particle table, this should take a few seconds...");
            this.ptable.show("Results");
        } else {
            IJ.showMessage((String)"Warning", (String)"Results table has too many particles, they will not be shown but the data still exists within it\nyou can still use all the plugin functionality or save table changes though the 'Save Particle Table' command.");
        }
    }
}

