/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.List;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Factory1D;
import org.ojalgo.access.StructureAnyD;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.Scalar;

abstract class ArrayFactory<N extends Number, I extends BasicArray<N>>
implements Factory1D<BasicArray<N>> {
    ArrayFactory() {
    }

    public abstract AggregatorSet<N> aggregator();

    @Override
    public final I copy(Access1D<?> source) {
        long tmpCount = source.count();
        I retVal = this.makeToBeFilled(tmpCount);
        retVal.fillMatching(source);
        return retVal;
    }

    @Override
    public final I copy(double ... source) {
        int tmpLength = source.length;
        I retVal = this.makeToBeFilled(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    @Override
    public final I copy(List<? extends Number> source) {
        int tmpSize = source.size();
        I retVal = this.makeToBeFilled(tmpSize);
        for (int i = 0; i < tmpSize; ++i) {
            retVal.set((long)i, source.get(i));
        }
        return retVal;
    }

    @Override
    public final I copy(Number ... source) {
        int tmpLength = source.length;
        I retVal = this.makeToBeFilled(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            retVal.set((long)i, source[i]);
        }
        return retVal;
    }

    public abstract FunctionSet<N> function();

    @Override
    public final I makeFilled(long count, NullaryFunction<?> supplier) {
        I retVal = this.makeToBeFilled(count);
        if (((BasicArray)retVal).isPrimitive()) {
            for (long i = 0L; i < count; ++i) {
                retVal.set(i, supplier.doubleValue());
            }
        } else {
            for (long i = 0L; i < count; ++i) {
                retVal.set(i, (Number)supplier.get());
            }
        }
        return retVal;
    }

    @Override
    public final I makeZero(long count) {
        return this.makeStructuredZero(count);
    }

    public abstract Scalar.Factory<N> scalar();

    abstract long getCapacityLimit();

    final SegmentedArray<N> makeSegmented(long ... structure) {
        long tmpTotalCount = StructureAnyD.count(structure);
        int tmpMax = PrimitiveMath.powerOf2Smaller(Math.min(tmpTotalCount, this.getCapacityLimit()));
        int tmpMin = PrimitiveMath.powerOf2Larger(tmpTotalCount / 0x7FFFFFF7L);
        if (tmpMin > tmpMax) {
            throw new IllegalArgumentException();
        }
        int tmpUse = Math.max(tmpMin, tmpMax - OjAlgoUtils.ENVIRONMENT.cores);
        return new SegmentedArray(tmpTotalCount, tmpUse, this);
    }

    abstract I makeStructuredZero(long ... var1);

    abstract I makeToBeFilled(long ... var1);

    @SafeVarargs
    final SegmentedArray<N> wrapAsSegments(BasicArray<N> ... segments) {
        return new SegmentedArray<N>(segments, this);
    }
}

