/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class NIOIntArray
implements ArrayDataAccess<NIOIntArray>,
IntAccess {
    protected IntBuffer data;

    public NIOIntArray(int numEntities) {
        this.data = ByteBuffer.allocateDirect(numEntities * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public NIOIntArray(int[] data) {
        IntBuffer bufferIn = IntBuffer.wrap(data);
        IntBuffer copy = ByteBuffer.allocateDirect(bufferIn.capacity()).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.data = copy.put(bufferIn);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public int getValue(int index) {
        return this.data.get(index);
    }

    @Override
    public void setValue(int index, int value) {
        this.data.put(index, value);
    }

    public int[] getCurrentStorageArray() {
        int[] outData = new int[this.data.capacity()];
        this.data.get(outData);
        return outData;
    }

    @Override
    public NIOIntArray createArray(int numEntities) {
        return new NIOIntArray(numEntities);
    }
}

