/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.dynamic;

import mpicbg.imglib.container.dynamic.DynamicContainer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.dynamic.DynamicCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class DynamicLocalizableCursor<T extends Type<T>>
extends DynamicCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public DynamicLocalizableCursor(DynamicContainer<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.numDimensions = container.getNumDimensions();
        this.position = image.createPositionArray();
        this.dimensions = container.getDimensions();
        this.reset();
    }

    @Override
    public void fwd() {
        ++this.internalIndex;
        this.accessor.updateIndex(this.internalIndex);
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.position[d] >= this.dimensions[d] - 1) continue;
            int n = d;
            this.position[n] = this.position[n] + 1;
            for (int e = 0; e < d; ++e) {
                this.position[e] = 0;
            }
            return;
        }
    }

    @Override
    public void fwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    @Override
    public boolean hasNext() {
        return this.internalIndex < this.container.getNumPixels() - 1;
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.type.updateIndex(0);
        this.internalIndex = 0;
        this.type.updateContainer(this);
        this.accessor.updateIndex(this.internalIndex);
        this.internalIndex = -1;
        this.isClosed = false;
        this.position[0] = -1;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public String getPositionAsString() {
        String pos = "(" + this.position[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            pos = pos + ", " + this.position[d];
        }
        pos = pos + ")";
        return pos;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

