/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.image.display.IntegerTypeDisplay;
import mpicbg.imglib.type.numeric.IntegerType;
import mpicbg.imglib.type.numeric.real.RealTypeImpl;
import mpicbg.imglib.util.Util;

public abstract class IntegerTypeImpl<T extends IntegerTypeImpl<T>>
extends RealTypeImpl<T>
implements IntegerType<T> {
    @Override
    public Display<T> getDefaultDisplay(Image<T> image) {
        return new IntegerTypeDisplay<T>(image);
    }

    @Override
    public double getMinIncrement() {
        return 1.0;
    }

    @Override
    public float getRealFloat() {
        return this.getIntegerLong();
    }

    @Override
    public double getRealDouble() {
        return this.getIntegerLong();
    }

    @Override
    public void setReal(float real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void setReal(double real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void inc() {
        this.setInteger(this.getIntegerLong() + 1L);
    }

    @Override
    public void dec() {
        this.setInteger(this.getIntegerLong() - 1L);
    }

    @Override
    public void setZero() {
        this.setInteger(0);
    }

    @Override
    public void setOne() {
        this.setInteger(1);
    }

    @Override
    public int compareTo(T c) {
        long b;
        long a = this.getIntegerLong();
        if (a > (b = c.getIntegerLong())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "" + this.getIntegerLong();
    }
}

