/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.color;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import script.imglib.color.fn.ChannelOp;
import script.imglib.math.fn.IFunction;

public class Channel
extends ChannelOp {
    private final int channel;
    private final int shift;

    public Channel(Image<? extends RGBALegacyType> img, int channel) throws IllegalArgumentException {
        super(img);
        if (channel > 4 || channel < 1) {
            throw new IllegalArgumentException("Channel must be 1 <= channel <= 4");
        }
        this.channel = channel;
        this.shift = (channel - 1) * 8;
    }

    @Override
    protected final int getShift() {
        return this.shift;
    }

    @Override
    public IFunction duplicate() {
        return new Channel(this.c.getImage(), this.channel);
    }
}

