/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.filters;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Entropy_Filter
implements PlugInFilter {
    private ImagePlus origImg = null;
    private int radius = 2;
    private int numBins = 256;

    public void run(ImageProcessor ip) {
        this.applyEntropy(ip, this.radius, this.numBins);
    }

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        this.origImg = imp;
        if (imp == null) {
            return 4096;
        }
        GenericDialog gd = new GenericDialog("Entropy filter");
        gd.addNumericField("Radius (in pixels)", 3.0, 0);
        gd.addNumericField("Number of bins", 256.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        this.radius = (int)gd.getNextNumber();
        this.numBins = (int)gd.getNextNumber();
        if (this.numBins <= 0 || this.numBins >= 256) {
            this.numBins = 256;
        }
        return 32831;
    }

    public FloatProcessor getEntropy(ImageProcessor ip, int radius, int numBins) {
        double log2 = Math.log(2.0);
        ip.resetMinAndMax();
        ByteProcessor bp = (ByteProcessor)ip.convertToByte(true);
        bp.setHistogramRange(0.0, 255.0);
        bp.setHistogramSize(numBins);
        FloatProcessor fp = new FloatProcessor(bp.getWidth(), bp.getHeight());
        int size = 2 * radius + 1;
        for (int i = 0; i < bp.getWidth(); ++i) {
            for (int j = 0; j < bp.getHeight(); ++j) {
                OvalRoi roi = new OvalRoi(i - radius, j - radius, size, size);
                bp.setRoi((Roi)roi);
                int[] histogram = bp.getHistogram();
                double total = 0.0;
                for (int k = 0; k < numBins; ++k) {
                    total += (double)histogram[k];
                }
                double entropy = 0.0;
                for (int k = 0; k < numBins; ++k) {
                    if (histogram[k] <= 0) continue;
                    double p = (double)histogram[k] / total;
                    entropy += -p * Math.log(p) / log2;
                }
                fp.putPixelValue(i, j, entropy);
            }
        }
        return fp;
    }

    public void applyEntropy(ImageProcessor ip, int radius, int numBins) {
        FloatProcessor fp = this.getEntropy(ip, radius, numBins);
        if (!(ip instanceof FloatProcessor)) {
            ImageProcessor ip2 = ip instanceof ByteProcessor ? fp.convertToByte(true) : fp.convertToShort(true);
            ip.setPixels(ip2.getPixels());
        } else {
            ip.setPixels(fp.getPixels());
        }
        ip.resetMinAndMax();
    }

    void showAbout() {
        IJ.showMessage((String)"Entropy filter...", (String)"Circular entropy filter by I. Arganda-Carreras\nImageJ local entropy filter. Output is 32-bit\n");
    }
}

