/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.GeneralPathOverlay;
import net.imagej.overlay.Overlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.BezierPathFunctions;
import net.imagej.ui.swing.overlay.GeneralPathFigure;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.overlay.PolygonFigure;
import net.imglib2.roi.GeneralPathRegionOfInterest;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;

@Plugin(type=JHotDrawAdapter.class, priority=98.5)
public class GeneralPathJHotDrawAdapter
extends AbstractJHotDrawAdapter<GeneralPathOverlay, GeneralPathFigure> {
    public static final double PRIORITY = 98.5;

    private static GeneralPathOverlay downcastOverlay(Overlay overlay) {
        assert (overlay instanceof GeneralPathOverlay);
        return (GeneralPathOverlay)overlay;
    }

    @Override
    public boolean supports(Tool tool) {
        return false;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof GeneralPathOverlay)) {
            return false;
        }
        return figure == null || figure instanceof GeneralPathFigure;
    }

    @Override
    public Overlay createNewOverlay() {
        GeneralPathOverlay o = new GeneralPathOverlay(this.getContext());
        return o;
    }

    @Override
    public Figure createDefaultFigure() {
        GeneralPathFigure figure = new GeneralPathFigure(new PolygonFigure());
        this.initDefaultSettings(figure);
        figure.set(AttributeKeys.WINDING_RULE, AttributeKeys.WindingRule.EVEN_ODD);
        return figure;
    }

    @Override
    public void updateOverlay(GeneralPathFigure figure, OverlayView view) {
        super.updateOverlay(figure, view);
        GeneralPathOverlay overlay = GeneralPathJHotDrawAdapter.downcastOverlay(view.getData());
        GeneralPathRegionOfInterest roi = (GeneralPathRegionOfInterest)overlay.getRegionOfInterest();
        roi.reset();
        BezierPathFunctions.addToRegionOfInterest(figure.getGeneralPath().getPathIterator(null), roi);
        overlay.update();
    }

    @Override
    public void updateFigure(OverlayView view, GeneralPathFigure figure) {
        super.updateFigure(view, figure);
        GeneralPathOverlay overlay = GeneralPathJHotDrawAdapter.downcastOverlay(view.getData());
        GeneralPathRegionOfInterest roi = (GeneralPathRegionOfInterest)overlay.getRegionOfInterest();
        figure.setGeneralPath(roi.getGeneralPath());
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Shape toShape(GeneralPathFigure figure) {
        return figure.getGeneralPath();
    }
}

