/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.imagej.widget.HistogramBundle;
import net.imagej.widget.HistogramWidget;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingHistogramWidget
extends SwingInputWidget<HistogramBundle>
implements HistogramWidget<JPanel> {
    private HistogramBundle bundle;
    private ChartPanel chartPanel;

    public HistogramBundle getValue() {
        return this.bundle;
    }

    public void set(WidgetModel model) {
        super.set(model);
        this.bundle = (HistogramBundle)model.getValue();
        this.chartPanel = this.makeChartPanel(this.bundle);
        this.bundle.setHasChanges(false);
        this.getComponent().add((Component)this.chartPanel);
    }

    public boolean supports(WidgetModel model) {
        return model.isType(HistogramBundle.class);
    }

    private ChartPanel makeChartPanel(HistogramBundle b) {
        JFreeChart chart = this.getChart(null, b);
        ChartPanel panel = new ChartPanel(chart);
        int xSize = b.getPreferredSizeX();
        int ySize = b.getPreferredSizeY();
        panel.setPreferredSize(new Dimension(xSize, ySize));
        return panel;
    }

    private JFreeChart getChart(String title, HistogramBundle bund) {
        ArrayList<XYSeries> series = new ArrayList<XYSeries>();
        for (int h = 0; h < bund.getHistogramCount(); ++h) {
            XYSeries xys = new XYSeries((Comparable)((Object)("histo" + h)));
            long total = bund.getHistogram(h).getBinCount();
            for (long i = 0L; i < total; ++i) {
                xys.add((double)i, (double)bund.getHistogram(h).frequency(i));
            }
            series.add(xys);
        }
        JFreeChart chart = this.createChart(title, series);
        if (bund.getMinBin() != -1L) {
            chart.getXYPlot().addDomainMarker((Marker)new ValueMarker((double)bund.getMinBin(), (Paint)Color.black, (Stroke)new BasicStroke(1.0f)));
        }
        if (bund.getMaxBin() != -1L) {
            chart.getXYPlot().addDomainMarker((Marker)new ValueMarker((double)bund.getMaxBin(), (Paint)Color.black, (Stroke)new BasicStroke(1.0f)));
        }
        if (this.displaySlopeLine(bund)) {
            chart.getXYPlot().addAnnotation(this.slopeLine());
        }
        return chart;
    }

    private JFreeChart createChart(String title, List<XYSeries> series) {
        XYSeriesCollection data = new XYSeriesCollection();
        for (XYSeries xys : series) {
            data.addSeries(xys);
        }
        JFreeChart chart = ChartFactory.createXYBarChart((String)title, null, (boolean)false, null, (IntervalXYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.setTheme(chart);
        return chart;
    }

    private final void setTheme(JFreeChart chart) {
        XYPlot plot = (XYPlot)chart.getPlot();
        XYBarRenderer r = (XYBarRenderer)plot.getRenderer();
        StandardXYBarPainter bp = new StandardXYBarPainter();
        r.setBarPainter((XYBarPainter)bp);
        r.setSeriesOutlinePaint(0, (Paint)Color.lightGray);
        r.setShadowVisible(false);
        r.setDrawBarOutline(false);
        this.setBackgroundDefault(chart);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setTickLabelsVisible(false);
        rangeAxis.setTickMarksVisible(false);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setTickLabelsVisible(false);
        domainAxis.setTickMarksVisible(false);
    }

    private final void setBackgroundDefault(JFreeChart chart) {
        BasicStroke gridStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 1.0f}, 0.0f);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setRangeGridlineStroke((Stroke)gridStroke);
        plot.setDomainGridlineStroke((Stroke)gridStroke);
        plot.setBackgroundPaint((Paint)new Color(235, 235, 235));
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setOutlineVisible(false);
        plot.getDomainAxis().setAxisLineVisible(false);
        plot.getRangeAxis().setAxisLineVisible(false);
        plot.getDomainAxis().setLabelPaint((Paint)Color.gray);
        plot.getRangeAxis().setLabelPaint((Paint)Color.gray);
        plot.getDomainAxis().setTickLabelPaint((Paint)Color.gray);
        plot.getRangeAxis().setTickLabelPaint((Paint)Color.gray);
        TextTitle title = chart.getTitle();
        if (title != null) {
            title.setPaint((Paint)Color.black);
        }
    }

    private boolean displaySlopeLine(HistogramBundle bund) {
        if (Double.isNaN(bund.getDataMin())) {
            return false;
        }
        if (Double.isNaN(bund.getDataMax())) {
            return false;
        }
        if (Double.isNaN(bund.getTheoreticalMin())) {
            return false;
        }
        return !Double.isNaN(bund.getTheoreticalMax());
    }

    private XYAnnotation slopeLine() {
        return new XYAnnotation(){
            private double x1;
            private double y1;
            private double x2;
            private double y2;

            public void removeChangeListener(AnnotationChangeListener listener) {
            }

            public void addChangeListener(AnnotationChangeListener listener) {
            }

            public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
                this.calcLineCoords(dataArea);
                this.drawLine(g2);
            }

            private void drawLine(Graphics2D g2) {
                Color origColor = g2.getColor();
                g2.setColor(Color.black);
                g2.drawLine((int)this.x1, (int)this.y1, (int)this.x2, (int)this.y2);
                g2.setColor(origColor);
            }

            private void calcLineCoords(Rectangle2D rect) {
                double x = rect.getMinX();
                double y = rect.getMinY();
                double w = rect.getWidth();
                double h = rect.getHeight();
                double min = SwingHistogramWidget.this.bundle.getTheoreticalMin();
                double max = SwingHistogramWidget.this.bundle.getTheoreticalMax();
                double defaultMin = SwingHistogramWidget.this.bundle.getDataMin();
                double defaultMax = SwingHistogramWidget.this.bundle.getDataMax();
                double scale = w / (defaultMax - defaultMin);
                double slope = 0.0;
                if (max != min) {
                    slope = h / (max - min);
                }
                if (min >= defaultMin) {
                    this.x1 = scale * (min - defaultMin);
                    this.y1 = h;
                } else {
                    this.x1 = 0.0;
                    this.y1 = max > min ? h - (defaultMin - min) * slope : h;
                }
                if (max <= defaultMax) {
                    this.x2 = scale * (max - defaultMin);
                    this.y2 = 0.0;
                } else {
                    this.x2 = w;
                    this.y2 = max > min ? h - (defaultMax - min) * slope : 0.0;
                }
                this.x1 += x;
                this.x2 += x;
                this.y1 += y;
                this.y2 += y;
            }
        };
    }

    public void doRefresh() {
        if (this.bundle.hasChanges()) {
            this.bundle.setHasChanges(false);
            ChartPanel newChartPanel = this.makeChartPanel(this.bundle);
            JFreeChart chart = newChartPanel.getChart();
            this.chartPanel.setChart(chart);
        }
    }
}

