/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.labeling;

import gnu.trove.map.hash.TLongLongHashMap;
import java.util.Arrays;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongBiFunction;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.algorithm.util.unionfind.IntArrayRankedUnionFind;
import net.imglib2.algorithm.util.unionfind.UnionFind;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import net.imglib2.view.composite.RealComposite;

public class ConnectedComponentAnalysis {
    public static <T> ToLongBiFunction<Localizable, T> idFromIntervalIndexer(Interval interval) {
        return new IdFromIntervalIndexerWithInterval(interval);
    }

    public static <B extends BooleanType<B>, L extends IntegerType<L>> void connectedComponents(RandomAccessibleInterval<B> mask, RandomAccessibleInterval<L> labeling) {
        ConnectedComponentAnalysis.connectedComponents(mask, labeling, new DiamondShape(1L));
    }

    public static <B extends BooleanType<B>, L extends IntegerType<L>> void connectedComponents(RandomAccessibleInterval<B> mask, RandomAccessibleInterval<L> labeling, Shape shape) {
        assert (Intervals.numElements(labeling) < Integer.MAX_VALUE) : "Cannot Image Using array union find.";
        ConnectedComponentAnalysis.connectedComponents(mask, labeling, shape, n -> new IntArrayRankedUnionFind((int)n), ConnectedComponentAnalysis.idFromIntervalIndexer(labeling), new StartAtOneIdForNextSet());
    }

    public static <B extends BooleanType<B>, L extends IntegerType<L>> void connectedComponents(RandomAccessibleInterval<B> mask, RandomAccessibleInterval<L> labeling, Shape shape, LongFunction<UnionFind> unionFindFactory, ToLongBiFunction<Localizable, L> idForPixel, LongUnaryOperator idForSet) {
        assert (Intervals.contains(mask, labeling) && Intervals.contains(labeling, mask)) : "Mask and labeling are not the same size.";
        assert (Intervals.numElements(labeling) <= Integer.MAX_VALUE) : "Too many pixels for integer based union find.";
        UnionFind uf = ConnectedComponentAnalysis.makeUnion(mask, labeling, shape, unionFindFactory, idForPixel);
        UnionFind.relabel(mask, labeling, uf, idForPixel, idForSet);
    }

    private static <B extends BooleanType<B>, L extends IntegerType<L>> UnionFind makeUnion(RandomAccessibleInterval<B> mask, RandomAccessibleInterval<L> labeling, Shape shape, LongFunction<UnionFind> unionFindFactory, ToLongBiFunction<Localizable, L> idForPixel) {
        UnionFind uf = unionFindFactory.apply(Intervals.numElements(labeling));
        if (shape instanceof DiamondShape && ((DiamondShape)shape).getRadius() == 1L) {
            ConnectedComponentAnalysis.connectedComponentsDiamondShape(mask, labeling, uf, idForPixel);
        } else {
            ConnectedComponentAnalysis.connectedComponentsGeneralShape(mask, labeling, shape, uf, idForPixel);
        }
        return uf;
    }

    private static <B extends BooleanType<B>, L extends IntegerType<L>> void connectedComponentsDiamondShape(RandomAccessible<B> mask, RandomAccessibleInterval<L> labeling, UnionFind uf, ToLongBiFunction<Localizable, L> id) {
        int nDim = labeling.numDimensions();
        long[] min = Intervals.minAsLongArray(labeling);
        long[] max = Intervals.maxAsLongArray(labeling);
        for (int d = 0; d < nDim; ++d) {
            long[] minPlusOne = (long[])min.clone();
            long[] maxMinusOne = (long[])max.clone();
            int n = d;
            minPlusOne[n] = minPlusOne[n] + 1L;
            int n2 = d;
            maxMinusOne[n2] = maxMinusOne[n2] - 1L;
            RealCursor lower = Views.interval(mask, new FinalInterval(min, maxMinusOne)).cursor();
            RealCursor upper = Views.interval(mask, new FinalInterval(minPlusOne, max)).cursor();
            RealCursor lowerL = Views.interval(labeling, new FinalInterval(min, maxMinusOne)).localizingCursor();
            RealCursor upperL = Views.interval(labeling, new FinalInterval(minPlusOne, max)).localizingCursor();
            while (lower.hasNext()) {
                long r2;
                long r1;
                boolean l = ((BooleanType)lower.next()).get();
                boolean u = ((BooleanType)upper.next()).get();
                lowerL.fwd();
                upperL.fwd();
                if (!l || !u || (r1 = uf.findRoot(id.applyAsLong((Localizable)((Object)lowerL), lowerL.get()))) == (r2 = uf.findRoot(id.applyAsLong((Localizable)((Object)upperL), upperL.get())))) continue;
                uf.join(r1, r2);
            }
        }
    }

    private static <B extends BooleanType<B>, L extends IntegerType<L>> void connectedComponentsGeneralShape(RandomAccessibleInterval<B> mask, RandomAccessibleInterval<L> labeling, Shape shape, UnionFind uf, ToLongBiFunction<Localizable, L> id) {
        RandomAccessible maskNeighborhood = shape.neighborhoodsRandomAccessible(Views.extendZero(mask));
        RandomAccessible labelingNeighborhood = shape.neighborhoodsRandomAccessible(Views.extendZero(labeling));
        RealCursor mnhCursor = Views.flatIterable(Views.interval(maskNeighborhood, labeling)).cursor();
        RealCursor lnhCursor = Views.flatIterable(Views.interval(labelingNeighborhood, labeling)).cursor();
        RealCursor maskCursor = Views.flatIterable(mask).cursor();
        RealCursor labelCursor = Views.flatIterable(labeling).localizingCursor();
        while (maskCursor.hasNext()) {
            BooleanType center = (BooleanType)maskCursor.next();
            IntegerType label = (IntegerType)labelCursor.next();
            Neighborhood mnh = (Neighborhood)mnhCursor.next();
            Neighborhood lnh = (Neighborhood)lnhCursor.next();
            if (!center.get()) continue;
            long index = id.applyAsLong((Localizable)((Object)labelCursor), label);
            RealCursor lnhc = lnh.localizingCursor();
            RealCursor mnhc = mnh.cursor();
            while (mnhc.hasNext()) {
                long r2;
                long r1;
                IntegerType l = (IntegerType)lnhc.next();
                BooleanType m = (BooleanType)mnhc.next();
                if (!m.get() || (r1 = uf.findRoot(index)) == (r2 = uf.findRoot(id.applyAsLong((Localizable)((Object)lnhc), l)))) continue;
                uf.join(r1, r2);
            }
        }
    }

    public static <B extends BooleanType<B>, C extends RealComposite<B>, L extends IntegerType<L>> void connectedComponentsOnAffinities(RandomAccessible<C> affinities, long[][] affinityOffsets, RandomAccessibleInterval<L> labeling, UnionFind uf, ToLongBiFunction<Localizable, L> id, LongUnaryOperator idForSet) {
        ExtendedRandomAccessibleInterval extendedLabeling = Views.extendValue(labeling, ((IntegerType)Util.getTypeFromInterval(labeling)).createVariable());
        Cursor[] offsetLabelingCursors = new Cursor[affinityOffsets.length];
        Arrays.setAll(offsetLabelingCursors, i -> Views.flatIterable(Views.interval(Views.offset(extendedLabeling, affinityOffsets[i]), labeling)).cursor());
        RealCursor target = Views.flatIterable(labeling).cursor();
        RealCursor affinitiesCursor = Views.flatIterable(Views.interval(affinities, labeling)).cursor();
        while (target.hasNext()) {
            RealComposite affinitiesVector = (RealComposite)affinitiesCursor.next();
            IntegerType targetLabel = (IntegerType)target.next();
            long labelId = uf.findRoot(id.applyAsLong((Localizable)((Object)target), targetLabel));
            targetLabel.setInteger(labelId);
            for (int i2 = 0; i2 < affinityOffsets.length; ++i2) {
                long otherLabelId;
                offsetLabelingCursors[i2].fwd();
                if (!((BooleanType)affinitiesVector.get(i2)).get() || labelId == (otherLabelId = uf.findRoot(id.applyAsLong(offsetLabelingCursors[i2], offsetLabelingCursors[i2].get())))) continue;
                uf.join(labelId, otherLabelId);
            }
        }
        uf.relabel(labeling, id, idForSet);
    }

    public static <B extends BooleanType<B>, C extends RealComposite<B>, L extends IntegerType<L>> void connectedComponentsOnAffinities(RandomAccessible<C> affinities, long[][] affinityOffsets, RandomAccessibleInterval<L> labeling, UnionFind uf, long firstIndex) {
        ExtendedRandomAccessibleInterval extendedLabeling = Views.extendValue(labeling, ((IntegerType)Util.getTypeFromInterval(labeling)).createVariable());
        long index = firstIndex;
        for (IntegerType label : Views.flatIterable(labeling)) {
            label.setInteger(index);
            ++index;
        }
        Cursor[] offsetLabelingCursors = new Cursor[affinityOffsets.length];
        Arrays.setAll(offsetLabelingCursors, i -> Views.flatIterable(Views.interval(Views.offset(extendedLabeling, affinityOffsets[i]), labeling)).cursor());
        RealCursor target = Views.flatIterable(labeling).cursor();
        RealCursor affinitiesCursor = Views.flatIterable(Views.interval(affinities, labeling)).cursor();
        while (target.hasNext()) {
            RealComposite affinitiesVector = (RealComposite)affinitiesCursor.next();
            IntegerType targetLabel = (IntegerType)target.next();
            long labelId = uf.findRoot(targetLabel.getIntegerLong());
            for (int i2 = 0; i2 < affinityOffsets.length; ++i2) {
                long otherLabelId;
                offsetLabelingCursors[i2].fwd();
                if (!((BooleanType)affinitiesVector.get(i2)).get() || labelId == (otherLabelId = uf.findRoot(((IntegerType)offsetLabelingCursors[i2].get()).getIntegerLong()))) continue;
                uf.join(labelId, otherLabelId);
                if (i2 + 1 >= affinityOffsets.length) continue;
                labelId = uf.findRoot(targetLabel.getIntegerLong());
            }
        }
        uf.relabel(labeling);
    }

    private static final class IdFromIntervalIndexerWithInterval<T>
    implements ToLongBiFunction<Localizable, T> {
        private final Interval interval;

        private IdFromIntervalIndexerWithInterval(Interval interval) {
            this.interval = interval;
        }

        @Override
        public long applyAsLong(Localizable l, T t) {
            return IntervalIndexer.positionToIndexForInterval(l, this.interval);
        }
    }

    private static class StartAtOneIdForNextSet
    implements LongUnaryOperator {
        private final TLongLongHashMap setMappings = new TLongLongHashMap();

        private StartAtOneIdForNextSet() {
        }

        @Override
        public long applyAsLong(long root) {
            if (!this.setMappings.containsKey(root)) {
                this.setMappings.put(root, (long)(this.setMappings.size() + 1));
            }
            return this.setMappings.get(root);
        }
    }
}

