/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.inputimage;

import java.util.Arrays;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Cast;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.inputimage.ImgPlusViewsOld;
import sc.fiji.labkit.ui.inputimage.InputImage;

public class DatasetInputImage
implements InputImage {
    private final ImgPlus<? extends NumericType<?>> image;
    private final BdvShowable showable;
    private String defaultLabelingFilename;

    public DatasetInputImage(ImgPlus<? extends NumericType<?>> image, BdvShowable showable) {
        this.showable = showable;
        this.image = DatasetInputImage.prepareImage(image);
        this.defaultLabelingFilename = image.getSource() + ".labeling";
    }

    public DatasetInputImage(Img<?> image) {
        this(ImgPlus.wrap(image));
    }

    private static ImgPlus<? extends NumericType<?>> prepareImage(ImgPlus<? extends NumericType<?>> image) {
        List<AxisType> order = Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.CHANNEL, Axes.TIME);
        return ImgPlusViewsOld.sortAxes(DatasetInputImage.labelAxes(image), order);
    }

    private static ImgPlus<? extends NumericType<?>> labelAxes(ImgPlus<? extends NumericType<?>> image) {
        if (image.firstElement() instanceof ARGBType) {
            return ImgPlusViewsOld.fixAxes(image, Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.TIME));
        }
        if (image.numDimensions() == 4) {
            return ImgPlusViewsOld.fixAxes(image, Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.TIME, Axes.CHANNEL));
        }
        return ImgPlusViewsOld.fixAxes(image, Arrays.asList(Axes.X, Axes.Y, Axes.Z, Axes.CHANNEL, Axes.TIME));
    }

    public DatasetInputImage(ImgPlus<?> image) {
        this((ImgPlus)Cast.unchecked(image), DatasetInputImage.initializeShowable((ImgPlus)Cast.unchecked(image)));
    }

    public static BdvShowable initializeShowable(ImgPlus<? extends NumericType<?>> image) {
        return BdvShowable.wrap(DatasetInputImage.prepareImage(image));
    }

    public DatasetInputImage(Dataset image) {
        this(image.getImgPlus());
    }

    @Override
    public BdvShowable showable() {
        return this.showable;
    }

    @Override
    public ImgPlus<? extends NumericType<?>> imageForSegmentation() {
        return this.image;
    }

    public void setDefaultLabelingFilename(String defaultLabelingFilename) {
        this.defaultLabelingFilename = defaultLabelingFilename;
    }

    @Override
    public String getDefaultLabelingFilename() {
        return this.defaultLabelingFilename;
    }
}

