/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.imagej.ImgPlus;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.ConstantUtils;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.ExtensionPoints;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.segmentation.SegmentationUtils;
import sc.fiji.labkit.ui.segmentation.Segmenter;
import sc.fiji.labkit.ui.utils.Notifier;

public class SegmentationResultsModel {
    private final ExtensionPoints extensionPoints;
    private final ImageLabelingModel model;
    private final Segmenter segmenter;
    private boolean hasResults = false;
    private RandomAccessibleInterval<UnsignedByteType> segmentation;
    private RandomAccessibleInterval<FloatType> prediction;
    private List<String> labels = Collections.emptyList();
    private List<ARGBType> colors = Collections.emptyList();
    private final Notifier listeners = new Notifier();

    public SegmentationResultsModel(ImageLabelingModel model, ExtensionPoints extensionPoints, Segmenter segmenter) {
        this.model = model;
        this.extensionPoints = extensionPoints;
        this.segmenter = segmenter;
        this.segmentation = this.dummy(new UnsignedByteType());
        this.prediction = this.dummy(new FloatType());
        model.imageForSegmentation().notifier().addListener(this::update);
        this.update();
    }

    public ImageLabelingModel imageLabelingModel() {
        return this.model;
    }

    public void update() {
        if (this.segmenter.isTrained()) {
            this.updateSegmentation(this.segmenter);
            this.updatePrediction(this.segmenter);
            this.labels = this.segmenter.classNames();
            this.colors = this.labels.stream().map(this::getLabelColor).collect(Collectors.toList());
            this.hasResults = true;
            this.listeners.notifyListeners();
        }
    }

    private ARGBType getLabelColor(String name) {
        Labeling labeling = this.model.labeling().get();
        try {
            return labeling.getLabel(name).color();
        }
        catch (NoSuchElementException e) {
            Label label = labeling.addLabel(name);
            this.model.labeling().notifier().notifyListeners();
            return label.color();
        }
    }

    public void clear() {
        this.segmentation = this.dummy(new UnsignedByteType());
        this.prediction = this.dummy(new FloatType());
        this.hasResults = false;
        this.listeners.notifyListeners();
    }

    public RandomAccessibleInterval<UnsignedByteType> segmentation() {
        return this.segmentation;
    }

    private <T> RandomAccessibleInterval<T> dummy(T value) {
        FinalInterval interval = new FinalInterval((Interval)this.model.imageForSegmentation().get());
        return ConstantUtils.constantRandomAccessibleInterval(value, (Interval)interval);
    }

    public RandomAccessibleInterval<FloatType> prediction() {
        return this.prediction;
    }

    private void updatePrediction(Segmenter segmenter) {
        ImgPlus<?> image = this.model.imageForSegmentation().get();
        this.prediction = SegmentationUtils.createCachedProbabilityMap(segmenter, image, this.extensionPoints.getCachedPredictionImageFactory());
    }

    private void updateSegmentation(Segmenter segmenter) {
        ImgPlus<?> image = this.model.imageForSegmentation().get();
        this.segmentation = SegmentationUtils.createCachedSegmentation(segmenter, image, this.extensionPoints.getCachedSegmentationImageFactory());
    }

    public List<String> labels() {
        return this.labels;
    }

    public Interval interval() {
        return new FinalInterval(Intervals.dimensionsAsLongArray((Dimensions)((Dimensions)this.model.imageForSegmentation().get())));
    }

    public List<ARGBType> colors() {
        return this.colors;
    }

    public Notifier segmentationChangedListeners() {
        return this.listeners;
    }

    public boolean hasResults() {
        return this.hasResults;
    }
}

