/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.vector;

import ini.trakem2.vector.VectorString;
import ini.trakem2.vector.VectorString3D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Editions {
    public static final int DELETION = 1;
    public static final int INSERTION = 2;
    public static final int MUTATION = 3;
    protected final double WI;
    protected final double WD;
    protected final double WM;
    protected VectorString vs1;
    protected VectorString vs2;
    protected double delta;
    protected boolean closed;
    protected int[][] editions;
    public double distance;

    public Editions(VectorString vs1, VectorString vs2, double delta, boolean closed) {
        this(vs1, vs2, delta, closed, 1.0, 1.0, 1.0);
    }

    public Editions(VectorString vs1, VectorString vs2, double delta, boolean closed, double wi, double wd, double wm) {
        this.vs1 = vs1;
        this.vs2 = vs2;
        this.delta = delta;
        this.closed = closed;
        this.WI = wi;
        this.WD = wd;
        this.WM = wm;
        this.init();
    }

    public double getDistance() {
        return this.distance;
    }

    public int length() {
        return this.editions.length;
    }

    public int[][] getEditions() {
        return this.editions;
    }

    public VectorString getVS1() {
        return this.vs1;
    }

    public VectorString getVS2() {
        return this.vs2;
    }

    public double getSimilarity(boolean skip_ends, int max_mut, float min_chunk) {
        return this.getSimilarity(this.getStartEndSkip(skip_ends, max_mut, min_chunk));
    }

    private double getSimilarity(int[] g) {
        int i_start = g[0];
        int i_end = g[1];
        boolean skip_ends = 1 == g[2];
        int non_mut = 0;
        if (skip_ends) {
            for (int i = i_start; i <= i_end; ++i) {
                if (3 == this.editions[i][0]) continue;
                ++non_mut;
            }
            double sim = 1.0 - (double)non_mut / (double)Math.max(this.editions[i_end][1] - this.editions[i_start][1] + 1, this.editions[i_end][2] - this.editions[i_start][2] + 1);
            return sim;
        }
        for (int i = 0; i < this.editions.length; ++i) {
            if (3 == this.editions[i][0]) continue;
            ++non_mut;
        }
        return 1.0 - (double)non_mut / (double)Math.max(this.vs1.length(), this.vs2.length());
    }

    public double getSimilarity() {
        return this.getSimilarity(false, 0, 1.0f);
    }

    public double getSimilarity2() {
        return this.getSimilarity2(false, 0, 1.0f);
    }

    public double getSimilarity2(boolean skip_ends, int max_mut, float min_chunk) {
        int[] g = this.getStartEndSkip(skip_ends, max_mut, min_chunk);
        int i_start = g[0];
        int i_end = g[1];
        skip_ends = 1 == g[2];
        int mut = 0;
        if (skip_ends) {
            for (int i = i_start; i < i_end; ++i) {
                if (3 != this.editions[i][0]) continue;
                ++mut;
            }
            double sim = (double)mut / (double)Math.max(this.editions[i_end][1] - this.editions[i_start][1] + 1, this.editions[i_end][2] - this.editions[i_start][2] + 1);
            return sim;
        }
        for (int i = 0; i < this.editions.length; ++i) {
            if (3 != this.editions[i][0]) continue;
            ++mut;
        }
        return (double)mut / (double)Math.max(this.vs1.length(), this.vs2.length());
    }

    private final int[] getStartEndSkip(boolean skip_ends, int max_mut, float min_chunk) {
        int i_start = 0;
        int i_end = this.editions.length - 1;
        if (skip_ends) {
            int i;
            int len_mut_seq = 0;
            for (i = 0; i < this.editions.length; ++i) {
                len_mut_seq = 3 == this.editions[i][0] ? ++len_mut_seq : 0;
                if (len_mut_seq <= max_mut) continue;
                i_start = i - len_mut_seq + 1;
                break;
            }
            len_mut_seq = 0;
            for (i = i_end; i > -1; --i) {
                len_mut_seq = 3 == this.editions[i][0] ? ++len_mut_seq : 0;
                if (len_mut_seq <= max_mut) continue;
                i_end = i;
                break;
            }
            skip_ends = (float)(this.editions[i_end][1] - this.editions[i_start][1] + 1) / (float)this.vs1.length() >= min_chunk;
        }
        return new int[]{i_start, i_end, skip_ends ? 1 : 0};
    }

    public double getPhysicalDistance(boolean skip_ends, int max_mut, float min_chunk, boolean average) {
        return this.getPhysicalDistance(this.getStartEndSkip(skip_ends, max_mut, min_chunk), average);
    }

    private double getPhysicalDistance(int[] g, boolean average) {
        int i_start = g[0];
        int i_end = g[1];
        double dist = 0.0;
        int len = 0;
        int i = 0;
        int len1 = this.vs1.length();
        int len2 = this.vs2.length();
        try {
            for (i = i_start; i <= i_end; ++i) {
                if (3 != this.editions[i][0]) continue;
                int k1 = this.editions[i][1];
                int k2 = this.editions[i][2];
                if (len1 == k1 || len2 == k2) continue;
                dist += this.vs1.distance(k1, this.vs2, k2);
                ++len;
            }
            if (0 == len) {
                return Double.MAX_VALUE;
            }
            if (average) {
                return dist / (double)len;
            }
            return dist;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR in getPhysicalDistance: i,len  j,len : " + this.editions[i][1] + ", " + this.vs1.length() + "    " + this.editions[i][2] + ", " + this.vs2.length());
            return Double.MAX_VALUE;
        }
    }

    public double getStdDev(boolean skip_ends, int max_mut, float min_chunk) {
        return this.getStdDev(this.getStartEndSkip(skip_ends, max_mut, min_chunk));
    }

    private double getStdDev(int[] g) {
        int i_start = g[0];
        int i_end = g[1];
        double dist = 0.0;
        int i = 0;
        int len1 = this.vs1.length();
        int len2 = this.vs2.length();
        ArrayList<Double> mut = new ArrayList<Double>();
        try {
            for (i = i_start; i <= i_end; ++i) {
                if (3 != this.editions[i][0]) continue;
                int k1 = this.editions[i][1];
                int k2 = this.editions[i][2];
                if (len1 == k1 || len2 == k2) continue;
                double d = this.vs1.distance(k1, this.vs2, k2);
                dist += d;
                mut.add(d);
            }
            if (0 == mut.size()) {
                return Double.MAX_VALUE;
            }
            Double[] di = new Double[mut.size()];
            mut.toArray(di);
            double average = dist / (double)di.length;
            double std = 0.0;
            for (int k = 0; k < di.length; ++k) {
                std += Math.pow(di[k] - average, 2.0);
            }
            return Math.sqrt(std / (double)di.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR in getPhysicalDistance: i,len  j,len : " + this.editions[i][1] + ", " + this.vs1.length() + "    " + this.editions[i][2] + ", " + this.vs2.length());
            return Double.MAX_VALUE;
        }
    }

    public double[] getStatistics(boolean skip_ends, int max_mut, float min_chunk, boolean score_mut_only) {
        return this.getStatistics(this.getStartEndSkip(skip_ends, max_mut, min_chunk), score_mut_only);
    }

    private double[] getStatistics(int[] g, boolean score_mut_only) {
        int i_start = g[0];
        int i_end = g[1];
        int i = 0;
        int len1 = this.vs1.length();
        int len2 = this.vs2.length();
        ArrayList<Double> dist = new ArrayList<Double>();
        double[] pack = new double[11];
        Arrays.fill(pack, Double.MAX_VALUE);
        pack[4] = 0.0;
        int n_mutation = 0;
        double c_dist = 0.0;
        double c_dist_mut = 0.0;
        try {
            for (i = i_start; i <= i_end; ++i) {
                if (3 == this.editions[i][0]) {
                    ++n_mutation;
                } else if (score_mut_only) continue;
                int k1 = this.editions[i][1];
                int k2 = this.editions[i][2];
                if (len1 == k1 || len2 == k2) continue;
                double d = this.vs1.distance(k1, this.vs2, k2);
                c_dist += d;
                if (3 == this.editions[i][0]) {
                    c_dist_mut += d;
                }
                dist.add(d);
            }
            if (0 == dist.size()) {
                return pack;
            }
            Double[] di = new Double[dist.size()];
            dist.toArray(di);
            double average = c_dist / (double)di.length;
            double std = 0.0;
            for (int k = 0; k < di.length; ++k) {
                std += Math.pow(di[k] - average, 2.0);
            }
            std = Math.sqrt(std / (double)di.length);
            Collections.sort(dist);
            double median = (Double)dist.get(di.length / 2);
            double prop_mut = (double)n_mutation / (double)(i_end - i_start);
            double phys_len = (double)Math.max(this.editions[i_end][1] - this.editions[i_start][1] + 1, this.editions[i_end][2] - this.editions[i_start][2] + 1) * this.vs1.getDelta();
            pack[0] = average;
            pack[1] = c_dist;
            pack[2] = std;
            pack[3] = median;
            pack[4] = prop_mut;
            pack[5] = this.distance;
            pack[6] = this.getSimilarity(g);
            pack[7] = c_dist / phys_len;
            pack[8] = score_mut_only ? pack[7] : c_dist_mut / phys_len;
            pack[9] = (double)this.vs1.length() / (double)this.vs2.length();
            if (this.vs1 instanceof VectorString3D) {
                pack[10] = Math.pow(VectorString3D.distance((VectorString3D)this.vs1, 0, (VectorString3D)this.vs1, this.vs1.length() - 1) / ((double)this.vs1.length() * this.vs1.getDelta()) - VectorString3D.distance((VectorString3D)this.vs2, 0, (VectorString3D)this.vs2, this.vs2.length() - 1) / ((double)this.vs2.length() * this.vs2.getDelta()), 2.0);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR in getStatistics: i,len  j,len : " + this.editions[i][1] + ", " + this.vs1.length() + "    " + this.editions[i][2] + ", " + this.vs2.length());
            e.printStackTrace();
        }
        return pack;
    }

    private final void init() {
        int k;
        boolean with_source = this.vs1 instanceof VectorString3D && this.vs2 instanceof VectorString3D ? null != ((VectorString3D)this.vs1).getSource() && null != ((VectorString3D)this.vs2).getSource() : false;
        this.vs1.resample(this.delta, with_source);
        this.vs2.resample(this.delta, with_source);
        double[][] matrix = this.findMinimumEditDistance();
        int n = this.vs1.length();
        int m = this.vs2.length();
        this.distance = matrix[n][m];
        int initial_length = (int)Math.sqrt(n * n + m * m);
        int i = 0;
        int ed_length = initial_length;
        this.editions = new int[ed_length][3];
        int next = 0;
        i = n;
        int j = m;
        double error = 1.0E-7;
        while (0 != i && 0 != j) {
            if (next == ed_length) {
                this.editions = Editions.resizeAndFillEditionsCopy(this.editions, ed_length, ed_length + 20);
                ed_length += 20;
            }
            if (1.0E-7 > Math.abs(matrix[i][j] - matrix[i - 1][j] - this.delta)) {
                this.editions[next][0] = 1;
                this.editions[next][1] = i--;
                this.editions[next][2] = j;
            } else if (1.0E-7 > Math.abs(matrix[i][j] - matrix[i][j - 1] - this.delta)) {
                this.editions[next][0] = 2;
                this.editions[next][1] = i;
                this.editions[next][2] = j--;
            } else {
                this.editions[next][0] = 3;
                this.editions[next][1] = i--;
                this.editions[next][2] = j--;
            }
            ++next;
        }
        if (0 != j) {
            k = j;
            while (k > -1) {
                if (next == ed_length) {
                    this.editions = Editions.resizeAndFillEditionsCopy(this.editions, ed_length, ed_length + 20);
                    ed_length += 20;
                }
                this.editions[next][0] = 2;
                this.editions[next][1] = 0;
                this.editions[next][2] = k--;
                ++next;
            }
        }
        if (0 != i) {
            k = i;
            while (k > -1) {
                if (next == ed_length) {
                    this.editions = Editions.resizeAndFillEditionsCopy(this.editions, ed_length, ed_length + 20);
                    ed_length += 20;
                }
                this.editions[next][0] = 1;
                this.editions[next][1] = k--;
                this.editions[next][2] = 0;
                ++next;
            }
        }
        if (next != ed_length) {
            int[][] editions2 = new int[next][3];
            i = 0;
            j = next - 1;
            while (i < next) {
                editions2[i][0] = this.editions[j][0];
                editions2[i][1] = this.editions[j][1];
                editions2[i][2] = this.editions[j][2];
                ++i;
                --j;
            }
            this.editions = editions2;
        } else {
            for (i = 0; i < next; ++i) {
                int[] temp = this.editions[i];
                this.editions[i] = this.editions[next - 1 - i];
                this.editions[next - 1 - i] = temp;
            }
        }
    }

    private static final int[][] resizeAndFillEditionsCopy(int[][] editions, int ed_length, int new_length) {
        if (new_length <= ed_length) {
            return editions;
        }
        int[][] editions2 = new int[new_length][3];
        for (int k = 0; k < ed_length; ++k) {
            editions2[k][0] = editions[k][0];
            editions2[k][1] = editions[k][1];
            editions2[k][2] = editions[k][2];
        }
        return editions2;
    }

    private double[][] findMinimumEditDistance() {
        int j;
        int i;
        int min_j = 0;
        int n = this.vs1.length();
        int m = this.vs2.length();
        double[][] matrix1 = new double[n + 1][m + 1];
        for (i = 0; i < n + 1; ++i) {
            matrix1[i][0] = (double)i * this.delta * this.WD;
        }
        for (j = 0; j < m + 1; ++j) {
            matrix1[0][j] = (double)j * this.delta * this.WI;
        }
        if (!this.closed) {
            return this.findEditMatrix(0, matrix1);
        }
        double[][] matrix2 = new double[n + 1][m + 1];
        for (i = 0; i < n + 1; ++i) {
            matrix2[i][0] = (double)i * this.delta;
        }
        for (j = 0; j < m + 1; ++j) {
            matrix2[0][j] = (double)j * this.delta;
        }
        double[][] matrix_e = matrix1;
        double[][] matrix = null;
        MinDist min_data = new MinDist();
        min_data.min_j = -1;
        min_data.min_dist = Double.MAX_VALUE;
        min_data.matrix = matrix2;
        min_data.matrix_e = matrix1;
        min_data = this.findMinDist(0, m - 1, (int)Math.ceil((double)m * 0.1), min_data);
        min_j = min_data.min_j;
        matrix = min_data.matrix;
        matrix_e = min_data.matrix_e;
        if (matrix != matrix_e) {
            matrix_e = null;
        } else {
            System.out.println("\nERROR: matrix is matrix_e unexpectedly");
        }
        if (0 != min_j) {
            this.vs2.reorder(min_j);
        }
        return matrix;
    }

    private MinDist findMinDist(int first, int last, int interval_length, MinDist result) {
        double[][] matrix_e;
        double[][] matrix = result.matrix;
        double[][] matrix1 = matrix_e = result.matrix_e;
        double[][] matrix2 = matrix;
        int k = 0;
        int length = last < first ? this.vs2.length() - first + last : last - first + 1;
        int n = this.vs1.length();
        int m = this.vs2.length();
        int min_j = result.min_j;
        double min_dist = result.min_dist;
        while (k < length) {
            int j = first + k;
            if (j >= m) {
                j -= m;
            }
            if ((matrix_e = j == result.min_j ? result.matrix_e : this.findEditMatrix(j, matrix_e))[n][m] < min_dist) {
                min_j = j;
                matrix = matrix_e;
                min_dist = matrix[n][m];
                matrix_e = matrix_e == matrix1 ? matrix2 : matrix1;
            }
            if (length - 1 != k && k + interval_length >= length) {
                k = length - 1;
                continue;
            }
            k += interval_length;
        }
        result.min_j = min_j;
        result.min_dist = min_dist;
        result.matrix = matrix;
        result.matrix_e = matrix_e;
        if (1 == interval_length) {
            return result;
        }
        first = min_j - (interval_length - 1);
        last = min_j + (interval_length - 1);
        if (first < 0) {
            first = m + first;
        }
        if (last >= m) {
            last -= m;
        }
        interval_length = (int)Math.ceil((float)interval_length / 2.0f);
        return this.findMinDist(first, last, interval_length, result);
    }

    private double[][] findEditMatrix(int first, double[][] matrix_) {
        int i;
        int n = this.vs1.length();
        int m = this.vs2.length();
        if (null == matrix_) {
            matrix_ = new double[n + 1][m + 1];
        }
        double[][] matrix = matrix_;
        int j = 0;
        for (i = 0; i < n + 1; ++i) {
            matrix[i][0] = (double)i * this.delta;
        }
        while (j < m + 1) {
            matrix[0][j] = (double)j * this.delta;
            ++j;
        }
        for (i = 1; i < n + 1; ++i) {
            double[] mati = matrix[i];
            double[] mat1 = matrix[i - 1];
            for (j = 1; j < m + 1; ++j) {
                double fun1 = mat1[j] + this.WD * this.delta;
                double fun2 = mati[j - 1] + this.WI * this.delta;
                double fun3 = i == n || j == m ? mat1[j - 1] : mat1[j - 1] + this.WM * this.vs1.getDiffVectorLength(i, j, this.vs2);
                mati[j] = fun3 <= fun1 && fun3 <= fun2 ? fun3 : (fun1 <= fun2 && fun1 <= fun3 ? fun1 : fun2);
            }
        }
        return matrix;
    }

    public String prettyPrint(String separator) {
        if (null == this.editions) {
            return null;
        }
        if (null == separator) {
            separator = "\t";
        }
        StringBuffer s1 = new StringBuffer(this.editions.length * 2 + 5);
        StringBuffer se = new StringBuffer(this.editions.length * 2 + 5);
        StringBuffer s2 = new StringBuffer(this.editions.length * 2 + 5);
        s1.append("vs1:");
        se.append("    ");
        s2.append("vs2:");
        block5: for (int i = 0; i < this.editions.length; ++i) {
            switch (this.editions[i][0]) {
                case 3: {
                    s1.append(separator).append(this.editions[i][1] + 1);
                    se.append(separator).append('M');
                    s2.append(separator).append(this.editions[i][2] + 1);
                    continue block5;
                }
                case 1: {
                    s1.append(separator).append(this.editions[i][1] + 1);
                    se.append(separator).append('D');
                    s2.append(separator).append(' ');
                    continue block5;
                }
                case 2: {
                    s1.append(separator).append(' ');
                    se.append(separator).append('I');
                    s2.append(separator).append(this.editions[i][2] + 1);
                }
            }
        }
        s1.append('\n');
        se.append('\n');
        s2.append('\n');
        return s1.append(se).append(s2).toString();
    }

    public Chunk findLargestMutationChunk(int max_non_mut) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        Chunk cur = new Chunk(0, 0);
        boolean reached_mut = false;
        int non_mut = 0;
        for (int i = 0; i < this.editions.length; ++i) {
            if (3 == this.editions[i][0]) {
                cur.i_end = i;
                if (reached_mut) continue;
                reached_mut = true;
                continue;
            }
            if (!reached_mut) {
                cur.i_start = i;
            } else {
                ++non_mut;
            }
            if (non_mut <= max_non_mut && this.editions.length - 1 != i) continue;
            cur.i_end = i;
            if (0 != chunks.size()) {
                Chunk[] c = new Chunk[chunks.size()];
                chunks.toArray(c);
                boolean add = false;
                int len = cur.length();
                for (int k = c.length - 1; k > -1; --k) {
                    int n = c[k].length();
                    if (len > n) {
                        chunks.remove(c[k]);
                    }
                    if (add || len < n) continue;
                    add = true;
                }
                if (add) {
                    chunks.add(cur);
                }
            } else {
                chunks.add(cur);
            }
            cur = new Chunk(i, i);
            reached_mut = false;
            non_mut = 0;
        }
        if (0 == chunks.size()) {
            System.out.println("No chunks found.");
            return null;
        }
        Chunk chunk = null;
        if (1 == chunks.size()) {
            chunk = (Chunk)chunks.get(0);
        } else {
            double[] dist = new double[chunks.size()];
            int next = 0;
            HashMap<Chunk, Double> ht = new HashMap<Chunk, Double>();
            for (Chunk chunk2 : chunks) {
                dist[next] = this.getPhysicalDistance(new int[]{chunk2.i_start, chunk2.i_end, max_non_mut}, false);
                ht.put(chunk2, dist[next]);
                ++next;
            }
            Arrays.sort(dist);
            for (Map.Entry entry : ht.entrySet()) {
                if ((Double)entry.getValue() != dist[0]) continue;
                chunk = (Chunk)entry.getKey();
                break;
            }
        }
        return chunk;
    }

    public Editions recreateFromCenter(int max_non_mut) throws Exception {
        int i;
        Chunk chunk = this.findLargestMutationChunk(max_non_mut);
        int midpoint = (chunk.i_start + chunk.i_end) / 2;
        if (0 == midpoint) {
            return null;
        }
        VectorString3D firsthalf1 = (VectorString3D)this.vs1.subVectorString(this.editions[midpoint][1], 0);
        VectorString3D firsthalf2 = (VectorString3D)this.vs2.subVectorString(this.editions[midpoint][2], 0);
        Editions ed = new Editions(firsthalf1, firsthalf2, this.delta, this.closed);
        int[][] mushup = new int[ed.editions.length + this.editions.length - midpoint][3];
        for (i = 0; i <= midpoint; ++i) {
            mushup[midpoint - i] = ed.editions[i];
        }
        for (i = midpoint + 1; i < this.editions.length; ++i) {
            mushup[i] = this.editions[i];
        }
        ed.vs1 = this.vs1;
        ed.vs2 = this.vs2;
        ed.distance = this.distance;
        ed.editions = mushup;
        return ed;
    }

    public static class Chunk {
        int i_start;
        int i_end;

        Chunk(int i_start, int i_end) {
            this.i_start = i_start;
            this.i_end = i_end;
        }

        int length() {
            return this.i_end - this.i_start + 1;
        }
    }

    private class MinDist {
        int min_j;
        double min_dist;
        double[][] matrix;
        double[][] matrix_e;

        private MinDist() {
        }
    }
}

