/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.cache;

import bdv.img.cache.EmptyArrayCreator;
import net.imglib2.img.basictypeaccess.volatiles.VolatileArrayDataAccess;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileCharArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileShortArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileCharArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.type.PrimitiveType;

public class DefaultEmptyArrayCreator<A extends VolatileArrayDataAccess<A>>
implements EmptyArrayCreator<A> {
    public static final int INITIAL_EMPTY_SIZE = 32768;
    private final A creator;
    private EmptyArray<A> theEmptyArray;
    private static DefaultEmptyArrayCreator<DirtyVolatileByteArray> dirtyBytes;
    private static DefaultEmptyArrayCreator<VolatileByteArray> bytes;
    private static DefaultEmptyArrayCreator<DirtyVolatileCharArray> dirtyChars;
    private static DefaultEmptyArrayCreator<VolatileCharArray> chars;
    private static DefaultEmptyArrayCreator<DirtyVolatileDoubleArray> dirtyDoubles;
    private static DefaultEmptyArrayCreator<VolatileDoubleArray> doubles;
    private static DefaultEmptyArrayCreator<DirtyVolatileFloatArray> dirtyFloats;
    private static DefaultEmptyArrayCreator<VolatileFloatArray> floats;
    private static DefaultEmptyArrayCreator<DirtyVolatileIntArray> dirtyInts;
    private static DefaultEmptyArrayCreator<VolatileIntArray> ints;
    private static DefaultEmptyArrayCreator<DirtyVolatileLongArray> dirtyLongs;
    private static DefaultEmptyArrayCreator<VolatileLongArray> longs;
    private static DefaultEmptyArrayCreator<DirtyVolatileShortArray> dirtyShorts;
    private static DefaultEmptyArrayCreator<VolatileShortArray> shorts;

    public DefaultEmptyArrayCreator(A creator) {
        this.creator = creator;
        this.theEmptyArray = new EmptyArray<A>(32768, creator);
    }

    @Override
    public A getEmptyArray(long numEntities) {
        EmptyArray<A> empty = this.theEmptyArray;
        if ((long)empty.numEntities < numEntities) {
            this.theEmptyArray = empty = new EmptyArray<A>((int)numEntities, this.creator);
        }
        return empty.data;
    }

    public static <A extends VolatileArrayDataAccess<A>> DefaultEmptyArrayCreator<A> get(PrimitiveType primitiveType, boolean dirty) {
        switch (primitiveType) {
            case BYTE: {
                if (dirty) {
                    if (dirtyBytes == null) {
                        dirtyBytes = new DefaultEmptyArrayCreator<DirtyVolatileByteArray>(new DirtyVolatileByteArray(0, false));
                    }
                    return dirtyBytes;
                }
                if (bytes == null) {
                    bytes = new DefaultEmptyArrayCreator<VolatileByteArray>(new VolatileByteArray(0, false));
                }
                return bytes;
            }
            case CHAR: {
                if (dirty) {
                    if (dirtyChars == null) {
                        dirtyChars = new DefaultEmptyArrayCreator<DirtyVolatileCharArray>(new DirtyVolatileCharArray(0, false));
                    }
                    return dirtyChars;
                }
                if (chars == null) {
                    chars = new DefaultEmptyArrayCreator<VolatileCharArray>(new VolatileCharArray(0, false));
                }
                return chars;
            }
            case DOUBLE: {
                if (dirty) {
                    if (dirtyDoubles == null) {
                        dirtyDoubles = new DefaultEmptyArrayCreator<DirtyVolatileDoubleArray>(new DirtyVolatileDoubleArray(0, false));
                    }
                    return dirtyDoubles;
                }
                if (doubles == null) {
                    doubles = new DefaultEmptyArrayCreator<VolatileDoubleArray>(new VolatileDoubleArray(0, false));
                }
                return doubles;
            }
            case FLOAT: {
                if (dirty) {
                    if (dirtyFloats == null) {
                        dirtyFloats = new DefaultEmptyArrayCreator<DirtyVolatileFloatArray>(new DirtyVolatileFloatArray(0, false));
                    }
                    return dirtyFloats;
                }
                if (floats == null) {
                    floats = new DefaultEmptyArrayCreator<VolatileFloatArray>(new VolatileFloatArray(0, false));
                }
                return floats;
            }
            case INT: {
                if (dirty) {
                    if (dirtyInts == null) {
                        dirtyInts = new DefaultEmptyArrayCreator<DirtyVolatileIntArray>(new DirtyVolatileIntArray(0, false));
                    }
                    return dirtyInts;
                }
                if (ints == null) {
                    ints = new DefaultEmptyArrayCreator<VolatileIntArray>(new VolatileIntArray(0, false));
                }
                return ints;
            }
            case LONG: {
                if (dirty) {
                    if (dirtyLongs == null) {
                        dirtyLongs = new DefaultEmptyArrayCreator<DirtyVolatileLongArray>(new DirtyVolatileLongArray(0, false));
                    }
                    return dirtyLongs;
                }
                if (longs == null) {
                    longs = new DefaultEmptyArrayCreator<VolatileLongArray>(new VolatileLongArray(0, false));
                }
                return longs;
            }
            case SHORT: {
                if (dirty) {
                    if (dirtyShorts == null) {
                        dirtyShorts = new DefaultEmptyArrayCreator<DirtyVolatileShortArray>(new DirtyVolatileShortArray(0, false));
                    }
                    return dirtyShorts;
                }
                if (shorts == null) {
                    shorts = new DefaultEmptyArrayCreator<VolatileShortArray>(new VolatileShortArray(0, false));
                }
                return shorts;
            }
        }
        return null;
    }

    static class EmptyArray<A extends VolatileArrayDataAccess<A>> {
        A data;
        int numEntities;

        EmptyArray(int numEntities, A creator) {
            this.data = (VolatileArrayDataAccess)creator.createArray(numEntities, false);
            this.numEntities = numEntities;
        }
    }
}

