/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.KeyConfigScopes;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.DisplayMode;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class NavigationActions
extends Actions {
    public static final String TOGGLE_INTERPOLATION = "toggle interpolation";
    public static final String TOGGLE_FUSED_MODE = "toggle fused mode";
    public static final String TOGGLE_GROUPING = "toggle grouping";
    public static final String SET_CURRENT_SOURCE = "set current source %d";
    public static final String TOGGLE_SOURCE_VISIBILITY = "toggle source visibility %d";
    public static final String ALIGN_XY_PLANE = "align XY plane";
    public static final String ALIGN_ZY_PLANE = "align ZY plane";
    public static final String ALIGN_XZ_PLANE = "align XZ plane";
    public static final String NEXT_TIMEPOINT = "next timepoint";
    public static final String PREVIOUS_TIMEPOINT = "previous timepoint";
    public static final String[] TOGGLE_INTERPOLATION_KEYS = new String[]{"I"};
    public static final String[] TOGGLE_FUSED_MODE_KEYS = new String[]{"F"};
    public static final String[] TOGGLE_GROUPING_KEYS = new String[]{"G"};
    public static final String SET_CURRENT_SOURCE_KEYS_FORMAT = "%s";
    public static final String TOGGLE_SOURCE_VISIBILITY_KEYS_FORMAT = "shift %s";
    public static final String[] ALIGN_XY_PLANE_KEYS = new String[]{"shift Z"};
    public static final String[] ALIGN_ZY_PLANE_KEYS = new String[]{"shift X"};
    public static final String[] ALIGN_XZ_PLANE_KEYS = new String[]{"shift Y", "shift A"};
    public static final String[] NEXT_TIMEPOINT_KEYS = new String[]{"CLOSE_BRACKET", "M"};
    public static final String[] PREVIOUS_TIMEPOINT_KEYS = new String[]{"OPEN_BRACKET", "N"};
    @Deprecated
    public static final String ALIGN_PLANE = "align %s plane";

    public static void install(Actions actions, AbstractViewerPanel viewer, boolean is2D) {
        NavigationActions.installModeActions(actions, viewer.state());
        NavigationActions.installSourceActions(actions, viewer.state());
        NavigationActions.installTimeActions(actions, viewer.state());
        NavigationActions.installAlignPlaneActions(actions, viewer, is2D);
    }

    public static void installModeActions(Actions actions, ViewerState state) {
        actions.runnableAction(() -> NavigationActions.toggleInterpolation(state), TOGGLE_INTERPOLATION, TOGGLE_INTERPOLATION_KEYS);
        actions.runnableAction(() -> NavigationActions.toggleFusedMode(state), TOGGLE_FUSED_MODE, TOGGLE_FUSED_MODE_KEYS);
        actions.runnableAction(() -> NavigationActions.toggleGroupingMode(state), TOGGLE_GROUPING, TOGGLE_GROUPING_KEYS);
    }

    public static void installTimeActions(Actions actions, ViewerState state) {
        actions.runnableAction(() -> NavigationActions.nextTimePoint(state), NEXT_TIMEPOINT, NEXT_TIMEPOINT_KEYS);
        actions.runnableAction(() -> NavigationActions.previousTimePoint(state), PREVIOUS_TIMEPOINT, PREVIOUS_TIMEPOINT_KEYS);
    }

    public static void installSourceActions(Actions actions, ViewerState state) {
        String[] numkeys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        IntStream.range(0, numkeys.length).forEach(i -> {
            actions.runnableAction(() -> NavigationActions.setCurrentGroupOrSource(state, i), String.format(SET_CURRENT_SOURCE, i), new String[]{String.format(SET_CURRENT_SOURCE_KEYS_FORMAT, numkeys[i])});
            actions.runnableAction(() -> NavigationActions.toggleGroupOrSourceActive(state, i), String.format(TOGGLE_SOURCE_VISIBILITY, i), new String[]{String.format(TOGGLE_SOURCE_VISIBILITY_KEYS_FORMAT, numkeys[i])});
        });
    }

    public static void installAlignPlaneActions(Actions actions, AbstractViewerPanel viewer, boolean is2D) {
        actions.runnableAction(() -> viewer.align(AbstractViewerPanel.AlignPlane.XY), ALIGN_XY_PLANE, ALIGN_XY_PLANE_KEYS);
        if (!is2D) {
            actions.runnableAction(() -> viewer.align(AbstractViewerPanel.AlignPlane.ZY), ALIGN_ZY_PLANE, ALIGN_ZY_PLANE_KEYS);
            actions.runnableAction(() -> viewer.align(AbstractViewerPanel.AlignPlane.XZ), ALIGN_XZ_PLANE, ALIGN_XZ_PLANE_KEYS);
        }
    }

    @Deprecated
    public static void installAlignPlaneAction(Actions actions, AbstractViewerPanel viewer, AbstractViewerPanel.AlignPlane plane, String ... defaultKeyStrokes) {
        switch (plane) {
            case XY: {
                actions.runnableAction(() -> viewer.align(AbstractViewerPanel.AlignPlane.XY), ALIGN_XY_PLANE, defaultKeyStrokes);
                break;
            }
            case ZY: {
                actions.runnableAction(() -> viewer.align(AbstractViewerPanel.AlignPlane.ZY), ALIGN_ZY_PLANE, defaultKeyStrokes);
                break;
            }
            case XZ: {
                actions.runnableAction(() -> viewer.align(AbstractViewerPanel.AlignPlane.XZ), ALIGN_XZ_PLANE, defaultKeyStrokes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toggleInterpolation(ViewerState state) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            state.setInterpolation(state.getInterpolation().next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextTimePoint(ViewerState state) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            int t = state.getCurrentTimepoint() + 1;
            if (t < state.getNumTimepoints()) {
                state.setCurrentTimepoint(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void previousTimePoint(ViewerState state) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            int t = state.getCurrentTimepoint() - 1;
            if (t >= 0) {
                state.setCurrentTimepoint(t);
            }
        }
    }

    private static void toggleFusedMode(ViewerState state) {
        DisplayMode mode;
        state.setDisplayMode(mode.withFused(!(mode = state.getDisplayMode()).hasFused()));
    }

    private static void toggleGroupingMode(ViewerState state) {
        DisplayMode mode;
        state.setDisplayMode(mode.withGrouping(!(mode = state.getDisplayMode()).hasGrouping()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCurrentGroupOrSource(ViewerState state, int index) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            if (state.getDisplayMode().hasGrouping()) {
                List<SourceGroup> groups = state.getGroups();
                if (index >= 0 && index < groups.size()) {
                    SourceGroup group = groups.get(index);
                    state.setCurrentGroup(group);
                    ArrayList sources = new ArrayList(state.getSourcesInGroup(group));
                    if (!sources.isEmpty()) {
                        sources.sort(state.sourceOrder());
                        state.setCurrentSource((SourceAndConverter)sources.get(0));
                    }
                }
            } else {
                List<SourceAndConverter<?>> sources = state.getSources();
                if (index >= 0 && index < sources.size()) {
                    state.setCurrentSource(sources.get(index));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toggleGroupOrSourceActive(ViewerState state, int index) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            if (state.getDisplayMode().hasGrouping()) {
                List<SourceGroup> groups = state.getGroups();
                if (index >= 0 && index < groups.size()) {
                    SourceGroup group;
                    state.setGroupActive(group, !state.isGroupActive(group = groups.get(index)));
                }
            } else {
                List<SourceAndConverter<?>> sources = state.getSources();
                if (index >= 0 && index < sources.size()) {
                    SourceAndConverter<?> source;
                    state.setSourceActive(source, !state.isSourceActive(source = sources.get(index)));
                }
            }
        }
    }

    @Deprecated
    public static void installActionBindings(InputActionBindings inputActionBindings, ViewerPanel viewer, KeyStrokeAdder.Factory keyProperties) {
        NavigationActions actions = new NavigationActions(keyProperties);
        actions.modes(viewer);
        actions.sources(viewer);
        actions.time(viewer);
        actions.alignPlanes(viewer);
        actions.install(inputActionBindings, "navigation");
    }

    @Deprecated
    public NavigationActions(KeyStrokeAdder.Factory keyConfig) {
        super(keyConfig, new String[]{"bdv", "navigation"});
    }

    @Deprecated
    public void alignPlaneAction(ViewerPanel viewer, AbstractViewerPanel.AlignPlane plane, String ... defaultKeyStrokes) {
        NavigationActions.installAlignPlaneAction(this, viewer, plane, defaultKeyStrokes);
    }

    @Deprecated
    public void modes(ViewerPanel viewer) {
        NavigationActions.installModeActions(this, viewer.state());
    }

    @Deprecated
    public void time(ViewerPanel viewer) {
        NavigationActions.installTimeActions(this, viewer.state());
    }

    @Deprecated
    public void sources(ViewerPanel viewer) {
        NavigationActions.installSourceActions(this, viewer.state());
    }

    @Deprecated
    public void alignPlanes(ViewerPanel viewer) {
        NavigationActions.installAlignPlaneActions(this, viewer, false);
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(KeyConfigScopes.BIGDATAVIEWER, new String[]{"bdv"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(NavigationActions.TOGGLE_INTERPOLATION, TOGGLE_INTERPOLATION_KEYS, "Switch between nearest-neighbor and n-linear interpolation mode in BigDataViewer.");
            descriptions.add(NavigationActions.TOGGLE_FUSED_MODE, TOGGLE_FUSED_MODE_KEYS, "TODO");
            descriptions.add(NavigationActions.TOGGLE_GROUPING, TOGGLE_GROUPING_KEYS, "TODO");
            String[] numkeys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
            IntStream.range(0, numkeys.length).forEach(i -> {
                descriptions.add(String.format(NavigationActions.SET_CURRENT_SOURCE, i), new String[]{String.format(NavigationActions.SET_CURRENT_SOURCE_KEYS_FORMAT, numkeys[i])}, "TODO");
                descriptions.add(String.format(NavigationActions.TOGGLE_SOURCE_VISIBILITY, i), new String[]{String.format(NavigationActions.TOGGLE_SOURCE_VISIBILITY_KEYS_FORMAT, numkeys[i])}, "TODO");
            });
            descriptions.add(NavigationActions.NEXT_TIMEPOINT, NEXT_TIMEPOINT_KEYS, "TODO");
            descriptions.add(NavigationActions.PREVIOUS_TIMEPOINT, PREVIOUS_TIMEPOINT_KEYS, "TODO");
            descriptions.add(NavigationActions.ALIGN_XY_PLANE, ALIGN_XY_PLANE_KEYS, "TODO");
            descriptions.add(NavigationActions.ALIGN_ZY_PLANE, ALIGN_ZY_PLANE_KEYS, "TODO");
            descriptions.add(NavigationActions.ALIGN_XZ_PLANE, ALIGN_XZ_PLANE_KEYS, "TODO");
        }
    }
}

