/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.OverlayRenderer;
import bdv.viewer.render.MultiResolutionRenderer;
import bdv.viewer.render.Tile;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.List;

public class DebugTilingOverlay
implements OverlayRenderer {
    private volatile Tiles tiling;
    private volatile boolean showTiles = true;
    private volatile long renderTime;
    private volatile double renderTimePerPixelAndSourceAverage;

    public DebugTilingOverlay(MultiResolutionRenderer renderer) {
        renderer.debugTileOverlay = this;
    }

    @Override
    public void drawOverlays(Graphics g) {
        Tiles tiling = this.tiling;
        if (tiling != null) {
            List<Tile> tiles = tiling.tiles;
            if (this.showTiles) {
                double s = 1.0 / tiling.scale;
                int offsetX = tiling.offsetX;
                int offsetY = tiling.offsetY;
                if (tiles != null) {
                    g.setColor(Color.GREEN);
                    g.setFont(new Font("Monospaced", 0, 12));
                    int i = 0;
                    for (Tile tile : tiles) {
                        int x0 = (int)((double)(offsetX + tile.tileMinX()) * s);
                        int y0 = (int)((double)(offsetY + tile.tileMinY()) * s);
                        int x1 = (int)((double)(offsetX + tile.tileMaxX() + 1) * s);
                        int y1 = (int)((double)(offsetY + tile.tileMaxY() + 1) * s);
                        g.drawLine(x0, y0, x1, y0);
                        g.drawLine(x1, y0, x1, y1);
                        g.drawLine(x1, y1, x0, y1);
                        g.drawLine(x0, y1, x0, y0);
                        g.drawString(String.format("%d, %d", i++, tile.sources().size()), x0 + 5, y0 + 17);
                    }
                }
            }
            int maxSourcesPerTile = 0;
            if (tiles != null) {
                for (Tile tile : tiles) {
                    maxSourcesPerTile = Math.max(maxSourcesPerTile, tile.sources().size());
                }
            }
            g.setColor(Color.WHITE);
            g.setFont(new Font("Monospaced", 1, 14));
            g.drawString(String.format("%d tiles", tiles.size()), (int)g.getClipBounds().getWidth() - 180, (int)g.getClipBounds().getHeight() - 80);
            g.drawString(String.format("%d max sources per tile", maxSourcesPerTile), (int)g.getClipBounds().getWidth() - 180, (int)g.getClipBounds().getHeight() - 60);
            g.drawString(String.format("%.1f ms", (double)this.renderTime / 1000000.0), (int)g.getClipBounds().getWidth() - 180, (int)g.getClipBounds().getHeight() - 40);
            g.drawString(String.format("%.1f ns", this.renderTimePerPixelAndSourceAverage), (int)g.getClipBounds().getWidth() - 180, (int)g.getClipBounds().getHeight() - 20);
        }
    }

    public void setTiling(List<Tile> tiles, double scale, int offsetX, int offsetY) {
        this.tiling = new Tiles(tiles, scale, offsetX, offsetY);
    }

    public boolean getShowTiles() {
        return this.showTiles;
    }

    public void setShowTiles(boolean showTiles) {
        this.showTiles = showTiles;
    }

    public void setRenderTime(long rendertime) {
        this.renderTime = rendertime;
    }

    public void setRenderTimePerPixelAndSource(double renderTimePerPixelAndSourceAverage) {
        this.renderTimePerPixelAndSourceAverage = renderTimePerPixelAndSourceAverage;
    }

    public static class Tiles {
        final List<Tile> tiles;
        final double scale;
        final int offsetX;
        final int offsetY;

        public Tiles(List<Tile> tiles, double scale, int offsetX, int offsetY) {
            this.tiles = tiles;
            this.scale = scale;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }
}

