/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import java.awt.Color;
import java.util.ArrayList;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.java3d.utils.geometry.StripifierStats;
import org.jogamp.vecmath.Color3b;

public class Stripifier {
    final boolean DEBUG = false;
    final boolean CHECK_ORIENT = false;
    static final int EMPTY = -1;
    boolean hasNormals = false;
    boolean hasTextures = false;
    int texSetCount = 0;
    boolean hasColors = false;
    boolean colorStrips = false;
    StripifierStats stats;
    int[] numNhbrs;
    public static final int COLLECT_STATS = 1;

    public Stripifier() {
    }

    public Stripifier(int flags) {
        if ((flags & 1) != 0) {
            this.stats = new StripifierStats();
        }
    }

    public void stripify(GeometryInfo gi) {
        long time = System.currentTimeMillis();
        gi.convertToIndexedTriangles();
        gi.forgetOldPrim();
        Face[] faces = this.createFaceArray(gi);
        Edge[] edges = this.createEdgeArray(faces);
        this.buildAdjacencies(edges, faces);
        Node[] faceNodes = new Node[faces.length];
        Node[] queue = this.dfSearch(faces, faceNodes);
        int[] ns = new int[1];
        int[] np = new int[1];
        ArrayList hamiltons = this.hamilton(queue, ns, np);
        int numStrips = ns[0];
        int numPatches = np[0];
        ArrayList strips = this.stripe(hamiltons);
        this.concatenate(strips, faces);
        this.putBackData(gi, strips);
        if (this.stats != null) {
            this.stats.updateInfo(System.currentTimeMillis() - time, strips, faces.length);
        }
    }

    public StripifierStats getStripifierStats() {
        if (this.stats == null) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Stripifier0"));
        }
        return this.stats;
    }

    Face[] createFaceArray(GeometryInfo gi) {
        int[] vertices = gi.getCoordinateIndices();
        int[] normals = gi.getNormalIndices();
        Object textures = null;
        int[] t1 = null;
        int[] t2 = null;
        int[] t3 = null;
        this.texSetCount = gi.getTexCoordSetCount();
        if (this.texSetCount > 0) {
            this.hasTextures = true;
            textures = new int[this.texSetCount][];
            for (int i = 0; i < this.texSetCount; ++i) {
                textures[i] = gi.getTextureCoordinateIndices(i);
            }
            t1 = new int[this.texSetCount];
            t2 = new int[this.texSetCount];
            t3 = new int[this.texSetCount];
        } else {
            this.hasTextures = false;
        }
        int[] colors = gi.getColorIndices();
        Face[] faces = new Face[vertices.length / 3];
        int count = 0;
        for (int i = 0; i < vertices.length; i += 3) {
            int c3;
            int c2;
            int c1;
            int n3;
            int n2;
            int n1;
            if (normals != null) {
                this.hasNormals = true;
                n1 = normals[i];
                n2 = normals[i + 1];
                n3 = normals[i + 2];
            } else {
                this.hasNormals = false;
                n1 = -1;
                n2 = -1;
                n3 = -1;
            }
            if (this.hasTextures) {
                for (int j = 0; j < this.texSetCount; ++j) {
                    t1[j] = textures[j][i];
                    t2[j] = textures[j][i + 1];
                    t3[j] = textures[j][i + 2];
                }
            }
            if (colors != null) {
                this.hasColors = true;
                c1 = colors[i];
                c2 = colors[i + 1];
                c3 = colors[i + 2];
            } else {
                this.hasColors = false;
                c1 = -1;
                c2 = -1;
                c3 = -1;
            }
            Vertex v1 = new Vertex(vertices[i], n1, this.texSetCount, t1, c1);
            Vertex v2 = new Vertex(vertices[i + 1], n2, this.texSetCount, t2, c2);
            Vertex v3 = new Vertex(vertices[i + 2], n3, this.texSetCount, t3, c3);
            if (v1.equals(v2) || v2.equals(v3) || v3.equals(v1)) continue;
            faces[count] = new Face(count, v1, v2, v3);
            ++count;
        }
        if (faces.length > count) {
            Face[] temp = faces;
            faces = new Face[count];
            System.arraycopy(temp, 0, faces, 0, count);
        }
        return faces;
    }

    Edge[] createEdgeArray(Face[] faces) {
        Edge[] edges = new Edge[faces.length * 3];
        for (int i = 0; i < faces.length; ++i) {
            Face face = faces[i];
            edges[i * 3] = new Edge(face.verts[0], face.verts[1], face.key);
            edges[i * 3 + 1] = new Edge(face.verts[1], face.verts[2], face.key);
            edges[i * 3 + 2] = new Edge(face.verts[2], face.verts[0], face.key);
        }
        return edges;
    }

    void buildAdjacencies(Edge[] edges, Face[] faces) {
        int j2;
        int j1;
        boolean flag;
        Face face;
        Edge edge;
        int i;
        this.quickSortEdges(edges, 0, edges.length - 1);
        for (i = 0; i < edges.length; ++i) {
            edge = edges[i];
            face = faces[edge.face];
            Vertex[] verts = face.verts;
            flag = true;
            if (!verts[0].equals(edge.v1) && !verts[0].equals(edge.v2)) {
                face.edges[0] = edge;
                --face.numNhbrs;
                flag = false;
            } else if (!verts[1].equals(edge.v1) && !verts[1].equals(edge.v2)) {
                face.edges[1] = edge;
                --face.numNhbrs;
                flag = false;
            } else if (!verts[2].equals(edge.v1) && !verts[2].equals(edge.v2)) {
                face.edges[2] = edge;
                --face.numNhbrs;
                flag = false;
            }
            if (!flag) continue;
            if (edge.v1.equals(edge.v2)) {
                face.edges[--face.numNhbrs] = edge;
                continue;
            }
            Vertex i1 = verts[0].equals(verts[1]) ? verts[1] : verts[2];
            if (verts[0].equals(i1) && face.edges[0] == null) {
                face.edges[0] = edge;
                --face.numNhbrs;
                continue;
            }
            if (verts[1].equals(i1) && face.edges[1] == null) {
                face.edges[1] = edge;
                --face.numNhbrs;
                continue;
            }
            face.edges[2] = edge;
            --face.numNhbrs;
        }
        i = 0;
        int j = 0;
        while (i < edges.length - 1) {
            j = i + 1;
            if (edges[i].equals(edges[j])) {
                j1 = edges[i].face;
                j2 = edges[j].face;
                if (j1 != j2) {
                    face = faces[j1];
                    edge = edges[i];
                    int k = face.getEdgeIndex(edge);
                    flag = !edge.v1.equals(face.verts[(k + 1) % 3]) || !edge.v2.equals(face.verts[(k + 2) % 3]);
                    face = faces[j2];
                    edge = edges[j];
                    k = face.getEdgeIndex(edge);
                    if (!edge.v1.equals(face.verts[(k + 1) % 3]) || !edge.v2.equals(face.verts[(k + 2) % 3])) {
                        boolean bl = flag = !flag;
                    }
                    if (flag) {
                        edges[i].face = j2;
                        edges[j].face = j1;
                        ++faces[j1].numNhbrs;
                        ++faces[j2].numNhbrs;
                    } else {
                        edges[i].face = -1;
                    }
                } else {
                    edges[i].face = -1;
                }
            } else {
                edges[i].face = -1;
            }
            i = ++j;
        }
        if (i <= edges.length - 1) {
            edges[i].face = -1;
        }
        for (i = 0; i < faces.length; ++i) {
            face = faces[i];
            if (face.numNhbrs != 3) continue;
            j1 = face.edges[1].face;
            if (j1 == face.edges[0].face) {
                face.edges[1].face = -1;
                --face.numNhbrs;
                faces[j1].counterEdgeDel(face.edges[1]);
            }
            if ((j2 = face.edges[2].face) == face.edges[0].face) {
                face.edges[2].face = -1;
                --face.numNhbrs;
                faces[j2].counterEdgeDel(face.edges[2]);
            }
            if (face.edges[1].face == -1 || j1 != j2) continue;
            face.edges[2].face = -1;
            --face.numNhbrs;
            faces[j1].counterEdgeDel(face.edges[2]);
        }
    }

    void sortEdges(Edge[] edges) {
        boolean sorted = false;
        Edge temp = null;
        for (int i = edges.length; i > 1 && !sorted; --i) {
            sorted = true;
            for (int j = 1; j < i; ++j) {
                if (!edges[j].lessThan(edges[j - 1])) continue;
                temp = edges[j - 1];
                edges[j - 1] = edges[j];
                edges[j] = temp;
                sorted = false;
            }
        }
    }

    void quickSortEdges(Edge[] edges, int l, int r) {
        if (edges.length > 0) {
            int i = l;
            int j = r;
            Edge k = edges[(l + r) / 2];
            while (true) {
                if (edges[i].lessThan(k)) {
                    ++i;
                    continue;
                }
                while (k.lessThan(edges[j])) {
                    --j;
                }
                if (i <= j) {
                    Edge tmp = edges[i];
                    edges[i] = edges[j];
                    edges[j] = tmp;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                this.quickSortEdges(edges, l, j);
            }
            if (l < r) {
                this.quickSortEdges(edges, i, r);
            }
        }
    }

    Node[] hybridSearch(Face[] faces, Node[] faceNodes) {
        int numFaces = faces.length;
        int i = 0;
        int j = 0;
        int k = 0;
        int ind = 0;
        int[] count = new int[]{0, 0, 0, 0};
        int[] index = new int[numFaces];
        int[] rindex = new int[numFaces];
        boolean popFlag = false;
        Node[] queue = new Node[numFaces];
        int start = 0;
        for (i = 0; i < numFaces; ++i) {
            int n = j = faces[i].numNhbrs;
            count[n] = count[n] + 1;
            faceNodes[i] = new Node(faces[i]);
        }
        for (i = 1; i < 4; ++i) {
            int n = i;
            count[n] = count[n] + count[i - 1];
        }
        for (i = numFaces - 1; i >= 0; --i) {
            int n = j = faces[i].numNhbrs;
            count[n] = count[n] - 1;
            index[count[j]] = i;
            rindex[i] = count[j];
        }
        for (i = 0; i < numFaces; ++i) {
            if (index[i] == -1) continue;
            SortedList dlist = new SortedList();
            Node source = faceNodes[index[i]];
            source.setRoot();
            queue[ind] = source;
            ++ind;
            index[i] = -1;
            while (source != null) {
                Node nnode = null;
                Face face = source.face;
                for (j = 0; j < 3; ++j) {
                    k = face.getNeighbor(j);
                    if (k == -1 || !faceNodes[k].notAccessed()) continue;
                    nnode = faceNodes[k];
                    break;
                }
                if (nnode != null) {
                    nnode.insert(source);
                    if (!popFlag) {
                        start = dlist.sortedInsert(source, start);
                    } else {
                        popFlag = false;
                    }
                    queue[ind] = source = nnode;
                    ++ind;
                    index[rindex[k]] = -1;
                    continue;
                }
                source.processed();
                source = dlist.pop();
                popFlag = true;
                start = 0;
            }
        }
        return queue;
    }

    Node[] dfSearch(Face[] faces, Node[] faceNodes) {
        int numFaces = faces.length;
        int i = 0;
        int j = 0;
        int k = 0;
        int ind = 0;
        int[] count = new int[]{0, 0, 0, 0};
        int[] index = new int[numFaces];
        int[] rindex = new int[numFaces];
        Node[] queue = new Node[numFaces];
        for (i = 0; i < numFaces; ++i) {
            int n = j = faces[i].numNhbrs;
            count[n] = count[n] + 1;
            faceNodes[i] = new Node(faces[i]);
        }
        for (i = 1; i < 4; ++i) {
            int n = i;
            count[n] = count[n] + count[i - 1];
        }
        for (i = numFaces - 1; i >= 0; --i) {
            int n = j = faces[i].numNhbrs;
            count[n] = count[n] - 1;
            index[count[j]] = i;
            rindex[i] = count[j];
        }
        this.setNumNhbrs(faces);
        for (i = 0; i < numFaces; ++i) {
            if (index[i] == -1) continue;
            Node source = faceNodes[index[i]];
            source.setRoot();
            queue[ind] = source;
            ++ind;
            index[i] = -1;
            Node node = source;
            while (node != source || node.right == null) {
                Node nnode = null;
                Face face = node.face;
                k = this.findNext(node, faceNodes, faces);
                if (k != -1) {
                    nnode = faceNodes[k];
                }
                if (nnode != null) {
                    this.updateNumNhbrs(nnode);
                }
                if (nnode != null) {
                    nnode.insert(node);
                    queue[ind] = node = nnode;
                    ++ind;
                    index[rindex[k]] = -1;
                } else {
                    node.processed();
                    node = node.parent;
                }
                if (node != source.parent) continue;
            }
        }
        this.freeNhbrTable();
        return queue;
    }

    int findNext(Node node, Node[] faceNodes, Face[] faces) {
        int j;
        int i;
        Face face = node.face;
        if (face.numNhbrs == 0) {
            return -1;
        }
        int[] n = new int[3];
        int[] ind = new int[]{-1, -1, -1};
        int count = 0;
        for (i = 0; i < 3; ++i) {
            j = face.getNeighbor(i);
            if (j == -1 || !faceNodes[j].notAccessed()) continue;
            ind[count] = j;
            n[count] = this.numNhbrs[j];
            ++count;
        }
        if (count == 0) {
            return -1;
        }
        if (count == 1) {
            return ind[0];
        }
        if (count == 2) {
            if (n[0] == n[1] && n[0] != 0) {
                n[0] = this.resetNhbr(ind[0], faces, faceNodes);
                n[1] = this.resetNhbr(ind[1], faces, faceNodes);
            }
            if (n[0] < n[1]) {
                return ind[0];
            }
            if (n[1] < n[0]) {
                return ind[1];
            }
            Node pnode = node.parent;
            if (pnode != null) {
                Face pface = pnode.face;
                i = pface.findSharedEdge(face.key);
                Node ppnode = pnode.parent;
                if (ppnode != null) {
                    Face ppface = ppnode.face;
                    j = pface.getNeighbor((i + 1) % 3) == ppface.key ? pface.verts[(i + 2) % 3].index : pface.verts[(i + 1) % 3].index;
                } else {
                    j = pface.verts[(i + 1) % 3].index;
                }
                i = face.findSharedEdge(ind[0]);
                if (face.verts[i].index == j) {
                    return ind[0];
                }
                return ind[1];
            }
            return ind[0];
        }
        if (n[0] < n[1] && n[0] < n[2]) {
            return ind[0];
        }
        if (n[1] < n[0] && n[1] < n[2]) {
            return ind[1];
        }
        if (n[2] < n[0] && n[2] < n[1]) {
            return ind[2];
        }
        if (n[0] == n[1] && n[0] < n[2]) {
            if (n[0] != 0) {
                n[0] = this.resetNhbr(ind[0], faces, faceNodes);
                n[1] = this.resetNhbr(ind[1], faces, faceNodes);
            }
            if (n[0] <= n[1]) {
                return ind[0];
            }
            return ind[1];
        }
        if (n[1] == n[2] && n[1] < n[0]) {
            if (n[1] != 0) {
                n[1] = this.resetNhbr(ind[1], faces, faceNodes);
                n[2] = this.resetNhbr(ind[2], faces, faceNodes);
            }
            if (n[1] <= n[2]) {
                return ind[1];
            }
            return ind[2];
        }
        if (n[2] == n[0] && n[2] < n[1]) {
            if (n[0] != 0) {
                n[0] = this.resetNhbr(ind[0], faces, faceNodes);
                n[2] = this.resetNhbr(ind[2], faces, faceNodes);
            }
            if (n[0] <= n[2]) {
                return ind[0];
            }
            return ind[2];
        }
        if (n[0] != 0) {
            n[0] = this.resetNhbr(ind[0], faces, faceNodes);
            n[1] = this.resetNhbr(ind[1], faces, faceNodes);
            n[2] = this.resetNhbr(ind[2], faces, faceNodes);
        }
        if (n[0] <= n[1] && n[0] <= n[2]) {
            return ind[0];
        }
        if (n[1] <= n[2]) {
            return ind[1];
        }
        return ind[2];
    }

    void setNumNhbrs(Face[] faces) {
        int numFaces = faces.length;
        this.numNhbrs = new int[numFaces];
        for (int i = 0; i < numFaces; ++i) {
            this.numNhbrs[i] = faces[i].numNhbrs;
        }
    }

    void freeNhbrTable() {
        this.numNhbrs = null;
    }

    void updateNumNhbrs(Node node) {
        Face face = node.face;
        int i = face.getNeighbor(0);
        if (i != -1) {
            int n = i;
            this.numNhbrs[n] = this.numNhbrs[n] - 1;
        }
        if ((i = face.getNeighbor(1)) != -1) {
            int n = i;
            this.numNhbrs[n] = this.numNhbrs[n] - 1;
        }
        if ((i = face.getNeighbor(2)) != -1) {
            int n = i;
            this.numNhbrs[n] = this.numNhbrs[n] - 1;
        }
    }

    int resetNhbr(int y, Face[] faces, Node[] faceNodes) {
        int x = -1;
        Face nface = faces[y];
        for (int j = 0; j < 3; ++j) {
            int i = nface.getNeighbor(j);
            if (i == -1 || !faceNodes[i].notAccessed() || x != -1 && x <= this.numNhbrs[i]) continue;
            x = this.numNhbrs[i];
        }
        return x;
    }

    ArrayList hamilton(Node[] sTree, int[] numStrips, int[] numPatches) {
        int numNodes = sTree.length;
        int ns = 0;
        int np = 0;
        ArrayList strips = new ArrayList();
        for (int i = numNodes - 1; i >= 0; --i) {
            Node node;
            ArrayList<Face> currStrip;
            Node cnode = sTree[i];
            if (cnode.isRoot()) {
                ++np;
                currStrip = new ArrayList<Face>();
                currStrip.add(0, cnode.face);
                node = cnode.left;
                while (node != null) {
                    currStrip.add(0, node.face);
                    node = node.left;
                }
                node = cnode.right;
                while (node != null) {
                    currStrip.add(currStrip.size(), node.face);
                    node = node.left;
                }
                ++ns;
                strips.add(currStrip);
                continue;
            }
            if (cnode.numChildren != 2) continue;
            Node pnode = cnode.parent;
            if (pnode.isRoot() && pnode.numChildren == 1) {
                pnode = cnode.right;
                cnode = pnode.left != null ? pnode : cnode.left;
            }
            cnode.remove();
            currStrip = new ArrayList();
            currStrip.add(0, cnode.face);
            node = cnode.left;
            while (node != null) {
                currStrip.add(0, node.face);
                node = node.left;
            }
            node = cnode.right;
            while (node != null) {
                currStrip.add(currStrip.size(), node.face);
                node = node.left;
            }
            ++ns;
            strips.add(currStrip);
        }
        numStrips[0] = ns;
        numPatches[0] = np;
        return strips;
    }

    ArrayList stripe(ArrayList strips) {
        int numStrips = strips.size();
        ArrayList<Istream> istreams = new ArrayList<Istream>();
        boolean ccw = true;
        Vertex[] buf = new Vertex[4];
        for (int i = 0; i < numStrips; ++i) {
            ArrayList currStrip = (ArrayList)strips.get(i);
            int count = 0;
            boolean done = false;
            Face face = this.getNextFace(currStrip, count++);
            while (!done) {
                Istream currStream;
                boolean cont = true;
                if (this.stripDone(currStrip, count)) {
                    currStream = new Istream(face.verts, 3, false);
                    currStream.head = face.key;
                    done = true;
                    currStream.tail = face.key;
                } else {
                    Face prev = face;
                    face = this.getNextFace(currStrip, count++);
                    int share = prev.findSharedEdge(face.key);
                    buf[0] = prev.verts[share];
                    buf[1] = prev.verts[(share + 1) % 3];
                    buf[2] = prev.verts[(share + 2) % 3];
                    share = face.findSharedEdge(prev.key);
                    buf[3] = face.verts[share];
                    currStream = new Istream(buf, 4, false);
                    currStream.head = prev.key;
                    if (this.stripDone(currStrip, count)) {
                        done = true;
                        currStream.tail = face.key;
                    }
                    while (cont && !this.stripDone(currStrip, count)) {
                        prev = face;
                        if (this.seq(currStream, face = this.getNextFace(currStrip, count++), share = face.findSharedEdge(prev.key))) {
                            currStream.append(face.verts[share]);
                            if (!this.stripDone(currStrip, count)) continue;
                            done = true;
                            currStream.tail = face.key;
                            continue;
                        }
                        currStream.swapEnd();
                        currStream.append(face.verts[share]);
                        if (!this.stripDone(currStrip, count)) continue;
                        done = true;
                        currStream.tail = face.key;
                    }
                }
                istreams.add(currStream);
            }
        }
        return istreams;
    }

    boolean stripDone(ArrayList strip, int count) {
        return count >= strip.size();
    }

    boolean seq(Istream stream, Face face, int share) {
        int length = stream.length;
        Vertex v1 = face.edges[share].v1;
        Vertex v2 = face.edges[share].v2;
        Vertex last = stream.istream[length - 1];
        Vertex prev = stream.istream[length - 2];
        return v1.equals(prev) && v2.equals(last) || v1.equals(last) && v2.equals(prev);
    }

    boolean orientSeq(boolean ccw, Istream stream, Face face) {
        int length = stream.length;
        Vertex last = stream.istream[length - 1];
        Vertex prev = stream.istream[length - 2];
        return ccw && this.checkOrientCCWSeq(last, prev, face) || !ccw && this.checkOrientCWSeq(last, prev, face);
    }

    boolean orientZAT(boolean ccw, Istream stream, Face face) {
        int length = stream.length;
        Vertex last = stream.istream[length - 1];
        Vertex swap = stream.istream[length - 3];
        return ccw && this.checkOrientCWSeq(last, swap, face) || !ccw && this.checkOrientCCWSeq(last, swap, face);
    }

    boolean checkOrientCWSeq(Vertex last, Vertex prev, Face face) {
        System.out.println("checkOrientCWSeq");
        System.out.println("last = " + last.index);
        System.out.println("prev = " + prev.index);
        System.out.print("face = ");
        face.printVertices();
        return !(last.equals(face.verts[0]) ? !prev.equals(face.verts[1]) : (last.equals(face.verts[1]) ? !prev.equals(face.verts[2]) : last.equals(face.verts[2]) && !prev.equals(face.verts[0])));
    }

    boolean checkOrientCCWSeq(Vertex last, Vertex prev, Face face) {
        System.out.println("checkOrientCCWSeq");
        System.out.println("last = " + last.index);
        System.out.println("prev = " + prev.index);
        System.out.print("face = ");
        face.printVertices();
        if (prev.equals(face.verts[0])) {
            if (!last.equals(face.verts[1])) {
                System.out.println("ORIENTATION PROBLEM!");
                return false;
            }
        } else if (prev.equals(face.verts[1])) {
            if (!last.equals(face.verts[2])) {
                System.out.println("ORIENTATION PROBLEM!");
                return false;
            }
        } else if (prev.equals(face.verts[2]) && !last.equals(face.verts[0])) {
            System.out.println("ORIENTATION PROBLEM!");
            return false;
        }
        return true;
    }

    Face getNextFace(ArrayList currStrip, int index) {
        if (currStrip.size() > index) {
            return (Face)currStrip.get(index);
        }
        return null;
    }

    void concatenate(ArrayList strips, Face[] faces) {
        int i;
        int numFaces = faces.length;
        int[] faceTable = new int[numFaces];
        for (i = 0; i < numFaces; ++i) {
            faceTable[i] = -1;
        }
        i = 0;
        while (i < strips.size()) {
            Istream strm = (Istream)strips.get(i);
            faceTable[strm.head] = i;
            faceTable[strm.tail] = i++;
        }
        this.reduceCostByTwo(strips, faces, faceTable);
        this.reduceCostByOne(strips, faces, faceTable);
        this.reduceCostByZero(strips, faces, faceTable);
    }

    void reduceCostByTwo(ArrayList strips, Face[] faces, int[] faceTable) {
        int numFaces = faces.length;
        block0: for (int i = 0; i < numFaces; ++i) {
            int j;
            Vertex swap;
            Vertex[] seq1;
            int len1;
            Istream strm1;
            int id1;
            int id = faceTable[i];
            if (id == -1) continue;
            boolean sync = false;
            boolean sync1 = false;
            Istream strm = (Istream)strips.get(id);
            int len = strm.length;
            Vertex[] seq = strm.istream;
            Face face = faces[i];
            Vertex[] verts = face.verts;
            if (strm.fan) continue;
            if (len == 3) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    int k = face.getNeighbor(j2);
                    if (k == -1 || (id1 = faceTable[k]) == -1 || id1 == id) continue;
                    seq[0] = verts[j2];
                    seq[1] = verts[(j2 + 1) % 3];
                    seq[2] = verts[(j2 + 2) % 3];
                    strm1 = (Istream)strips.get(id1);
                    len1 = strm1.length;
                    if (k != strm1.head) {
                        strm1.invert();
                        if (len1 % 2 != 0) {
                            sync1 = true;
                        }
                    }
                    seq1 = strm1.istream;
                    if (len1 == 3) {
                        int m = faces[k].findSharedEdge(i);
                        strm.append(faces[k].verts[m]);
                        strm1.length = 0;
                        strm1.istream = null;
                        strm.tail = k;
                        faceTable[k] = id;
                        --i;
                        continue block0;
                    }
                    if (len1 == 4 && seq[1].index == seq1[0].index && seq[2].index == seq1[2].index) {
                        swap = seq1[1];
                        seq1[1] = seq1[2];
                        seq1[2] = swap;
                    }
                    if (seq[1].index == seq1[0].index && seq[2].index == seq1[1].index) {
                        strm.addStream(strm1);
                        faceTable[k] = -1;
                        faceTable[strm.tail] = id;
                        --i;
                        continue block0;
                    }
                    if (!sync1) continue;
                    strm1.invert();
                    sync1 = false;
                }
                continue;
            }
            if (i != strm.tail && len % 2 != 0) continue;
            if (i != strm.tail) {
                strm.invert();
                seq = strm.istream;
            }
            swap = seq[len - 3];
            int m = -1;
            if (verts[0].index == swap.index) {
                m = 0;
            } else if (verts[1].index == swap.index) {
                m = 1;
            } else if (verts[2].index == swap.index) {
                m = 2;
            }
            if (m == -1) {
                // empty if block
            }
            if ((id1 = (j = face.getNeighbor(m)) == -1 ? j : faceTable[j]) != -1 && ((Istream)strips.get((int)id1)).fan != strm.fan) {
                id1 = -1;
            }
            if (id1 == -1 || id1 == id) continue;
            strm1 = (Istream)strips.get(id1);
            len1 = strm1.length;
            if (j != strm1.head) {
                strm1.invert();
                if (len1 % 2 != 0) {
                    sync1 = true;
                }
            }
            seq1 = strm1.istream;
            if (len1 == 3) {
                m = faces[j].findSharedEdge(i);
                strm.append(faces[j].verts[m]);
                strm1.length = 0;
                strm1.istream = null;
                strm.tail = j;
                faceTable[i] = -1;
                faceTable[j] = id;
                continue;
            }
            if (len1 == 4 && seq[len - 2].index == seq1[0].index && seq[len - 1].index == seq1[2].index) {
                swap = seq1[1];
                seq1[1] = seq1[2];
                seq1[2] = swap;
            }
            if (seq[len - 2].index == seq1[0].index && seq[len - 1].index == seq1[1].index) {
                strm.addStream(strm1);
                faceTable[i] = -1;
                faceTable[strm.tail] = id;
                faceTable[j] = -1;
                continue;
            }
            if (!sync1) continue;
            strm1.invert();
        }
    }

    void reduceCostByOne(ArrayList strips, Face[] faces, int[] faceTable) {
        int numFaces = faces.length;
        block0: for (int i = 0; i < numFaces; ++i) {
            int k;
            int id2;
            int j;
            Vertex swap;
            Vertex[] seq1;
            int len1;
            Istream strm1;
            int id1;
            int id = faceTable[i];
            if (id == -1 || ((Istream)strips.get((int)id)).fan) continue;
            boolean sync = false;
            Istream strm = (Istream)strips.get(id);
            Vertex[] seq = strm.istream;
            Face face = faces[i];
            Vertex[] verts = face.verts;
            int len = strm.length;
            if (len == 3) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    int k2 = face.getNeighbor(j2);
                    if (k2 == -1 || (id1 = faceTable[k2]) == -1 || id1 == id || ((Istream)strips.get((int)id1)).fan) continue;
                    seq[0] = verts[j2];
                    seq[1] = verts[(j2 + 1) % 3];
                    seq[2] = verts[(j2 + 2) % 3];
                    strm1 = (Istream)strips.get(id1);
                    len1 = strm1.length;
                    if (k2 != strm1.head) {
                        strm1.invert();
                        if (len1 % 2 != 0) {
                            sync = true;
                        }
                    }
                    seq1 = strm1.istream;
                    if (len1 == 4 && (seq[1].index == seq1[2].index && seq[2].index == seq1[0].index || seq[1].index == seq1[0].index && seq[2].index == seq1[2].index)) {
                        swap = seq1[1];
                        seq1[1] = seq1[2];
                        seq1[2] = swap;
                    }
                    if (seq[1].index == seq1[0].index && seq[2].index == seq1[1].index) {
                        strm.addStream(strm1);
                        faceTable[k2] = -1;
                        faceTable[strm.tail] = id;
                        --i;
                        continue block0;
                    }
                    if (seq[1].index == seq1[1].index && seq[2].index == seq1[0].index) {
                        strm.append(seq1[1]);
                        strm.addStream(strm1);
                        faceTable[k2] = -1;
                        faceTable[strm.tail] = id;
                        --i;
                        continue block0;
                    }
                    if (seq[1].index == seq1[0].index && seq[2].index == seq1[2].index) {
                        seq1[0] = seq1[2];
                        strm.append(seq1[1]);
                        strm.addStream(strm1);
                        faceTable[k2] = -1;
                        faceTable[strm.tail] = id;
                        --i;
                        continue block0;
                    }
                    if (!sync) continue;
                    strm1.invert();
                    sync = false;
                }
                continue;
            }
            if (i != strm.tail && len % 2 != 0) continue;
            if (i != strm.tail) {
                strm.invert();
                seq = strm.istream;
            }
            swap = seq[len - 3];
            int m = -1;
            if (verts[0].index == swap.index) {
                m = 0;
            } else if (verts[1].index == swap.index) {
                m = 1;
            } else if (verts[2].index == swap.index) {
                m = 2;
            }
            if (m == -1) {
                // empty if block
            }
            if ((id1 = (j = face.getNeighbor(m)) == -1 ? j : faceTable[j]) != -1 && ((Istream)strips.get((int)id1)).fan != strm.fan) {
                id1 = -1;
            }
            swap = seq[len - 2];
            m = -1;
            if (verts[0].index == swap.index) {
                m = 0;
            } else if (verts[1].index == swap.index) {
                m = 1;
            } else if (verts[2].index == swap.index) {
                m = 2;
            }
            if (m == -1) {
                // empty if block
            }
            if ((id2 = (k = face.getNeighbor(m)) == -1 ? k : faceTable[k]) != -1 && ((Istream)strips.get((int)id2)).fan != strm.fan) {
                id2 = -1;
            }
            boolean success = false;
            if (id1 != -1 && id1 != id) {
                strm1 = (Istream)strips.get(id1);
                len1 = strm1.length;
                if (j != strm1.head) {
                    strm1.invert();
                    if (len1 % 2 != 0) {
                        sync = true;
                    }
                }
                seq1 = strm1.istream;
                if (len1 == 4 && (seq[len - 2].index == seq1[2].index && seq[len - 1].index == seq1[0].index || seq[len - 2].index == seq1[0].index && seq[len - 1].index == seq1[2].index)) {
                    swap = seq1[1];
                    seq1[1] = seq1[2];
                    seq1[2] = swap;
                }
                if (seq[len - 2].index == seq1[0].index && seq[len - 1].index == seq1[1].index) {
                    strm.addStream(strm1);
                    faceTable[i] = -1;
                    faceTable[strm.tail] = id;
                    faceTable[j] = -1;
                    success = true;
                } else if (seq[len - 2].index == seq1[1].index && seq[len - 1].index == seq1[0].index) {
                    strm.append(seq1[1]);
                    strm.addStream(strm1);
                    faceTable[i] = -1;
                    faceTable[strm.tail] = id;
                    faceTable[j] = -1;
                    success = true;
                } else if (seq[len - 2].index == seq1[0].index && seq[len - 1].index == seq1[2].index) {
                    seq1[0] = seq1[2];
                    strm.append(seq1[1]);
                    strm.addStream(strm1);
                    faceTable[i] = -1;
                    faceTable[strm.tail] = id;
                    faceTable[j] = -1;
                    success = true;
                } else if (sync) {
                    strm1.invert();
                    sync = false;
                }
            }
            if (success || id2 == -1 || id2 == id) continue;
            strm1 = (Istream)strips.get(id2);
            len1 = strm1.length;
            if (k != strm1.head) {
                strm1.invert();
                if (len1 % 2 != 0) {
                    sync = true;
                }
            }
            seq1 = strm1.istream;
            if (len1 == 4 && seq[len - 3].index == seq1[0].index && seq[len - 1].index == seq1[2].index) {
                swap = seq1[1];
                seq1[1] = seq1[2];
                seq1[2] = swap;
            }
            if (seq[len - 3].index == seq1[0].index && seq[len - 1].index == seq1[1].index) {
                strm.swapEnd();
                strm.addStream(strm1);
                faceTable[i] = -1;
                faceTable[strm.tail] = id;
                faceTable[k] = -1;
                success = true;
            }
            if (success || !sync) continue;
            strm1.invert();
        }
    }

    void reduceCostByZero(ArrayList strips, Face[] faces, int[] faceTable) {
        int numFaces = faces.length;
        block0: for (int i = 0; i < numFaces; ++i) {
            int k;
            int id2;
            int j;
            Vertex[] seq1;
            int len1;
            Istream strm1;
            int id1;
            int id = faceTable[i];
            if (id == -1 || ((Istream)strips.get((int)id)).fan) continue;
            boolean sync = false;
            Istream strm = (Istream)strips.get(id);
            Vertex[] seq = strm.istream;
            int len = strm.length;
            Face face = faces[i];
            Vertex[] verts = face.verts;
            if (len == 3) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    int k2 = face.getNeighbor(j2);
                    if (k2 == -1 || (id1 = faceTable[k2]) == -1 || id1 == id || ((Istream)strips.get((int)id1)).fan) continue;
                    seq[0] = verts[j2];
                    seq[1] = verts[(j2 + 1) % 3];
                    seq[2] = verts[(j2 + 2) % 3];
                    strm1 = (Istream)strips.get(id1);
                    len1 = strm1.length;
                    if (k2 != strm1.head) {
                        strm1.invert();
                        if (len1 % 2 != 0) {
                            sync = true;
                        }
                    }
                    seq1 = strm1.istream;
                    if (seq[1].index == seq1[2].index && seq[2].index == seq1[0].index) {
                        seq1[0] = seq1[2];
                        strm.append(seq1[0]);
                        strm.append(seq1[1]);
                        strm.addStream(strm1);
                        faceTable[k2] = -1;
                        faceTable[strm.tail] = id;
                        --i;
                        continue block0;
                    }
                    if (!sync) continue;
                    strm1.invert();
                    sync = false;
                }
                continue;
            }
            if (i != strm.tail && len % 2 != 0) continue;
            if (i != strm.tail) {
                strm.invert();
                seq = strm.istream;
            }
            Vertex swap = seq[len - 3];
            int m = -1;
            if (verts[0].index == swap.index) {
                m = 0;
            } else if (verts[1].index == swap.index) {
                m = 1;
            } else if (verts[2].index == swap.index) {
                m = 2;
            }
            if (m == -1) {
                // empty if block
            }
            if ((id1 = (j = face.getNeighbor(m)) == -1 ? j : faceTable[j]) != -1 && ((Istream)strips.get((int)id1)).fan != strm.fan) {
                id1 = -1;
            }
            swap = seq[len - 2];
            m = -1;
            if (verts[0].index == swap.index) {
                m = 0;
            } else if (verts[1].index == swap.index) {
                m = 1;
            } else if (verts[2].index == swap.index) {
                m = 2;
            }
            if (m == -1) {
                // empty if block
            }
            if ((id2 = (k = face.getNeighbor(m)) == -1 ? k : faceTable[k]) != -1 && ((Istream)strips.get((int)id2)).fan != strm.fan) {
                id2 = -1;
            }
            boolean success = false;
            if (id1 != -1 && id1 != id) {
                strm1 = (Istream)strips.get(id1);
                len1 = strm1.length;
                if (j != strm1.head) {
                    strm1.invert();
                    if (len1 % 2 != 0) {
                        sync = true;
                    }
                }
                seq1 = strm1.istream;
                if (seq[len - 2].index == seq1[2].index && seq[len - 1].index == seq1[0].index) {
                    seq1[0] = seq1[2];
                    strm.append(seq1[0]);
                    strm.append(seq1[1]);
                    strm.addStream(strm1);
                    faceTable[i] = -1;
                    faceTable[strm.tail] = id;
                    faceTable[j] = -1;
                    success = true;
                } else if (sync) {
                    strm1.invert();
                    sync = false;
                }
            }
            if (success || id2 == -1 || id2 == id) continue;
            strm1 = (Istream)strips.get(id2);
            len1 = strm1.length;
            if (k != strm1.head) {
                strm1.invert();
                if (len1 % 2 != 0) {
                    sync = true;
                }
            }
            seq1 = strm1.istream;
            if (len1 == 4 && (seq[len - 3].index == seq1[2].index && seq[len - 1].index == seq1[0].index || seq[len - 3].index == seq1[0].index && seq[len - 1].index == seq1[2].index)) {
                swap = seq1[1];
                seq1[1] = seq1[2];
                seq1[2] = swap;
            }
            if (seq[len - 3].index == seq1[1].index && seq[len - 1].index == seq1[0].index) {
                strm.swapEnd();
                strm.append(seq1[1]);
                strm.addStream(strm1);
                faceTable[i] = -1;
                faceTable[strm.tail] = id;
                faceTable[k] = -1;
                continue;
            }
            if (seq[len - 3].index == seq1[0].index && seq[len - 1].index == seq1[2].index) {
                seq1[0] = seq1[2];
                strm.swapEnd();
                strm.append(seq1[1]);
                strm.addStream(strm1);
                faceTable[i] = -1;
                faceTable[strm.tail] = id;
                faceTable[k] = -1;
                continue;
            }
            if (seq[len - 3].index == seq1[0].index && seq[len - 1].index == seq1[1].index) {
                strm.swapEnd();
                strm.addStream(strm1);
                faceTable[i] = -1;
                faceTable[strm.tail] = id;
                faceTable[k] = -1;
                continue;
            }
            if (!sync) continue;
            strm1.invert();
        }
    }

    void putBackData(GeometryInfo gi, ArrayList strips) {
        int[] tempStripCounts = new int[strips.size()];
        int ciSize = 0;
        int i = 0;
        while (i < strips.size()) {
            int stripLength = ((Istream)strips.get((int)i)).length;
            if (stripLength != 0) {
                tempStripCounts[i] = stripLength;
                ciSize += stripLength;
                ++i;
                continue;
            }
            strips.remove(i);
        }
        if (ciSize > 3) {
            int i2;
            gi.setPrimitive(4);
            int[] stripCounts = new int[strips.size()];
            System.arraycopy(tempStripCounts, 0, stripCounts, 0, strips.size());
            gi.setStripCounts(stripCounts);
            int[] coords = new int[ciSize];
            int[] normals = null;
            int[][] textures = null;
            int[] colors = null;
            Object[] stripColors = null;
            if (this.hasNormals) {
                normals = new int[ciSize];
            }
            if (this.hasTextures) {
                textures = new int[this.texSetCount][ciSize];
            }
            if (this.hasColors) {
                colors = new int[ciSize];
            }
            if (this.colorStrips) {
                stripColors = new Color3b[ciSize];
                colors = new int[ciSize];
            }
            int count = 0;
            for (i2 = 0; i2 < strips.size(); ++i2) {
                Istream currStrip = (Istream)strips.get(i2);
                if (currStrip.length < 3) {
                    throw new RuntimeException("currStrip.length = " + currStrip.length);
                }
                Color stripColor = null;
                if (this.colorStrips) {
                    int r = (int)(Math.random() * 1000.0) % 255;
                    int g = (int)(Math.random() * 1000.0) % 255;
                    int b = (int)(Math.random() * 1000.0) % 255;
                    stripColor = new Color(r, g, b);
                }
                for (int j = 0; j < currStrip.length; ++j) {
                    coords[count] = currStrip.istream[j].index;
                    if (this.hasNormals) {
                        normals[count] = currStrip.istream[j].normal;
                    }
                    if (this.hasTextures) {
                        for (int k = 0; k < this.texSetCount; ++k) {
                            textures[k][count] = currStrip.istream[j].texture[k];
                        }
                    }
                    if (this.hasColors) {
                        colors[count] = currStrip.istream[j].color;
                    }
                    if (this.colorStrips) {
                        stripColors[count] = new Color3b((byte)stripColor.getRed(), (byte)stripColor.getGreen(), (byte)stripColor.getBlue());
                    }
                    ++count;
                }
            }
            gi.setCoordinateIndices(coords);
            if (this.hasNormals) {
                gi.setNormalIndices(normals);
            }
            if (this.hasTextures) {
                for (i2 = 0; i2 < this.texSetCount; ++i2) {
                    gi.setTextureCoordinateIndices(i2, textures[i2]);
                }
            }
            if (this.hasColors) {
                gi.setColorIndices(colors);
            }
            if (this.colorStrips) {
                gi.setColors((Color3b[])stripColors);
                colors = gi.getListIndices(stripColors);
                gi.setColorIndices(colors);
            }
        }
    }

    class Istream {
        boolean fan = false;
        int length = 0;
        Vertex[] istream;
        int head;
        int tail;

        Istream(Vertex[] list, int size, boolean isFan) {
            if (size == 0) {
                throw new RuntimeException("size is 0");
            }
            this.fan = isFan;
            this.length = size;
            this.istream = new Vertex[this.length];
            System.arraycopy(list, 0, this.istream, 0, this.length);
        }

        void append(Vertex vertex) {
            this.growArray();
            this.istream[this.length] = vertex;
            ++this.length;
        }

        void swapEnd() {
            this.growArray();
            this.istream[this.length] = this.istream[this.length - 1];
            this.istream[this.length - 1] = this.istream[this.length - 3];
            ++this.length;
        }

        void growArray() {
            if (this.length >= this.istream.length) {
                Vertex[] old = this.istream;
                this.istream = new Vertex[this.length + 3];
                System.arraycopy(old, 0, this.istream, 0, this.length);
            }
        }

        void invert() {
            Vertex[] tmp = new Vertex[this.istream.length];
            for (int i = 0; i < this.length; ++i) {
                tmp[i] = this.istream[this.length - i - 1];
            }
            System.arraycopy(tmp, 0, this.istream, 0, this.istream.length);
            tmp = null;
            int swap = this.head;
            this.head = this.tail;
            this.tail = swap;
        }

        void addStream(Istream strm) {
            int strmLen = strm.length;
            int size = strmLen + this.length - 2;
            if (size >= this.istream.length) {
                Vertex[] old = this.istream;
                this.istream = new Vertex[size];
                System.arraycopy(old, 0, this.istream, 0, this.length);
            }
            System.arraycopy(strm.istream, 2, this.istream, this.length, strmLen - 2);
            this.tail = strm.tail;
            this.length = size;
            strm.length = 0;
            strm.istream = null;
        }
    }

    class SortedList {
        ArrayList list = new ArrayList();

        SortedList() {
        }

        int sortedInsert(Node data, int start) {
            while (start < this.list.size() && ((Node)this.list.get((int)start)).depth <= data.depth) {
                ++start;
            }
            this.list.add(start, data);
            return start + 1;
        }

        Node pop() {
            if (!this.list.isEmpty()) {
                return (Node)this.list.remove(0);
            }
            return null;
        }
    }

    class Node {
        Face face;
        Node parent;
        Node left;
        Node right;
        int depth;
        int numChildren;
        int attrib;
        static final int WHITE = 0;
        static final int GREY = 1;
        static final int BLACK = 2;

        Node(Face f) {
            this.face = f;
        }

        void insert(Node p) {
            this.parent = p;
            this.depth = p.depth + 1;
            this.attrib = 1;
            if (this.parent.left == null) {
                this.parent.left = this;
            } else {
                this.parent.right = this;
            }
            ++this.parent.numChildren;
        }

        void remove() {
            if (this.parent != null) {
                if (this.parent.left == this) {
                    this.parent.left = this.parent.right;
                    this.parent.right = null;
                } else {
                    this.parent.right = null;
                }
                --this.parent.numChildren;
            }
        }

        void setRoot() {
            this.depth = 0;
            this.attrib = 1;
        }

        boolean notAccessed() {
            return this.attrib == 0;
        }

        void processed() {
            this.attrib = 2;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        void print() {
            System.out.println(this);
            System.out.println("Node depth: " + this.depth);
            this.face.printVertices();
            System.out.print("parent: ");
            if (this.parent != null) {
                this.parent.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.print("left: ");
            if (this.left != null) {
                this.left.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.print("right: ");
            if (this.right != null) {
                this.right.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.println("attrib: " + this.attrib);
            System.out.println("");
        }
    }

    class Face {
        int key;
        int numNhbrs = 0;
        Vertex[] verts = null;
        Edge[] edges = null;

        Face(int index, Vertex v1, Vertex v2, Vertex v3) {
            this.key = index;
            this.verts = new Vertex[3];
            this.verts[0] = v1;
            this.verts[1] = v2;
            this.verts[2] = v3;
            this.edges = new Edge[3];
            this.edges[0] = null;
            this.edges[1] = null;
            this.edges[2] = null;
            this.numNhbrs = 3;
        }

        int getNeighbor(int edge) {
            return this.edges[edge].face;
        }

        int findSharedEdge(int key) {
            if (this.edges[0].face == key) {
                return 0;
            }
            if (this.edges[1].face == key) {
                return 1;
            }
            if (this.edges[2].face == key) {
                return 2;
            }
            return -1;
        }

        int getEdgeIndex(Edge edge) {
            if (this.edges[0].equals(edge)) {
                return 0;
            }
            if (this.edges[1].equals(edge)) {
                return 1;
            }
            return 2;
        }

        void counterEdgeDel(Edge edge) {
            if (this.edges[0].equals(edge)) {
                this.edges[0].face = -1;
                --this.numNhbrs;
            } else if (this.edges[1].equals(edge)) {
                this.edges[1].face = -1;
                --this.numNhbrs;
            } else if (this.edges[2].equals(edge)) {
                this.edges[2].face = -1;
                --this.numNhbrs;
            }
        }

        void printAdjacency() {
            System.out.println("Face " + this.key + ": ");
            System.out.println("\t numNhbrs = " + this.numNhbrs);
            System.out.println("\t edge 0: Face " + this.edges[0].face);
            System.out.println("\t edge 1: Face " + this.edges[1].face);
            System.out.println("\t edge 2: Face " + this.edges[2].face);
        }

        void printVertices() {
            System.out.println("Face " + this.key + ": (" + this.verts[0].index + ", " + this.verts[1].index + ", " + this.verts[2].index + ")");
        }
    }

    class Edge {
        Vertex v1;
        Vertex v2;
        int face;

        Edge(Vertex vertex1, Vertex vertex2, int faceIndex) {
            this.face = faceIndex;
            if (vertex1.lessThan(vertex2)) {
                this.v1 = vertex1;
                this.v2 = vertex2;
            } else {
                this.v1 = vertex2;
                this.v2 = vertex1;
            }
        }

        boolean equals(Edge edge) {
            return this.v1.equals(edge.v1) && this.v2.equals(edge.v2);
        }

        boolean lessThan(Edge edge) {
            if (this.v1.lessThan(edge.v1)) {
                return true;
            }
            if (this.v1.equals(edge.v1)) {
                return this.v2.lessThan(edge.v2);
            }
            return false;
        }
    }

    class Vertex {
        int index;
        int normal = -1;
        int numTexSets = 0;
        int[] texture = null;
        int color = -1;

        Vertex(int vertIndex) {
            this(vertIndex, -1, 0, null, -1);
        }

        Vertex(int vertIndex, int vertNormal, int vertNumTexSets, int[] vertTexture, int vertColor) {
            this.index = vertIndex;
            this.normal = vertNormal;
            this.numTexSets = vertNumTexSets;
            if (this.numTexSets > 0) {
                this.texture = new int[this.numTexSets];
                System.arraycopy(vertTexture, 0, this.texture, 0, this.numTexSets);
            }
            this.color = vertColor;
        }

        boolean equals(Vertex v) {
            for (int i = 0; i < this.numTexSets; ++i) {
                if (this.texture[i] == v.texture[i]) continue;
                return false;
            }
            return v.index == this.index && v.normal == this.normal && v.color == this.color;
        }

        boolean lessThan(Vertex v) {
            if (this.index < v.index) {
                return true;
            }
            if (this.index > v.index) {
                return false;
            }
            if (this.normal < v.normal) {
                return true;
            }
            if (this.normal > v.normal) {
                return false;
            }
            for (int i = 0; i < this.numTexSets; ++i) {
                if (this.texture[i] < v.texture[i]) {
                    return true;
                }
                if (this.texture[i] <= v.texture[i]) continue;
                return false;
            }
            if (this.color < v.color) {
                return true;
            }
            if (this.color > v.color) {
                return false;
            }
            return false;
        }
    }
}

