/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigDevice;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.java3d.utils.universe.ConfigPhysicalBody;
import org.jogamp.java3d.utils.universe.ConfigPhysicalEnvironment;
import org.jogamp.java3d.utils.universe.ConfigScreen;
import org.jogamp.java3d.utils.universe.ConfigSensor;
import org.jogamp.java3d.utils.universe.ConfigSexpression;
import org.jogamp.java3d.utils.universe.ConfigView;
import org.jogamp.java3d.utils.universe.ConfigViewPlatform;
import org.jogamp.java3d.utils.universe.ConfigViewPlatformBehavior;

public class ConfigContainer {
    private Map baseNameMap = new HashMap();
    private Map viewCanvasMap = new HashMap();
    private ReadOnlyMap bodyMap = null;
    private ReadOnlyMap environmentMap = null;
    private ReadOnlyMap viewerMap = null;
    private ReadOnlyMap deviceMap = null;
    private ReadOnlyMap sensorMap = null;
    private ReadOnlyMap behaviorMap = null;
    private ReadOnlyMap platformMap = null;
    private ReadOnlyMap genericObjectMap = null;
    private ReadOnlySet bodies = null;
    private ReadOnlySet environments = null;
    private ReadOnlySet viewers = null;
    private ReadOnlySet devices = null;
    private ReadOnlySet sensors = null;
    private ReadOnlySet behaviors = null;
    private ReadOnlySet platforms = null;
    private ReadOnlySet genericObjects = null;
    private int transformCount = 1;
    private boolean setVisible = false;
    private ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    String currentFileName = null;

    public ConfigContainer(URL userConfig) {
        this(userConfig, false, 1, true);
    }

    public ConfigContainer(URL userConfig, ClassLoader classLoader) {
        this(userConfig, false, 1, true, classLoader);
    }

    public ConfigContainer(URL userConfig, boolean setVisible, int transformCount) {
        this(userConfig, setVisible, transformCount, true);
    }

    public ConfigContainer(URL userConfig, boolean setVisible, int transformCount, ClassLoader classLoader) {
        this(userConfig, setVisible, transformCount, true, classLoader);
    }

    ConfigContainer(URL userConfig, boolean setVisible, int transformCount, boolean attachBehaviors) {
        if (transformCount < 1) {
            throw new IllegalArgumentException("transformCount must be greater than 0");
        }
        this.loadConfig(userConfig);
        this.processConfig(setVisible, transformCount, attachBehaviors);
    }

    ConfigContainer(URL userConfig, boolean setVisible, int transformCount, boolean attachBehaviors, ClassLoader classLoader) {
        this(userConfig, setVisible, transformCount, attachBehaviors);
        this.classLoader = classLoader;
    }

    private void loadConfig(URL userConfig) {
        InputStream inputStream = null;
        StreamTokenizer streamTokenizer = null;
        String lastFileName = this.currentFileName;
        this.currentFileName = userConfig.toString();
        try {
            inputStream = userConfig.openStream();
            BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
            streamTokenizer = new StreamTokenizer(r);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e + "\nUnable to open " + this.currentFileName);
        }
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(123, 125);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        ConfigSexpression sexp = new ConfigSexpression();
        while (sexp.parseAndEval(this, streamTokenizer, 0) != Boolean.FALSE) {
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e + "\nUnable to close " + this.currentFileName);
        }
        this.currentFileName = lastFileName;
    }

    void evaluateCommand(ArrayList elements, int lineNumber) {
        ConfigCommand cmd = new ConfigCommand(elements, this.currentFileName, lineNumber);
        switch (cmd.type) {
            case 0: {
                ConfigObject co = this.createConfigObject(cmd);
                this.addConfigObject(co);
                break;
            }
            case 3: {
                ConfigObject co = this.createConfigAlias(cmd);
                this.addConfigObject(co);
                break;
            }
            case 2: {
                ConfigObject co = this.findConfigObject(cmd.baseName, cmd.instanceName);
                co.setProperty(cmd);
                break;
            }
            case 5: {
                if (!(cmd.argv[1] instanceof String)) {
                    throw new IllegalArgumentException("Include file must be a URL string");
                }
                URL url = null;
                String urlString = (String)cmd.argv[1];
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e.toString());
                }
                this.loadConfig(url);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command \"" + cmd.commandName + "\"");
            }
        }
    }

    private ConfigObject createConfigObject(ConfigCommand cmd) {
        Class<?> objectClass = null;
        ConfigObject configObject = null;
        try {
            objectClass = Class.forName("org.jogamp.java3d.utils.universe.Config" + cmd.baseName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("\"" + cmd.baseName + "\"" + " is not a configurable object; ignoring command");
        }
        try {
            configObject = (ConfigObject)objectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
            throw new IllegalArgumentException("Ignoring command");
        }
        catch (InstantiationException e) {
            System.out.println(e);
            throw new IllegalArgumentException("Ignoring command");
        }
        for (int i = 2; i < cmd.argc; ++i) {
            if (!(cmd.argv[i] instanceof String) || !((String)cmd.argv[i]).equals("Alias")) continue;
            if (i == cmd.argc - 2 && cmd.argv[i + 1] instanceof String) {
                this.addConfigObject(new ConfigAlias(cmd.baseName, (String)cmd.argv[i + 1], configObject));
                cmd.argc -= 2;
                continue;
            }
            throw new IllegalArgumentException("The alias name must be a string and must be the last command argument");
        }
        configObject.baseName = cmd.baseName;
        configObject.instanceName = cmd.instanceName;
        configObject.creatingCommand = cmd;
        configObject.configContainer = this;
        configObject.setClassLoader(this.classLoader);
        configObject.initialize(cmd);
        return configObject;
    }

    private ConfigObject createConfigAlias(ConfigCommand cmd) {
        if (cmd.argc != 3 || !(cmd.argv[2] instanceof String)) {
            throw new IllegalArgumentException("Command \"" + cmd.commandName + "\" requires an instance name as second argument");
        }
        ConfigObject original = this.findConfigObject(cmd.baseName, (String)cmd.argv[2]);
        return new ConfigAlias(cmd.baseName, cmd.instanceName, original);
    }

    private void addConfigObject(ConfigObject object) {
        ArrayList<ConfigObject> instances = (ArrayList<ConfigObject>)this.baseNameMap.get(object.baseName);
        if (instances == null) {
            instances = new ArrayList<ConfigObject>();
            this.baseNameMap.put(object.baseName, instances);
        }
        for (int i = 0; i < instances.size(); ++i) {
            ConfigObject co = (ConfigObject)instances.get(i);
            if (!co.instanceName.equals(object.instanceName)) continue;
            String base = object.baseName;
            if (base.equals("Screen")) {
                base = "Screen or Window";
            }
            throw new IllegalArgumentException("Duplicate " + base + " instance name \"" + object.instanceName + "\" ignored");
        }
        instances.add(object);
    }

    ConfigObject findConfigObject(String baseName, String instanceName) {
        ArrayList instances = (ArrayList)this.baseNameMap.get(baseName);
        if (instances != null) {
            for (int i = 0; i < instances.size(); ++i) {
                ConfigObject configObject = (ConfigObject)instances.get(i);
                if (!configObject.instanceName.equals(instanceName)) continue;
                if (configObject.isAlias) {
                    return configObject.original;
                }
                return configObject;
            }
        }
        if (baseName.equals("Screen")) {
            baseName = "Screen or Window";
        }
        throw new IllegalArgumentException(baseName + " \"" + instanceName + "\" not found");
    }

    Collection findConfigObjects(String baseName) {
        return this.findConfigObjects(baseName, true);
    }

    Collection findConfigObjects(String baseName, boolean filterAlias) {
        ArrayList instances = (ArrayList)this.baseNameMap.get(baseName);
        if (instances == null || instances.size() == 0) {
            return null;
        }
        if (filterAlias) {
            ArrayList<ConfigObject> output = new ArrayList<ConfigObject>();
            for (int i = 0; i < instances.size(); ++i) {
                ConfigObject configObject = (ConfigObject)instances.get(i);
                if (configObject.isAlias) continue;
                output.add(configObject);
            }
            return output;
        }
        return instances;
    }

    private ConfigObject findConfigObject(String baseName, ConfigCommand cmd) {
        if (cmd.argc != 2 || !(cmd.argv[1] instanceof String)) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Parameter must be a single string"));
        }
        try {
            return this.findConfigObject(baseName, (String)cmd.argv[1]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, e.getMessage()));
        }
    }

    Object evaluateBuiltIn(ConfigCommand cmd) {
        int argc = cmd.argc;
        Object[] argv = cmd.argv;
        if (cmd.commandName.equals("ConfigContainer")) {
            return this;
        }
        if (cmd.commandName.equals("Canvas3D")) {
            return ((ConfigScreen)this.findConfigObject((String)"Screen", (ConfigCommand)cmd)).j3dCanvas;
        }
        if (this.baseNameMap.get(cmd.commandName) != null) {
            return this.findConfigObject((String)cmd.commandName, (ConfigCommand)cmd).targetObject;
        }
        throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Unknown built-in command \"" + cmd.commandName + "\""));
    }

    private void processConfig(boolean setVisible, int transformCount, boolean attachBehaviors) {
        Collection vp;
        Collection pe;
        this.setVisible = setVisible;
        this.transformCount = transformCount;
        Collection c = this.findConfigObjects("PhysicalBody");
        if (c != null) {
            this.processPhysicalBodies(c);
        }
        if ((pe = this.findConfigObjects("PhysicalEnvironment")) != null) {
            this.processPhysicalEnvironments(pe);
        }
        if ((c = this.findConfigObjects("View")) != null) {
            this.processViews(c, setVisible);
        }
        c = this.findConfigObjects("Device");
        Collection s = this.findConfigObjects("Sensor");
        if (c != null) {
            this.processDevices(c, s, pe);
        }
        if ((vp = this.findConfigObjects("ViewPlatform")) != null) {
            this.processViewPlatforms(vp, transformCount);
        }
        if ((c = this.findConfigObjects("ViewPlatformBehavior")) != null) {
            this.processViewPlatformBehaviors(c, vp, attachBehaviors);
        }
        if ((c = this.findConfigObjects("Object")) != null) {
            this.processGenericObjects(c);
        }
    }

    private void processPhysicalEnvironments(Collection c) {
        for (ConfigPhysicalEnvironment e : c) {
            e.targetObject = e.createJ3dPhysicalEnvironment();
        }
    }

    private void processPhysicalBodies(Collection c) {
        for (ConfigPhysicalBody b : c) {
            b.targetObject = b.createJ3dPhysicalBody();
        }
    }

    private void processViews(Collection c, boolean setVisible) {
        for (ConfigView v : c) {
            v.targetObject = v.createViewer(setVisible);
        }
    }

    private void processDevices(Collection c, Collection s, Collection p) {
        ConfigDevice cd2 = null;
        for (ConfigDevice cd2 : c) {
            cd2.targetObject = cd2.createInputDevice();
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            ((ConfigDevice)i.next()).processProperties();
        }
        for (ConfigDevice cd2 : c) {
            if (cd2.j3dInputDevice.initialize()) continue;
            throw new RuntimeException(ConfigDevice.errorMessage(cd2.creatingCommand, "could not initialize device \"" + cd2.instanceName + "\""));
        }
        if (s != null) {
            for (ConfigSensor cs : s) {
                cs.configureSensor();
                cs.targetObject = cs.j3dSensor;
            }
        }
        if (p != null) {
            i = p.iterator();
            while (i.hasNext()) {
                ((ConfigPhysicalEnvironment)i.next()).processDevices();
            }
        }
    }

    private void processViewPlatforms(Collection c, int numTransforms) {
        for (ConfigViewPlatform cvp : c) {
            cvp.targetObject = cvp.createViewingPlatform(numTransforms);
        }
    }

    private void processViewPlatformBehaviors(Collection behaviors, Collection viewPlatforms, boolean attach) {
        for (ConfigViewPlatformBehavior b : behaviors) {
            b.targetObject = b.createViewPlatformBehavior();
        }
        Iterator i = behaviors.iterator();
        while (i.hasNext()) {
            ((ConfigViewPlatformBehavior)i.next()).processProperties();
        }
        if (attach && viewPlatforms != null) {
            i = viewPlatforms.iterator();
            while (i.hasNext()) {
                ((ConfigViewPlatform)i.next()).processBehavior();
            }
        }
    }

    private void processGenericObjects(Collection objects) {
        for (ConfigObject o : objects) {
            o.targetObject = o.createTargetObject();
        }
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            ((ConfigObject)i.next()).processProperties();
        }
    }

    private ReadOnlySet createSet(String baseName) {
        Collection c = this.findConfigObjects(baseName, true);
        if (c == null || c.size() == 0) {
            return null;
        }
        Iterator i = c.iterator();
        ArrayList<Object> l = new ArrayList<Object>();
        while (i.hasNext()) {
            l.add(((ConfigObject)i.next()).targetObject);
        }
        return new ReadOnlySet(l);
    }

    private ReadOnlyMap createMap(String baseName) {
        Collection c = this.findConfigObjects(baseName, false);
        if (c == null || c.size() == 0) {
            return null;
        }
        Iterator i = c.iterator();
        HashMap<String, Object> m = new HashMap<String, Object>();
        while (i.hasNext()) {
            ConfigObject co = (ConfigObject)i.next();
            if (co.isAlias) {
                m.put(co.instanceName, co.original.targetObject);
                continue;
            }
            m.put(co.instanceName, co.targetObject);
        }
        return new ReadOnlyMap(m);
    }

    public Set getPhysicalBodies() {
        if (this.bodies != null) {
            return this.bodies;
        }
        this.bodies = this.createSet("PhysicalBody");
        return this.bodies;
    }

    public Map getNamedPhysicalBodies() {
        if (this.bodyMap != null) {
            return this.bodyMap;
        }
        this.bodyMap = this.createMap("PhysicalBody");
        return this.bodyMap;
    }

    public Set getPhysicalEnvironments() {
        if (this.environments != null) {
            return this.environments;
        }
        this.environments = this.createSet("PhysicalEnvironment");
        return this.environments;
    }

    public Map getNamedPhysicalEnvironments() {
        if (this.environmentMap != null) {
            return this.environmentMap;
        }
        this.environmentMap = this.createMap("PhysicalEnvironment");
        return this.environmentMap;
    }

    public Set getViewers() {
        if (this.viewers != null) {
            return this.viewers;
        }
        this.viewers = this.createSet("View");
        return this.viewers;
    }

    public Map getNamedViewers() {
        if (this.viewerMap != null) {
            return this.viewerMap;
        }
        this.viewerMap = this.createMap("View");
        return this.viewerMap;
    }

    public Set getInputDevices() {
        if (this.devices != null) {
            return this.devices;
        }
        this.devices = this.createSet("Device");
        return this.devices;
    }

    public Map getNamedInputDevices() {
        if (this.deviceMap != null) {
            return this.deviceMap;
        }
        this.deviceMap = this.createMap("Device");
        return this.deviceMap;
    }

    public Set getSensors() {
        if (this.sensors != null) {
            return this.sensors;
        }
        this.sensors = this.createSet("Sensor");
        return this.sensors;
    }

    public Map getNamedSensors() {
        if (this.sensorMap != null) {
            return this.sensorMap;
        }
        this.sensorMap = this.createMap("Sensor");
        return this.sensorMap;
    }

    public Set getViewingPlatforms() {
        if (this.platforms != null) {
            return this.platforms;
        }
        this.platforms = this.createSet("ViewPlatform");
        return this.platforms;
    }

    public Map getNamedViewingPlatforms() {
        if (this.platformMap != null) {
            return this.platformMap;
        }
        this.platformMap = this.createMap("ViewPlatform");
        return this.platformMap;
    }

    public Set getViewPlatformBehaviors() {
        if (this.behaviors != null) {
            return this.behaviors;
        }
        this.behaviors = this.createSet("ViewPlatformBehavior");
        return this.behaviors;
    }

    public Map getNamedViewPlatformBehaviors() {
        if (this.behaviorMap != null) {
            return this.behaviorMap;
        }
        this.behaviorMap = this.createMap("ViewPlatformBehavior");
        return this.behaviorMap;
    }

    public Map getNamedCanvases(String viewName) {
        AbstractMap m = (HashMap<String, Canvas3D>)this.viewCanvasMap.get(viewName);
        if (m != null) {
            return m;
        }
        m = new HashMap<String, Canvas3D>();
        ConfigView cv = (ConfigView)this.findConfigObject("View", viewName);
        for (ConfigScreen cs : cv.screens) {
            m.put(cs.instanceName, cs.j3dCanvas);
            Iterator j = cs.aliases.iterator();
            while (j.hasNext()) {
                m.put(j.next(), cs.j3dCanvas);
            }
        }
        m = new ReadOnlyMap(m);
        this.viewCanvasMap.put(viewName, m);
        return m;
    }

    public Set getGenericObjects() {
        if (this.genericObjects != null) {
            return this.genericObjects;
        }
        this.genericObjects = this.createSet("Object");
        return this.genericObjects;
    }

    public Map getNamedGenericObjects() {
        if (this.genericObjectMap != null) {
            return this.genericObjectMap;
        }
        this.genericObjectMap = this.createMap("Object");
        return this.genericObjectMap;
    }

    public int getViewPlatformTransformCount() {
        return this.transformCount;
    }

    public boolean getViewerVisibility() {
        return this.setVisible;
    }

    public void clear() {
        Iterator i = this.baseNameMap.values().iterator();
        while (i.hasNext()) {
            ((Collection)i.next()).clear();
        }
        this.baseNameMap.clear();
        i = this.viewCanvasMap.values().iterator();
        while (i.hasNext()) {
            ((ReadOnlyMap)i.next()).map.clear();
        }
        this.viewCanvasMap.clear();
        this.currentFileName = null;
        if (this.bodies != null) {
            this.bodies.collection.clear();
            this.bodies = null;
        }
        if (this.environments != null) {
            this.environments.collection.clear();
            this.environments = null;
        }
        if (this.devices != null) {
            this.devices.collection.clear();
            this.devices = null;
        }
        if (this.sensors != null) {
            this.sensors.collection.clear();
            this.sensors = null;
        }
        if (this.behaviors != null) {
            this.behaviors.collection.clear();
            this.behaviors = null;
        }
        if (this.platforms != null) {
            this.platforms.collection.clear();
            this.platforms = null;
        }
        if (this.viewers != null) {
            this.viewers.collection.clear();
            this.viewers = null;
        }
        if (this.genericObjects != null) {
            this.genericObjects.collection.clear();
            this.genericObjects = null;
        }
        if (this.bodyMap != null) {
            this.bodyMap.map.clear();
            this.bodyMap = null;
        }
        if (this.environmentMap != null) {
            this.environmentMap.map.clear();
            this.environmentMap = null;
        }
        if (this.deviceMap != null) {
            this.deviceMap.map.clear();
            this.deviceMap = null;
        }
        if (this.sensorMap != null) {
            this.sensorMap.map.clear();
            this.sensorMap = null;
        }
        if (this.behaviorMap != null) {
            this.behaviorMap.map.clear();
            this.behaviorMap = null;
        }
        if (this.platformMap != null) {
            this.platformMap.map.clear();
            this.platformMap = null;
        }
        if (this.viewerMap != null) {
            this.viewerMap.map.clear();
            this.viewerMap = null;
        }
        if (this.genericObjectMap != null) {
            this.genericObjectMap.map.clear();
            this.genericObjectMap = null;
        }
    }

    public static URL getConfigURL() {
        return ConfigContainer.getConfigURL(null);
    }

    public static URL getConfigURL(String defaultURLString) {
        URL url = null;
        String urlString = null;
        final String defProp = defaultURLString;
        urlString = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.configURL", defProp);
            }
        });
        if (urlString == null) {
            return null;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            System.out.println(e);
            return null;
        }
        return url;
    }

    private static class ReadOnlyIterator
    implements Iterator {
        private Iterator i;

        ReadOnlyIterator(Iterator i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadOnlySet
    extends AbstractSet {
        Collection collection = null;

        ReadOnlySet(Collection c) {
            this.collection = c;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public Iterator iterator() {
            return new ReadOnlyIterator(this.collection.iterator());
        }
    }

    private static class ReadOnlyMap
    extends AbstractMap {
        HashMap map;
        private Set entrySet = null;

        ReadOnlyMap(Map map) {
            this.map = new HashMap(map);
        }

        @Override
        public Object get(Object key) {
            return this.map.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new ReadOnlySet(this.map.entrySet());
            }
            return this.entrySet;
        }
    }

    private static class ConfigAlias
    extends ConfigObject {
        ConfigAlias(String baseName, String instanceName, ConfigObject targ) {
            this.baseName = baseName;
            this.instanceName = instanceName;
            this.isAlias = true;
            this.original = targ;
            targ.aliases.add(instanceName);
        }
    }
}

